/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.formation.Gs2FormationRestClient;
import io.gs2.formation.domain.iterator.DescribeNamespacesIterator;
import io.gs2.formation.domain.model.FormDomain;
import io.gs2.formation.domain.model.MoldDomain;
import io.gs2.formation.domain.model.NamespaceDomain;
import io.gs2.formation.domain.model.UserDomain;
import io.gs2.formation.request.AcquireActionsToFormPropertiesRequest;
import io.gs2.formation.request.AddMoldCapacityByUserIdRequest;
import io.gs2.formation.request.CreateNamespaceRequest;
import io.gs2.formation.request.SetMoldCapacityByUserIdRequest;
import io.gs2.formation.result.AcquireActionsToFormPropertiesResult;
import io.gs2.formation.result.AddMoldCapacityByUserIdResult;
import io.gs2.formation.result.CreateNamespaceResult;
import io.gs2.formation.result.SetMoldCapacityByUserIdResult;
import io.gs2.jobQueue.model.Job;
import io.gs2.jobQueue.model.JobResultBody;

public class Gs2Formation {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2FormationRestClient client;
    private final String parentKey;

    public Gs2Formation(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2FormationRestClient(session);
        this.parentKey = "formation";
    }

    public NamespaceDomain createNamespace(CreateNamespaceRequest request) {
        CreateNamespaceResult result = this.client.createNamespace(request);
        String parentKey = "formation:Namespace";
        if (result.getItem() != null) {
            this.cache.put(parentKey, NamespaceDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, result.getItem().getName());
        return domain;
    }

    public DescribeNamespacesIterator namespaces() {
        return new DescribeNamespacesIterator(this.cache, this.client);
    }

    public NamespaceDomain namespace(String namespaceName) {
        return new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, namespaceName);
    }

    public static void updateCacheFromStampSheet(CacheDatabase cache, String method, String request, String result) {
        try {
            switch (method) {
                case "AddMoldCapacityByUserId": {
                    AddMoldCapacityByUserIdRequest requestModel = AddMoldCapacityByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    AddMoldCapacityByUserIdResult resultModel = AddMoldCapacityByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Mold");
                    String key = MoldDomain.createCacheKey(resultModel.getItem().getName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "SetMoldCapacityByUserId": {
                    SetMoldCapacityByUserIdRequest requestModel = SetMoldCapacityByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    SetMoldCapacityByUserIdResult resultModel = SetMoldCapacityByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Mold");
                    String key = MoldDomain.createCacheKey(resultModel.getItem().getName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "AcquireActionsToFormProperties": {
                    AcquireActionsToFormPropertiesRequest requestModel = AcquireActionsToFormPropertiesRequest.fromJson(new ObjectMapper().readTree(request));
                    AcquireActionsToFormPropertiesResult resultModel = AcquireActionsToFormPropertiesResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = MoldDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), requestModel.getUserId().toString(), requestModel.getMoldName().toString(), "Form");
                    String key = FormDomain.createCacheKey(resultModel.getItem().getIndex().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static void updateCacheFromStampTask(CacheDatabase cache, String method, String request, String result) {
    }

    public static void updateCacheFromJobResult(CacheDatabase cache, String method, Job job, JobResultBody result) {
        try {
            switch (method) {
                case "add_mold_capacity_by_user_id": {
                    AddMoldCapacityByUserIdRequest requestModel = AddMoldCapacityByUserIdRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    AddMoldCapacityByUserIdResult resultModel = AddMoldCapacityByUserIdResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Mold");
                    String key = MoldDomain.createCacheKey(resultModel.getItem().getName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "set_mold_capacity_by_user_id": {
                    SetMoldCapacityByUserIdRequest requestModel = SetMoldCapacityByUserIdRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    SetMoldCapacityByUserIdResult resultModel = SetMoldCapacityByUserIdResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Mold");
                    String key = MoldDomain.createCacheKey(resultModel.getItem().getName().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "acquire_actions_to_form_properties": {
                    AcquireActionsToFormPropertiesRequest requestModel = AcquireActionsToFormPropertiesRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    AcquireActionsToFormPropertiesResult resultModel = AcquireActionsToFormPropertiesResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    String parentKey = MoldDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), requestModel.getUserId().toString(), requestModel.getMoldName().toString(), "Form");
                    String key = FormDomain.createCacheKey(resultModel.getItem().getIndex().toString());
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }
}

