/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.experience.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.experience.Gs2ExperienceRestClient;
import io.gs2.experience.domain.model.NamespaceDomain;
import io.gs2.experience.model.ThresholdMaster;
import io.gs2.experience.request.DeleteThresholdMasterRequest;
import io.gs2.experience.request.GetThresholdMasterRequest;
import io.gs2.experience.request.UpdateThresholdMasterRequest;
import io.gs2.experience.result.DeleteThresholdMasterResult;
import io.gs2.experience.result.GetThresholdMasterResult;
import io.gs2.experience.result.UpdateThresholdMasterResult;

public class ThresholdMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ExperienceRestClient client;
    private final String namespaceName;
    private final String thresholdName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getThresholdName() {
        return this.thresholdName;
    }

    public ThresholdMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String thresholdName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ExperienceRestClient(session);
        this.namespaceName = namespaceName;
        this.thresholdName = thresholdName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "ThresholdMaster");
    }

    private ThresholdMaster get(GetThresholdMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withThresholdName(this.thresholdName);
        GetThresholdMasterResult result = this.client.getThresholdMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ThresholdMasterDomain.createCacheKey(request.getThresholdName() != null ? request.getThresholdName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public ThresholdMasterDomain update(UpdateThresholdMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withThresholdName(this.thresholdName);
        UpdateThresholdMasterResult result = this.client.updateThresholdMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ThresholdMasterDomain.createCacheKey(request.getThresholdName() != null ? request.getThresholdName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ThresholdMasterDomain domain = this;
        return domain;
    }

    public ThresholdMasterDomain delete(DeleteThresholdMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withThresholdName(this.thresholdName);
        DeleteThresholdMasterResult result = null;
        try {
            result = this.client.deleteThresholdMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, ThresholdMasterDomain.createCacheKey(request.getThresholdName() != null ? request.getThresholdName().toString() : null), ThresholdMaster.class);
        ThresholdMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String thresholdName, String childType) {
        return String.join((CharSequence)":", "experience", namespaceName, thresholdName, childType);
    }

    public static String createCacheKey(String thresholdName) {
        return String.join((CharSequence)":", thresholdName);
    }

    public ThresholdMaster model() {
        ThresholdMaster value = this.cache.get(this.parentKey, ThresholdMasterDomain.createCacheKey(this.getThresholdName() != null ? this.getThresholdName().toString() : null), ThresholdMaster.class);
        if (value == null) {
            try {
                this.get(new GetThresholdMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ThresholdMasterDomain.createCacheKey(this.getThresholdName() != null ? this.getThresholdName().toString() : null), ThresholdMaster.class);
            }
            value = this.cache.get(this.parentKey, ThresholdMasterDomain.createCacheKey(this.getThresholdName() != null ? this.getThresholdName().toString() : null), ThresholdMaster.class);
        }
        return value;
    }
}

