/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.experience.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.experience.Gs2ExperienceRestClient;
import io.gs2.experience.domain.model.UserDomain;
import io.gs2.experience.model.Status;
import io.gs2.experience.request.AddExperienceByUserIdRequest;
import io.gs2.experience.request.AddRankCapByUserIdRequest;
import io.gs2.experience.request.DeleteStatusByUserIdRequest;
import io.gs2.experience.request.GetStatusByUserIdRequest;
import io.gs2.experience.request.GetStatusWithSignatureByUserIdRequest;
import io.gs2.experience.request.SetExperienceByUserIdRequest;
import io.gs2.experience.request.SetRankCapByUserIdRequest;
import io.gs2.experience.result.AddExperienceByUserIdResult;
import io.gs2.experience.result.AddRankCapByUserIdResult;
import io.gs2.experience.result.DeleteStatusByUserIdResult;
import io.gs2.experience.result.GetStatusByUserIdResult;
import io.gs2.experience.result.GetStatusWithSignatureByUserIdResult;
import io.gs2.experience.result.SetExperienceByUserIdResult;
import io.gs2.experience.result.SetRankCapByUserIdResult;

public class StatusDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ExperienceRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String experienceName;
    private final String propertyId;
    private final String parentKey;
    String body;
    String signature;

    public String getBody() {
        return this.body;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getExperienceName() {
        return this.experienceName;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public StatusDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String experienceName, String propertyId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ExperienceRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.experienceName = experienceName;
        this.propertyId = propertyId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Status");
    }

    private Status get(GetStatusByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withExperienceName(this.experienceName).withPropertyId(this.propertyId);
        GetStatusByUserIdResult result = this.client.getStatusByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StatusDomain.createCacheKey(request.getExperienceName() != null ? request.getExperienceName().toString() : null, request.getPropertyId() != null ? request.getPropertyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public StatusDomain getWithSignature(GetStatusWithSignatureByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withExperienceName(this.experienceName).withPropertyId(this.propertyId);
        GetStatusWithSignatureByUserIdResult result = this.client.getStatusWithSignatureByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StatusDomain.createCacheKey(request.getExperienceName() != null ? request.getExperienceName().toString() : null, request.getPropertyId() != null ? request.getPropertyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StatusDomain domain = this;
        domain.body = result.getBody();
        domain.signature = result.getSignature();
        return domain;
    }

    public StatusDomain addExperience(AddExperienceByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withExperienceName(this.experienceName).withPropertyId(this.propertyId);
        AddExperienceByUserIdResult result = this.client.addExperienceByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StatusDomain.createCacheKey(request.getExperienceName() != null ? request.getExperienceName().toString() : null, request.getPropertyId() != null ? request.getPropertyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StatusDomain domain = this;
        return domain;
    }

    public StatusDomain setExperience(SetExperienceByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withExperienceName(this.experienceName).withPropertyId(this.propertyId);
        SetExperienceByUserIdResult result = this.client.setExperienceByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StatusDomain.createCacheKey(request.getExperienceName() != null ? request.getExperienceName().toString() : null, request.getPropertyId() != null ? request.getPropertyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StatusDomain domain = this;
        return domain;
    }

    public StatusDomain addRankCap(AddRankCapByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withExperienceName(this.experienceName).withPropertyId(this.propertyId);
        AddRankCapByUserIdResult result = this.client.addRankCapByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StatusDomain.createCacheKey(request.getExperienceName() != null ? request.getExperienceName().toString() : null, request.getPropertyId() != null ? request.getPropertyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StatusDomain domain = this;
        return domain;
    }

    public StatusDomain setRankCap(SetRankCapByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withExperienceName(this.experienceName).withPropertyId(this.propertyId);
        SetRankCapByUserIdResult result = this.client.setRankCapByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StatusDomain.createCacheKey(request.getExperienceName() != null ? request.getExperienceName().toString() : null, request.getPropertyId() != null ? request.getPropertyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StatusDomain domain = this;
        return domain;
    }

    public StatusDomain delete(DeleteStatusByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withExperienceName(this.experienceName).withPropertyId(this.propertyId);
        DeleteStatusByUserIdResult result = null;
        try {
            result = this.client.deleteStatusByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, StatusDomain.createCacheKey(request.getExperienceName() != null ? request.getExperienceName().toString() : null, request.getPropertyId() != null ? request.getPropertyId().toString() : null), Status.class);
        StatusDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String experienceName, String propertyId, String childType) {
        return String.join((CharSequence)":", "experience", namespaceName, userId, experienceName, propertyId, childType);
    }

    public static String createCacheKey(String experienceName, String propertyId) {
        return String.join((CharSequence)":", experienceName, propertyId);
    }

    public Status model() {
        Status value = this.cache.get(this.parentKey, StatusDomain.createCacheKey(this.getExperienceName() != null ? this.getExperienceName().toString() : null, this.getPropertyId() != null ? this.getPropertyId().toString() : null), Status.class);
        if (value == null) {
            try {
                this.get(new GetStatusByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, StatusDomain.createCacheKey(this.getExperienceName() != null ? this.getExperienceName().toString() : null, this.getPropertyId() != null ? this.getPropertyId().toString() : null), Status.class);
            }
            value = this.cache.get(this.parentKey, StatusDomain.createCacheKey(this.getExperienceName() != null ? this.getExperienceName().toString() : null, this.getPropertyId() != null ? this.getPropertyId().toString() : null), Status.class);
        }
        return value;
    }
}

