/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.experience.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.experience.Gs2ExperienceRestClient;
import io.gs2.experience.domain.model.StatusDomain;
import io.gs2.experience.domain.model.UserDomain;
import io.gs2.experience.model.Status;
import io.gs2.experience.request.GetStatusRequest;
import io.gs2.experience.request.GetStatusWithSignatureRequest;
import io.gs2.experience.result.GetStatusResult;
import io.gs2.experience.result.GetStatusWithSignatureResult;

public class StatusAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ExperienceRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String experienceName;
    private final String propertyId;
    private final String parentKey;
    String body;
    String signature;

    public String getBody() {
        return this.body;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getExperienceName() {
        return this.experienceName;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public StatusAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String experienceName, String propertyId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ExperienceRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.experienceName = experienceName;
        this.propertyId = propertyId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Status");
    }

    private Status get(GetStatusRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withExperienceName(this.experienceName).withPropertyId(this.propertyId);
        GetStatusResult result = this.client.getStatus(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StatusDomain.createCacheKey(request.getExperienceName() != null ? request.getExperienceName().toString() : null, request.getPropertyId() != null ? request.getPropertyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public StatusAccessTokenDomain getWithSignature(GetStatusWithSignatureRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withExperienceName(this.experienceName).withPropertyId(this.propertyId);
        GetStatusWithSignatureResult result = this.client.getStatusWithSignature(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StatusDomain.createCacheKey(request.getExperienceName() != null ? request.getExperienceName().toString() : null, request.getPropertyId() != null ? request.getPropertyId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StatusAccessTokenDomain domain = this;
        domain.body = result.getBody();
        domain.signature = result.getSignature();
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String experienceName, String propertyId, String childType) {
        return String.join((CharSequence)":", "experience", namespaceName, userId, experienceName, propertyId, childType);
    }

    public static String createCacheKey(String experienceName, String propertyId) {
        return String.join((CharSequence)":", experienceName, propertyId);
    }

    public Status model() {
        Status value = this.cache.get(this.parentKey, StatusDomain.createCacheKey(this.getExperienceName() != null ? this.getExperienceName().toString() : null, this.getPropertyId() != null ? this.getPropertyId().toString() : null), Status.class);
        if (value == null) {
            try {
                this.get(new GetStatusRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, StatusDomain.createCacheKey(this.getExperienceName() != null ? this.getExperienceName().toString() : null, this.getPropertyId() != null ? this.getPropertyId().toString() : null), Status.class);
            }
            value = this.cache.get(this.parentKey, StatusDomain.createCacheKey(this.getExperienceName() != null ? this.getExperienceName().toString() : null, this.getPropertyId() != null ? this.getPropertyId().toString() : null), Status.class);
        }
        return value;
    }
}

