/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.experience.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.experience.Gs2ExperienceRestClient;
import io.gs2.experience.domain.model.NamespaceDomain;
import io.gs2.experience.model.CurrentExperienceMaster;
import io.gs2.experience.request.ExportMasterRequest;
import io.gs2.experience.request.GetCurrentExperienceMasterRequest;
import io.gs2.experience.request.UpdateCurrentExperienceMasterFromGitHubRequest;
import io.gs2.experience.request.UpdateCurrentExperienceMasterRequest;
import io.gs2.experience.result.ExportMasterResult;
import io.gs2.experience.result.GetCurrentExperienceMasterResult;
import io.gs2.experience.result.UpdateCurrentExperienceMasterFromGitHubResult;
import io.gs2.experience.result.UpdateCurrentExperienceMasterResult;

public class CurrentExperienceMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ExperienceRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentExperienceMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ExperienceRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentExperienceMaster");
    }

    public CurrentExperienceMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentExperienceMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentExperienceMasterDomain domain = this;
        return domain;
    }

    private CurrentExperienceMaster get(GetCurrentExperienceMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentExperienceMasterResult result = this.client.getCurrentExperienceMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentExperienceMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentExperienceMasterDomain update(UpdateCurrentExperienceMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentExperienceMasterResult result = this.client.updateCurrentExperienceMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentExperienceMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentExperienceMasterDomain domain = this;
        return domain;
    }

    public CurrentExperienceMasterDomain updateFromGitHub(UpdateCurrentExperienceMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentExperienceMasterFromGitHubResult result = this.client.updateCurrentExperienceMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentExperienceMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentExperienceMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "experience", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public CurrentExperienceMaster model() {
        CurrentExperienceMaster value = this.cache.get(this.parentKey, CurrentExperienceMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentExperienceMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentExperienceMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentExperienceMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentExperienceMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentExperienceMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentExperienceMaster.class);
        }
        return value;
    }
}

