/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.experience.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.experience.Gs2ExperienceRestClient;
import io.gs2.experience.domain.model.NamespaceDomain;
import io.gs2.experience.domain.model.ThresholdMasterDomain;
import io.gs2.experience.model.ThresholdMaster;
import io.gs2.experience.request.DescribeThresholdMastersRequest;
import io.gs2.experience.result.DescribeThresholdMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeThresholdMastersIterator
implements Iterator<ThresholdMaster>,
Iterable<ThresholdMaster> {
    CacheDatabase cache;
    Gs2ExperienceRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<ThresholdMaster> result;
    Integer fetchSize;

    public DescribeThresholdMastersIterator(CacheDatabase cache, Gs2ExperienceRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<ThresholdMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "ThresholdMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, ThresholdMaster.class)) {
            this.result = this.cache.list(parentKey, ThresholdMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeThresholdMastersResult r = this.client.describeThresholdMasters(new DescribeThresholdMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (ThresholdMaster item : this.result) {
                this.cache.put(parentKey, ThresholdMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, ThresholdMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public ThresholdMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        ThresholdMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<ThresholdMaster> iterator() {
        return this;
    }
}

