/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.experience.domain.iterator;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.experience.Gs2ExperienceRestClient;
import io.gs2.experience.domain.model.StatusDomain;
import io.gs2.experience.domain.model.UserDomain;
import io.gs2.experience.model.Status;
import io.gs2.experience.request.DescribeStatusesRequest;
import io.gs2.experience.result.DescribeStatusesResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeStatusesIterator
implements Iterator<Status>,
Iterable<Status> {
    CacheDatabase cache;
    Gs2ExperienceRestClient client;
    String namespaceName;
    String experienceName;
    AccessToken accessToken;
    String pageToken;
    boolean last;
    List<Status> result;
    Integer fetchSize;

    public DescribeStatusesIterator(CacheDatabase cache, Gs2ExperienceRestClient client, String namespaceName, String experienceName, AccessToken accessToken) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.experienceName = experienceName;
        this.accessToken = accessToken;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Status>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Status");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Status.class)) {
            this.result = this.cache.list(parentKey, Status.class).stream().filter(item -> this.experienceName == null || item.getExperienceName().equals(this.experienceName)).collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeStatusesResult r = this.client.describeStatuses(new DescribeStatusesRequest().withNamespaceName(this.namespaceName).withExperienceName(this.experienceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Status item2 : this.result) {
                this.cache.put(parentKey, StatusDomain.createCacheKey(item2.getExperienceName() != null ? item2.getExperienceName().toString() : null, item2.getPropertyId() != null ? item2.getPropertyId().toString() : null), item2, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Status.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Status next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Status ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Status> iterator() {
        return this;
    }
}

