/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.exchange.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.exchange.Gs2ExchangeRestClient;
import io.gs2.exchange.domain.model.NamespaceDomain;
import io.gs2.exchange.model.CurrentRateMaster;
import io.gs2.exchange.request.ExportMasterRequest;
import io.gs2.exchange.request.GetCurrentRateMasterRequest;
import io.gs2.exchange.request.UpdateCurrentRateMasterFromGitHubRequest;
import io.gs2.exchange.request.UpdateCurrentRateMasterRequest;
import io.gs2.exchange.result.ExportMasterResult;
import io.gs2.exchange.result.GetCurrentRateMasterResult;
import io.gs2.exchange.result.UpdateCurrentRateMasterFromGitHubResult;
import io.gs2.exchange.result.UpdateCurrentRateMasterResult;

public class CurrentRateMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ExchangeRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentRateMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ExchangeRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentRateMaster");
    }

    public CurrentRateMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentRateMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentRateMasterDomain domain = this;
        return domain;
    }

    private CurrentRateMaster get(GetCurrentRateMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentRateMasterResult result = this.client.getCurrentRateMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentRateMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentRateMasterDomain update(UpdateCurrentRateMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentRateMasterResult result = this.client.updateCurrentRateMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentRateMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentRateMasterDomain domain = this;
        return domain;
    }

    public CurrentRateMasterDomain updateFromGitHub(UpdateCurrentRateMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentRateMasterFromGitHubResult result = this.client.updateCurrentRateMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentRateMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentRateMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "exchange", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public CurrentRateMaster model() {
        CurrentRateMaster value = this.cache.get(this.parentKey, CurrentRateMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentRateMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentRateMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentRateMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentRateMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentRateMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentRateMaster.class);
        }
        return value;
    }
}

