/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.exchange.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.domain.StampSheetDomain;
import io.gs2.core.exception.Gs2Exception;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.exception.TransactionException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.exchange.Gs2ExchangeRestClient;
import io.gs2.exchange.domain.model.UserDomain;
import io.gs2.exchange.model.Await;
import io.gs2.exchange.request.AcquireByUserIdRequest;
import io.gs2.exchange.request.AcquireForceByUserIdRequest;
import io.gs2.exchange.request.DeleteAwaitByUserIdRequest;
import io.gs2.exchange.request.GetAwaitByUserIdRequest;
import io.gs2.exchange.request.SkipByUserIdRequest;
import io.gs2.exchange.result.AcquireByUserIdResult;
import io.gs2.exchange.result.AcquireForceByUserIdResult;
import io.gs2.exchange.result.DeleteAwaitByUserIdResult;
import io.gs2.exchange.result.GetAwaitByUserIdResult;
import io.gs2.exchange.result.SkipByUserIdResult;

public class AwaitDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ExchangeRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String awaitName;
    private final String rateName;
    private final String parentKey;
    Long unlockAt;

    public Long getUnlockAt() {
        return this.unlockAt;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAwaitName() {
        return this.awaitName;
    }

    public String getRateName() {
        return this.rateName;
    }

    public AwaitDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String awaitName, String rateName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ExchangeRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.awaitName = awaitName;
        this.rateName = rateName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Await");
    }

    private Await get(GetAwaitByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withAwaitName(this.awaitName).withRateName(this.rateName);
        GetAwaitByUserIdResult result = this.client.getAwaitByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, AwaitDomain.createCacheKey(request.getAwaitName() != null ? request.getAwaitName().toString() : null, request.getRateName() != null ? request.getRateName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public StampSheetDomain acquire(AcquireByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withAwaitName(this.awaitName).withRateName(this.rateName);
        AcquireByUserIdResult result = this.client.acquireByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, AwaitDomain.createCacheKey(request.getAwaitName() != null ? request.getAwaitName().toString() : null, request.getRateName() != null ? request.getRateName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public StampSheetDomain acquireForce(AcquireForceByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withAwaitName(this.awaitName).withRateName(this.rateName);
        AcquireForceByUserIdResult result = this.client.acquireForceByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, AwaitDomain.createCacheKey(request.getAwaitName() != null ? request.getAwaitName().toString() : null, request.getRateName() != null ? request.getRateName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public StampSheetDomain skip(SkipByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withAwaitName(this.awaitName).withRateName(this.rateName);
        SkipByUserIdResult result = this.client.skipByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, AwaitDomain.createCacheKey(request.getAwaitName() != null ? request.getAwaitName().toString() : null, request.getRateName() != null ? request.getRateName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public AwaitDomain delete(DeleteAwaitByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withAwaitName(this.awaitName).withRateName(this.rateName);
        DeleteAwaitByUserIdResult result = null;
        try {
            result = this.client.deleteAwaitByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, AwaitDomain.createCacheKey(request.getAwaitName() != null ? request.getAwaitName().toString() : null, request.getRateName() != null ? request.getRateName().toString() : null), Await.class);
        AwaitDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String awaitName, String rateName, String childType) {
        return String.join((CharSequence)":", "exchange", namespaceName, userId, awaitName, rateName, childType);
    }

    public static String createCacheKey(String awaitName, String rateName) {
        return String.join((CharSequence)":", awaitName, rateName);
    }

    public Await model() {
        Await value = this.cache.get(this.parentKey, AwaitDomain.createCacheKey(this.getAwaitName() != null ? this.getAwaitName().toString() : null, this.getRateName() != null ? this.getRateName().toString() : null), Await.class);
        if (value == null) {
            try {
                this.get(new GetAwaitByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, AwaitDomain.createCacheKey(this.getAwaitName() != null ? this.getAwaitName().toString() : null, this.getRateName() != null ? this.getRateName().toString() : null), Await.class);
            }
            value = this.cache.get(this.parentKey, AwaitDomain.createCacheKey(this.getAwaitName() != null ? this.getAwaitName().toString() : null, this.getRateName() != null ? this.getRateName().toString() : null), Await.class);
        }
        return value;
    }
}

