/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.exchange.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.exchange.Gs2ExchangeRestClient;
import io.gs2.exchange.domain.model.NamespaceDomain;
import io.gs2.exchange.domain.model.RateModelDomain;
import io.gs2.exchange.model.RateModel;
import io.gs2.exchange.request.DescribeRateModelsRequest;
import io.gs2.exchange.result.DescribeRateModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeRateModelsIterator
implements Iterator<RateModel>,
Iterable<RateModel> {
    CacheDatabase cache;
    Gs2ExchangeRestClient client;
    String namespaceName;
    boolean last;
    List<RateModel> result;
    Integer fetchSize;

    public DescribeRateModelsIterator(CacheDatabase cache, Gs2ExchangeRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<RateModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "RateModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, RateModel.class)) {
            this.result = this.cache.list(parentKey, RateModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeRateModelsResult r = this.client.describeRateModels(new DescribeRateModelsRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (RateModel item : this.result) {
                this.cache.put(parentKey, RateModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, RateModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public RateModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        RateModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<RateModel> iterator() {
        return this;
    }
}

