/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.exchange.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.exchange.Gs2ExchangeRestClient;
import io.gs2.exchange.domain.model.AwaitDomain;
import io.gs2.exchange.domain.model.UserDomain;
import io.gs2.exchange.model.Await;
import io.gs2.exchange.request.DescribeAwaitsByUserIdRequest;
import io.gs2.exchange.result.DescribeAwaitsByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeAwaitsByUserIdIterator
implements Iterator<Await>,
Iterable<Await> {
    CacheDatabase cache;
    Gs2ExchangeRestClient client;
    String namespaceName;
    String userId;
    String rateName;
    String pageToken;
    boolean last;
    List<Await> result;
    Integer fetchSize;

    public DescribeAwaitsByUserIdIterator(CacheDatabase cache, Gs2ExchangeRestClient client, String namespaceName, String userId, String rateName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.rateName = rateName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Await>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Await");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Await.class)) {
            this.result = this.cache.list(parentKey, Await.class).stream().filter(item -> this.rateName == null || item.getRateName().equals(this.rateName)).collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeAwaitsByUserIdResult r = this.client.describeAwaitsByUserId(new DescribeAwaitsByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withRateName(this.rateName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Await item2 : this.result) {
                this.cache.put(parentKey, AwaitDomain.createCacheKey(item2.getName() != null ? item2.getName().toString() : null, item2.getRateName() != null ? item2.getRateName().toString() : null), item2, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Await.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Await next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Await ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Await> iterator() {
        return this;
    }
}

