/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.exchange;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.exchange.request.AcquireByUserIdRequest;
import io.gs2.exchange.request.AcquireForceByUserIdRequest;
import io.gs2.exchange.request.AcquireRequest;
import io.gs2.exchange.request.CreateAwaitByStampSheetRequest;
import io.gs2.exchange.request.CreateAwaitByUserIdRequest;
import io.gs2.exchange.request.CreateNamespaceRequest;
import io.gs2.exchange.request.CreateRateModelMasterRequest;
import io.gs2.exchange.request.DeleteAwaitByStampTaskRequest;
import io.gs2.exchange.request.DeleteAwaitByUserIdRequest;
import io.gs2.exchange.request.DeleteAwaitRequest;
import io.gs2.exchange.request.DeleteNamespaceRequest;
import io.gs2.exchange.request.DeleteRateModelMasterRequest;
import io.gs2.exchange.request.DescribeAwaitsByUserIdRequest;
import io.gs2.exchange.request.DescribeAwaitsRequest;
import io.gs2.exchange.request.DescribeNamespacesRequest;
import io.gs2.exchange.request.DescribeRateModelMastersRequest;
import io.gs2.exchange.request.DescribeRateModelsRequest;
import io.gs2.exchange.request.ExchangeByStampSheetRequest;
import io.gs2.exchange.request.ExchangeByUserIdRequest;
import io.gs2.exchange.request.ExchangeRequest;
import io.gs2.exchange.request.ExportMasterRequest;
import io.gs2.exchange.request.GetAwaitByUserIdRequest;
import io.gs2.exchange.request.GetAwaitRequest;
import io.gs2.exchange.request.GetCurrentRateMasterRequest;
import io.gs2.exchange.request.GetNamespaceRequest;
import io.gs2.exchange.request.GetNamespaceStatusRequest;
import io.gs2.exchange.request.GetRateModelMasterRequest;
import io.gs2.exchange.request.GetRateModelRequest;
import io.gs2.exchange.request.SkipByUserIdRequest;
import io.gs2.exchange.request.SkipRequest;
import io.gs2.exchange.request.UpdateCurrentRateMasterFromGitHubRequest;
import io.gs2.exchange.request.UpdateCurrentRateMasterRequest;
import io.gs2.exchange.request.UpdateNamespaceRequest;
import io.gs2.exchange.request.UpdateRateModelMasterRequest;
import io.gs2.exchange.result.AcquireByUserIdResult;
import io.gs2.exchange.result.AcquireForceByUserIdResult;
import io.gs2.exchange.result.AcquireResult;
import io.gs2.exchange.result.CreateAwaitByStampSheetResult;
import io.gs2.exchange.result.CreateAwaitByUserIdResult;
import io.gs2.exchange.result.CreateNamespaceResult;
import io.gs2.exchange.result.CreateRateModelMasterResult;
import io.gs2.exchange.result.DeleteAwaitByStampTaskResult;
import io.gs2.exchange.result.DeleteAwaitByUserIdResult;
import io.gs2.exchange.result.DeleteAwaitResult;
import io.gs2.exchange.result.DeleteNamespaceResult;
import io.gs2.exchange.result.DeleteRateModelMasterResult;
import io.gs2.exchange.result.DescribeAwaitsByUserIdResult;
import io.gs2.exchange.result.DescribeAwaitsResult;
import io.gs2.exchange.result.DescribeNamespacesResult;
import io.gs2.exchange.result.DescribeRateModelMastersResult;
import io.gs2.exchange.result.DescribeRateModelsResult;
import io.gs2.exchange.result.ExchangeByStampSheetResult;
import io.gs2.exchange.result.ExchangeByUserIdResult;
import io.gs2.exchange.result.ExchangeResult;
import io.gs2.exchange.result.ExportMasterResult;
import io.gs2.exchange.result.GetAwaitByUserIdResult;
import io.gs2.exchange.result.GetAwaitResult;
import io.gs2.exchange.result.GetCurrentRateMasterResult;
import io.gs2.exchange.result.GetNamespaceResult;
import io.gs2.exchange.result.GetNamespaceStatusResult;
import io.gs2.exchange.result.GetRateModelMasterResult;
import io.gs2.exchange.result.GetRateModelResult;
import io.gs2.exchange.result.SkipByUserIdResult;
import io.gs2.exchange.result.SkipResult;
import io.gs2.exchange.result.UpdateCurrentRateMasterFromGitHubResult;
import io.gs2.exchange.result.UpdateCurrentRateMasterResult;
import io.gs2.exchange.result.UpdateNamespaceResult;
import io.gs2.exchange.result.UpdateRateModelMasterResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2ExchangeRestClient
extends AbstractGs2Client<Gs2ExchangeRestClient> {
    public Gs2ExchangeRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeRateModelsAsync(DescribeRateModelsRequest request, AsyncAction<AsyncResult<DescribeRateModelsResult>> callback) {
        DescribeRateModelsTask task = new DescribeRateModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRateModelsResult describeRateModels(DescribeRateModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRateModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRateModelsResult)resultAsyncResult[0].getResult();
    }

    public void getRateModelAsync(GetRateModelRequest request, AsyncAction<AsyncResult<GetRateModelResult>> callback) {
        GetRateModelTask task = new GetRateModelTask(request, callback);
        this.session.execute(task);
    }

    public GetRateModelResult getRateModel(GetRateModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRateModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRateModelResult)resultAsyncResult[0].getResult();
    }

    public void describeRateModelMastersAsync(DescribeRateModelMastersRequest request, AsyncAction<AsyncResult<DescribeRateModelMastersResult>> callback) {
        DescribeRateModelMastersTask task = new DescribeRateModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRateModelMastersResult describeRateModelMasters(DescribeRateModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRateModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRateModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createRateModelMasterAsync(CreateRateModelMasterRequest request, AsyncAction<AsyncResult<CreateRateModelMasterResult>> callback) {
        CreateRateModelMasterTask task = new CreateRateModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateRateModelMasterResult createRateModelMaster(CreateRateModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createRateModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateRateModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getRateModelMasterAsync(GetRateModelMasterRequest request, AsyncAction<AsyncResult<GetRateModelMasterResult>> callback) {
        GetRateModelMasterTask task = new GetRateModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetRateModelMasterResult getRateModelMaster(GetRateModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRateModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRateModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateRateModelMasterAsync(UpdateRateModelMasterRequest request, AsyncAction<AsyncResult<UpdateRateModelMasterResult>> callback) {
        UpdateRateModelMasterTask task = new UpdateRateModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateRateModelMasterResult updateRateModelMaster(UpdateRateModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateRateModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateRateModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteRateModelMasterAsync(DeleteRateModelMasterRequest request, AsyncAction<AsyncResult<DeleteRateModelMasterResult>> callback) {
        DeleteRateModelMasterTask task = new DeleteRateModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteRateModelMasterResult deleteRateModelMaster(DeleteRateModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteRateModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteRateModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void exchangeAsync(ExchangeRequest request, AsyncAction<AsyncResult<ExchangeResult>> callback) {
        ExchangeTask task = new ExchangeTask(request, callback);
        this.session.execute(task);
    }

    public ExchangeResult exchange(ExchangeRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exchangeAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExchangeResult)resultAsyncResult[0].getResult();
    }

    public void exchangeByUserIdAsync(ExchangeByUserIdRequest request, AsyncAction<AsyncResult<ExchangeByUserIdResult>> callback) {
        ExchangeByUserIdTask task = new ExchangeByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ExchangeByUserIdResult exchangeByUserId(ExchangeByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exchangeByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExchangeByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void exchangeByStampSheetAsync(ExchangeByStampSheetRequest request, AsyncAction<AsyncResult<ExchangeByStampSheetResult>> callback) {
        ExchangeByStampSheetTask task = new ExchangeByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public ExchangeByStampSheetResult exchangeByStampSheet(ExchangeByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exchangeByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExchangeByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentRateMasterAsync(GetCurrentRateMasterRequest request, AsyncAction<AsyncResult<GetCurrentRateMasterResult>> callback) {
        GetCurrentRateMasterTask task = new GetCurrentRateMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentRateMasterResult getCurrentRateMaster(GetCurrentRateMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentRateMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentRateMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentRateMasterAsync(UpdateCurrentRateMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentRateMasterResult>> callback) {
        UpdateCurrentRateMasterTask task = new UpdateCurrentRateMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentRateMasterResult updateCurrentRateMaster(UpdateCurrentRateMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentRateMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentRateMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentRateMasterFromGitHubAsync(UpdateCurrentRateMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentRateMasterFromGitHubResult>> callback) {
        UpdateCurrentRateMasterFromGitHubTask task = new UpdateCurrentRateMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentRateMasterFromGitHubResult updateCurrentRateMasterFromGitHub(UpdateCurrentRateMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentRateMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentRateMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    public void createAwaitByUserIdAsync(CreateAwaitByUserIdRequest request, AsyncAction<AsyncResult<CreateAwaitByUserIdResult>> callback) {
        CreateAwaitByUserIdTask task = new CreateAwaitByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CreateAwaitByUserIdResult createAwaitByUserId(CreateAwaitByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createAwaitByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateAwaitByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeAwaitsAsync(DescribeAwaitsRequest request, AsyncAction<AsyncResult<DescribeAwaitsResult>> callback) {
        DescribeAwaitsTask task = new DescribeAwaitsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeAwaitsResult describeAwaits(DescribeAwaitsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeAwaitsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeAwaitsResult)resultAsyncResult[0].getResult();
    }

    public void describeAwaitsByUserIdAsync(DescribeAwaitsByUserIdRequest request, AsyncAction<AsyncResult<DescribeAwaitsByUserIdResult>> callback) {
        DescribeAwaitsByUserIdTask task = new DescribeAwaitsByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeAwaitsByUserIdResult describeAwaitsByUserId(DescribeAwaitsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeAwaitsByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeAwaitsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getAwaitAsync(GetAwaitRequest request, AsyncAction<AsyncResult<GetAwaitResult>> callback) {
        GetAwaitTask task = new GetAwaitTask(request, callback);
        this.session.execute(task);
    }

    public GetAwaitResult getAwait(GetAwaitRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getAwaitAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetAwaitResult)resultAsyncResult[0].getResult();
    }

    public void getAwaitByUserIdAsync(GetAwaitByUserIdRequest request, AsyncAction<AsyncResult<GetAwaitByUserIdResult>> callback) {
        GetAwaitByUserIdTask task = new GetAwaitByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetAwaitByUserIdResult getAwaitByUserId(GetAwaitByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getAwaitByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetAwaitByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void acquireAsync(AcquireRequest request, AsyncAction<AsyncResult<AcquireResult>> callback) {
        AcquireTask task = new AcquireTask(request, callback);
        this.session.execute(task);
    }

    public AcquireResult acquire(AcquireRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.acquireAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AcquireResult)resultAsyncResult[0].getResult();
    }

    public void acquireByUserIdAsync(AcquireByUserIdRequest request, AsyncAction<AsyncResult<AcquireByUserIdResult>> callback) {
        AcquireByUserIdTask task = new AcquireByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public AcquireByUserIdResult acquireByUserId(AcquireByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.acquireByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AcquireByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void acquireForceByUserIdAsync(AcquireForceByUserIdRequest request, AsyncAction<AsyncResult<AcquireForceByUserIdResult>> callback) {
        AcquireForceByUserIdTask task = new AcquireForceByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public AcquireForceByUserIdResult acquireForceByUserId(AcquireForceByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.acquireForceByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AcquireForceByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void skipAsync(SkipRequest request, AsyncAction<AsyncResult<SkipResult>> callback) {
        SkipTask task = new SkipTask(request, callback);
        this.session.execute(task);
    }

    public SkipResult skip(SkipRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.skipAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SkipResult)resultAsyncResult[0].getResult();
    }

    public void skipByUserIdAsync(SkipByUserIdRequest request, AsyncAction<AsyncResult<SkipByUserIdResult>> callback) {
        SkipByUserIdTask task = new SkipByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public SkipByUserIdResult skipByUserId(SkipByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.skipByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SkipByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteAwaitAsync(DeleteAwaitRequest request, AsyncAction<AsyncResult<DeleteAwaitResult>> callback) {
        DeleteAwaitTask task = new DeleteAwaitTask(request, callback);
        this.session.execute(task);
    }

    public DeleteAwaitResult deleteAwait(DeleteAwaitRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteAwaitAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteAwaitResult)resultAsyncResult[0].getResult();
    }

    public void deleteAwaitByUserIdAsync(DeleteAwaitByUserIdRequest request, AsyncAction<AsyncResult<DeleteAwaitByUserIdResult>> callback) {
        DeleteAwaitByUserIdTask task = new DeleteAwaitByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteAwaitByUserIdResult deleteAwaitByUserId(DeleteAwaitByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteAwaitByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteAwaitByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void createAwaitByStampSheetAsync(CreateAwaitByStampSheetRequest request, AsyncAction<AsyncResult<CreateAwaitByStampSheetResult>> callback) {
        CreateAwaitByStampSheetTask task = new CreateAwaitByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public CreateAwaitByStampSheetResult createAwaitByStampSheet(CreateAwaitByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createAwaitByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateAwaitByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void deleteAwaitByStampTaskAsync(DeleteAwaitByStampTaskRequest request, AsyncAction<AsyncResult<DeleteAwaitByStampTaskResult>> callback) {
        DeleteAwaitByStampTaskTask task = new DeleteAwaitByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public DeleteAwaitByStampTaskResult deleteAwaitByStampTask(DeleteAwaitByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteAwaitByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteAwaitByStampTaskResult)resultAsyncResult[0].getResult();
    }

    class DeleteAwaitByStampTaskTask
    extends Gs2RestSessionTask<DeleteAwaitByStampTaskResult> {
        private DeleteAwaitByStampTaskRequest request;

        public DeleteAwaitByStampTaskTask(DeleteAwaitByStampTaskRequest request, AsyncAction<AsyncResult<DeleteAwaitByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteAwaitByStampTaskResult parse(JsonNode data) {
            return DeleteAwaitByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/stamp/await/delete";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", DeleteAwaitByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", DeleteAwaitByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", DeleteAwaitByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateAwaitByStampSheetTask
    extends Gs2RestSessionTask<CreateAwaitByStampSheetResult> {
        private CreateAwaitByStampSheetRequest request;

        public CreateAwaitByStampSheetTask(CreateAwaitByStampSheetRequest request, AsyncAction<AsyncResult<CreateAwaitByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateAwaitByStampSheetResult parse(JsonNode data) {
            return CreateAwaitByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/stamp/await/create";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", CreateAwaitByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", CreateAwaitByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", CreateAwaitByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteAwaitByUserIdTask
    extends Gs2RestSessionTask<DeleteAwaitByUserIdResult> {
        private DeleteAwaitByUserIdRequest request;

        public DeleteAwaitByUserIdTask(DeleteAwaitByUserIdRequest request, AsyncAction<AsyncResult<DeleteAwaitByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteAwaitByUserIdResult parse(JsonNode data) {
            return DeleteAwaitByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/exchange/{rateName}/await/{awaitName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            url = url.replace("{awaitName}", this.request.getAwaitName() == null || this.request.getAwaitName().length() == 0 ? "null" : String.valueOf(this.request.getAwaitName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteAwaitTask
    extends Gs2RestSessionTask<DeleteAwaitResult> {
        private DeleteAwaitRequest request;

        public DeleteAwaitTask(DeleteAwaitRequest request, AsyncAction<AsyncResult<DeleteAwaitResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteAwaitResult parse(JsonNode data) {
            return DeleteAwaitResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/exchange/{rateName}/await/{awaitName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            url = url.replace("{awaitName}", this.request.getAwaitName() == null || this.request.getAwaitName().length() == 0 ? "null" : String.valueOf(this.request.getAwaitName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class SkipByUserIdTask
    extends Gs2RestSessionTask<SkipByUserIdResult> {
        private SkipByUserIdRequest request;

        public SkipByUserIdTask(SkipByUserIdRequest request, AsyncAction<AsyncResult<SkipByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SkipByUserIdResult parse(JsonNode data) {
            return SkipByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/exchange/{rateName}/await/{awaitName}/skip";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            url = url.replace("{awaitName}", this.request.getAwaitName() == null || this.request.getAwaitName().length() == 0 ? "null" : String.valueOf(this.request.getAwaitName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("config", SkipByUserIdTask.this.request.getConfig() == null ? new ArrayList() : SkipByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", SkipByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class SkipTask
    extends Gs2RestSessionTask<SkipResult> {
        private SkipRequest request;

        public SkipTask(SkipRequest request, AsyncAction<AsyncResult<SkipResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SkipResult parse(JsonNode data) {
            return SkipResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/exchange/{rateName}/await/{awaitName}/skip";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            url = url.replace("{awaitName}", this.request.getAwaitName() == null || this.request.getAwaitName().length() == 0 ? "null" : String.valueOf(this.request.getAwaitName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("config", SkipTask.this.request.getConfig() == null ? new ArrayList() : SkipTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", SkipTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class AcquireForceByUserIdTask
    extends Gs2RestSessionTask<AcquireForceByUserIdResult> {
        private AcquireForceByUserIdRequest request;

        public AcquireForceByUserIdTask(AcquireForceByUserIdRequest request, AsyncAction<AsyncResult<AcquireForceByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AcquireForceByUserIdResult parse(JsonNode data) {
            return AcquireForceByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/exchange/{rateName}/await/{awaitName}/force";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            url = url.replace("{awaitName}", this.request.getAwaitName() == null || this.request.getAwaitName().length() == 0 ? "null" : String.valueOf(this.request.getAwaitName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("config", AcquireForceByUserIdTask.this.request.getConfig() == null ? new ArrayList() : AcquireForceByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", AcquireForceByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class AcquireByUserIdTask
    extends Gs2RestSessionTask<AcquireByUserIdResult> {
        private AcquireByUserIdRequest request;

        public AcquireByUserIdTask(AcquireByUserIdRequest request, AsyncAction<AsyncResult<AcquireByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AcquireByUserIdResult parse(JsonNode data) {
            return AcquireByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/exchange/{rateName}/await/{awaitName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            url = url.replace("{awaitName}", this.request.getAwaitName() == null || this.request.getAwaitName().length() == 0 ? "null" : String.valueOf(this.request.getAwaitName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("config", AcquireByUserIdTask.this.request.getConfig() == null ? new ArrayList() : AcquireByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", AcquireByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class AcquireTask
    extends Gs2RestSessionTask<AcquireResult> {
        private AcquireRequest request;

        public AcquireTask(AcquireRequest request, AsyncAction<AsyncResult<AcquireResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AcquireResult parse(JsonNode data) {
            return AcquireResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/exchange/{rateName}/await/{awaitName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            url = url.replace("{awaitName}", this.request.getAwaitName() == null || this.request.getAwaitName().length() == 0 ? "null" : String.valueOf(this.request.getAwaitName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("config", AcquireTask.this.request.getConfig() == null ? new ArrayList() : AcquireTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", AcquireTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetAwaitByUserIdTask
    extends Gs2RestSessionTask<GetAwaitByUserIdResult> {
        private GetAwaitByUserIdRequest request;

        public GetAwaitByUserIdTask(GetAwaitByUserIdRequest request, AsyncAction<AsyncResult<GetAwaitByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetAwaitByUserIdResult parse(JsonNode data) {
            return GetAwaitByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/exchange/{rateName}/await/{awaitName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            url = url.replace("{awaitName}", this.request.getAwaitName() == null || this.request.getAwaitName().length() == 0 ? "null" : String.valueOf(this.request.getAwaitName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetAwaitTask
    extends Gs2RestSessionTask<GetAwaitResult> {
        private GetAwaitRequest request;

        public GetAwaitTask(GetAwaitRequest request, AsyncAction<AsyncResult<GetAwaitResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetAwaitResult parse(JsonNode data) {
            return GetAwaitResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/exchange/{rateName}/await/{awaitName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            url = url.replace("{awaitName}", this.request.getAwaitName() == null || this.request.getAwaitName().length() == 0 ? "null" : String.valueOf(this.request.getAwaitName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeAwaitsByUserIdTask
    extends Gs2RestSessionTask<DescribeAwaitsByUserIdResult> {
        private DescribeAwaitsByUserIdRequest request;

        public DescribeAwaitsByUserIdTask(DescribeAwaitsByUserIdRequest request, AsyncAction<AsyncResult<DescribeAwaitsByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeAwaitsByUserIdResult parse(JsonNode data) {
            return DescribeAwaitsByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/exchange/await";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getRateName() != null) {
                queryStrings.add("rateName=" + EncodingUtil.urlEncode(String.valueOf(this.request.getRateName())));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeAwaitsTask
    extends Gs2RestSessionTask<DescribeAwaitsResult> {
        private DescribeAwaitsRequest request;

        public DescribeAwaitsTask(DescribeAwaitsRequest request, AsyncAction<AsyncResult<DescribeAwaitsResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeAwaitsResult parse(JsonNode data) {
            return DescribeAwaitsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/exchange/await";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getRateName() != null) {
                queryStrings.add("rateName=" + EncodingUtil.urlEncode(String.valueOf(this.request.getRateName())));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class CreateAwaitByUserIdTask
    extends Gs2RestSessionTask<CreateAwaitByUserIdResult> {
        private CreateAwaitByUserIdRequest request;

        public CreateAwaitByUserIdTask(CreateAwaitByUserIdRequest request, AsyncAction<AsyncResult<CreateAwaitByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateAwaitByUserIdResult parse(JsonNode data) {
            return CreateAwaitByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/exchange/{rateName}/await";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("count", CreateAwaitByUserIdTask.this.request.getCount());
                    this.put("contextStack", CreateAwaitByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentRateMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentRateMasterFromGitHubResult> {
        private UpdateCurrentRateMasterFromGitHubRequest request;

        public UpdateCurrentRateMasterFromGitHubTask(UpdateCurrentRateMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentRateMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentRateMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentRateMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentRateMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentRateMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentRateMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentRateMasterTask
    extends Gs2RestSessionTask<UpdateCurrentRateMasterResult> {
        private UpdateCurrentRateMasterRequest request;

        public UpdateCurrentRateMasterTask(UpdateCurrentRateMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentRateMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentRateMasterResult parse(JsonNode data) {
            return UpdateCurrentRateMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentRateMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentRateMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentRateMasterTask
    extends Gs2RestSessionTask<GetCurrentRateMasterResult> {
        private GetCurrentRateMasterRequest request;

        public GetCurrentRateMasterTask(GetCurrentRateMasterRequest request, AsyncAction<AsyncResult<GetCurrentRateMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentRateMasterResult parse(JsonNode data) {
            return GetCurrentRateMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExchangeByStampSheetTask
    extends Gs2RestSessionTask<ExchangeByStampSheetResult> {
        private ExchangeByStampSheetRequest request;

        public ExchangeByStampSheetTask(ExchangeByStampSheetRequest request, AsyncAction<AsyncResult<ExchangeByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExchangeByStampSheetResult parse(JsonNode data) {
            return ExchangeByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/stamp/exchange";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", ExchangeByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", ExchangeByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", ExchangeByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExchangeByUserIdTask
    extends Gs2RestSessionTask<ExchangeByUserIdResult> {
        private ExchangeByUserIdRequest request;

        public ExchangeByUserIdTask(ExchangeByUserIdRequest request, AsyncAction<AsyncResult<ExchangeByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExchangeByUserIdResult parse(JsonNode data) {
            return ExchangeByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/exchange/{rateName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("count", ExchangeByUserIdTask.this.request.getCount());
                    this.put("config", ExchangeByUserIdTask.this.request.getConfig() == null ? new ArrayList() : ExchangeByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", ExchangeByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExchangeTask
    extends Gs2RestSessionTask<ExchangeResult> {
        private ExchangeRequest request;

        public ExchangeTask(ExchangeRequest request, AsyncAction<AsyncResult<ExchangeResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExchangeResult parse(JsonNode data) {
            return ExchangeResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/exchange/{rateName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("count", ExchangeTask.this.request.getCount());
                    this.put("config", ExchangeTask.this.request.getConfig() == null ? new ArrayList() : ExchangeTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", ExchangeTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DeleteRateModelMasterTask
    extends Gs2RestSessionTask<DeleteRateModelMasterResult> {
        private DeleteRateModelMasterRequest request;

        public DeleteRateModelMasterTask(DeleteRateModelMasterRequest request, AsyncAction<AsyncResult<DeleteRateModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteRateModelMasterResult parse(JsonNode data) {
            return DeleteRateModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{rateName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateRateModelMasterTask
    extends Gs2RestSessionTask<UpdateRateModelMasterResult> {
        private UpdateRateModelMasterRequest request;

        public UpdateRateModelMasterTask(UpdateRateModelMasterRequest request, AsyncAction<AsyncResult<UpdateRateModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateRateModelMasterResult parse(JsonNode data) {
            return UpdateRateModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{rateName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateRateModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateRateModelMasterTask.this.request.getMetadata());
                    this.put("timingType", UpdateRateModelMasterTask.this.request.getTimingType());
                    this.put("lockTime", UpdateRateModelMasterTask.this.request.getLockTime());
                    this.put("enableSkip", UpdateRateModelMasterTask.this.request.getEnableSkip());
                    this.put("skipConsumeActions", UpdateRateModelMasterTask.this.request.getSkipConsumeActions() == null ? new ArrayList() : UpdateRateModelMasterTask.this.request.getSkipConsumeActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("acquireActions", UpdateRateModelMasterTask.this.request.getAcquireActions() == null ? new ArrayList() : UpdateRateModelMasterTask.this.request.getAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("consumeActions", UpdateRateModelMasterTask.this.request.getConsumeActions() == null ? new ArrayList() : UpdateRateModelMasterTask.this.request.getConsumeActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", UpdateRateModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetRateModelMasterTask
    extends Gs2RestSessionTask<GetRateModelMasterResult> {
        private GetRateModelMasterRequest request;

        public GetRateModelMasterTask(GetRateModelMasterRequest request, AsyncAction<AsyncResult<GetRateModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRateModelMasterResult parse(JsonNode data) {
            return GetRateModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{rateName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateRateModelMasterTask
    extends Gs2RestSessionTask<CreateRateModelMasterResult> {
        private CreateRateModelMasterRequest request;

        public CreateRateModelMasterTask(CreateRateModelMasterRequest request, AsyncAction<AsyncResult<CreateRateModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateRateModelMasterResult parse(JsonNode data) {
            return CreateRateModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateRateModelMasterTask.this.request.getName());
                    this.put("description", CreateRateModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateRateModelMasterTask.this.request.getMetadata());
                    this.put("timingType", CreateRateModelMasterTask.this.request.getTimingType());
                    this.put("lockTime", CreateRateModelMasterTask.this.request.getLockTime());
                    this.put("enableSkip", CreateRateModelMasterTask.this.request.getEnableSkip());
                    this.put("skipConsumeActions", CreateRateModelMasterTask.this.request.getSkipConsumeActions() == null ? new ArrayList() : CreateRateModelMasterTask.this.request.getSkipConsumeActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("acquireActions", CreateRateModelMasterTask.this.request.getAcquireActions() == null ? new ArrayList() : CreateRateModelMasterTask.this.request.getAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("consumeActions", CreateRateModelMasterTask.this.request.getConsumeActions() == null ? new ArrayList() : CreateRateModelMasterTask.this.request.getConsumeActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", CreateRateModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeRateModelMastersTask
    extends Gs2RestSessionTask<DescribeRateModelMastersResult> {
        private DescribeRateModelMastersRequest request;

        public DescribeRateModelMastersTask(DescribeRateModelMastersRequest request, AsyncAction<AsyncResult<DescribeRateModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRateModelMastersResult parse(JsonNode data) {
            return DescribeRateModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetRateModelTask
    extends Gs2RestSessionTask<GetRateModelResult> {
        private GetRateModelRequest request;

        public GetRateModelTask(GetRateModelRequest request, AsyncAction<AsyncResult<GetRateModelResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRateModelResult parse(JsonNode data) {
            return GetRateModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/model/{rateName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{rateName}", this.request.getRateName() == null || this.request.getRateName().length() == 0 ? "null" : String.valueOf(this.request.getRateName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeRateModelsTask
    extends Gs2RestSessionTask<DescribeRateModelsResult> {
        private DescribeRateModelsRequest request;

        public DescribeRateModelsTask(DescribeRateModelsRequest request, AsyncAction<AsyncResult<DescribeRateModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRateModelsResult parse(JsonNode data) {
            return DescribeRateModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("enableAwaitExchange", UpdateNamespaceTask.this.request.getEnableAwaitExchange());
                    this.put("enableDirectExchange", UpdateNamespaceTask.this.request.getEnableDirectExchange());
                    this.put("queueNamespaceId", UpdateNamespaceTask.this.request.getQueueNamespaceId());
                    this.put("keyId", UpdateNamespaceTask.this.request.getKeyId());
                    this.put("exchangeScript", UpdateNamespaceTask.this.request.getExchangeScript() != null ? UpdateNamespaceTask.this.request.getExchangeScript().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("enableAwaitExchange", CreateNamespaceTask.this.request.getEnableAwaitExchange());
                    this.put("enableDirectExchange", CreateNamespaceTask.this.request.getEnableDirectExchange());
                    this.put("queueNamespaceId", CreateNamespaceTask.this.request.getQueueNamespaceId());
                    this.put("keyId", CreateNamespaceTask.this.request.getKeyId());
                    this.put("exchangeScript", CreateNamespaceTask.this.request.getExchangeScript() != null ? CreateNamespaceTask.this.request.getExchangeScript().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2ExchangeRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "exchange").replace("{region}", Gs2ExchangeRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

