/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.enhance.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.domain.StampSheetDomain;
import io.gs2.core.exception.Gs2Exception;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.exception.TransactionException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.enhance.Gs2EnhanceRestClient;
import io.gs2.enhance.domain.model.RateModelDomain;
import io.gs2.enhance.domain.model.UserDomain;
import io.gs2.enhance.model.Progress;
import io.gs2.enhance.request.CreateProgressByUserIdRequest;
import io.gs2.enhance.request.DeleteProgressByUserIdRequest;
import io.gs2.enhance.request.EndByUserIdRequest;
import io.gs2.enhance.request.GetProgressByUserIdRequest;
import io.gs2.enhance.request.StartByUserIdRequest;
import io.gs2.enhance.result.CreateProgressByUserIdResult;
import io.gs2.enhance.result.DeleteProgressByUserIdResult;
import io.gs2.enhance.result.EndByUserIdResult;
import io.gs2.enhance.result.GetProgressByUserIdResult;
import io.gs2.enhance.result.StartByUserIdResult;

public class ProgressDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2EnhanceRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;
    Long acquireExperience;
    Float bonusRate;

    public Long getAcquireExperience() {
        return this.acquireExperience;
    }

    public Float getBonusRate() {
        return this.bonusRate;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public ProgressDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2EnhanceRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Progress");
    }

    public ProgressDomain create(CreateProgressByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        CreateProgressByUserIdResult result = this.client.createProgressByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ProgressDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ProgressDomain domain = this;
        return domain;
    }

    private Progress get(GetProgressByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        GetProgressByUserIdResult result = this.client.getProgressByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ProgressDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getRateModel() != null) {
            this.cache.put(this.parentKey, RateModelDomain.createCacheKey(result.getRateModel().getName() != null ? result.getRateModel().getName().toString() : null), result.getRateModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public StampSheetDomain start(StartByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        StartByUserIdResult result = this.client.startByUserId(request);
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public StampSheetDomain end(EndByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        EndByUserIdResult result = this.client.endByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ProgressDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public ProgressDomain delete(DeleteProgressByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        DeleteProgressByUserIdResult result = null;
        try {
            result = this.client.deleteProgressByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, ProgressDomain.createCacheKey(), Progress.class);
        ProgressDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "enhance", namespaceName, userId, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public Progress model() {
        Progress value = this.cache.get(this.parentKey, ProgressDomain.createCacheKey(), Progress.class);
        if (value == null) {
            try {
                this.get(new GetProgressByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ProgressDomain.createCacheKey(), Progress.class);
            }
            value = this.cache.get(this.parentKey, ProgressDomain.createCacheKey(), Progress.class);
        }
        return value;
    }
}

