/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.enhance.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.enhance.Gs2EnhanceRestClient;
import io.gs2.enhance.domain.model.ProgressDomain;
import io.gs2.enhance.domain.model.UserDomain;
import io.gs2.enhance.model.Progress;
import io.gs2.enhance.request.DescribeProgressesByUserIdRequest;
import io.gs2.enhance.result.DescribeProgressesByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeProgressesByUserIdIterator
implements Iterator<Progress>,
Iterable<Progress> {
    CacheDatabase cache;
    Gs2EnhanceRestClient client;
    String namespaceName;
    String userId;
    String pageToken;
    boolean last;
    List<Progress> result;
    Integer fetchSize;

    public DescribeProgressesByUserIdIterator(CacheDatabase cache, Gs2EnhanceRestClient client, String namespaceName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Progress>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Progress");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Progress.class)) {
            this.result = this.cache.list(parentKey, Progress.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeProgressesByUserIdResult r = this.client.describeProgressesByUserId(new DescribeProgressesByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Progress item : this.result) {
                this.cache.put(parentKey, ProgressDomain.createCacheKey(), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Progress.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Progress next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Progress ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Progress> iterator() {
        return this;
    }
}

