/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.enhance.domain;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.enhance.Gs2EnhanceRestClient;
import io.gs2.enhance.domain.iterator.DescribeNamespacesIterator;
import io.gs2.enhance.domain.model.EnhanceDomain;
import io.gs2.enhance.domain.model.NamespaceDomain;
import io.gs2.enhance.domain.model.ProgressDomain;
import io.gs2.enhance.domain.model.UserDomain;
import io.gs2.enhance.model.Progress;
import io.gs2.enhance.request.CreateNamespaceRequest;
import io.gs2.enhance.request.CreateProgressByUserIdRequest;
import io.gs2.enhance.request.DeleteProgressByUserIdRequest;
import io.gs2.enhance.request.DirectEnhanceByUserIdRequest;
import io.gs2.enhance.result.CreateNamespaceResult;
import io.gs2.enhance.result.CreateProgressByUserIdResult;
import io.gs2.enhance.result.DeleteProgressByUserIdResult;
import io.gs2.enhance.result.DirectEnhanceByUserIdResult;
import io.gs2.jobQueue.model.Job;
import io.gs2.jobQueue.model.JobResultBody;

public class Gs2Enhance {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2EnhanceRestClient client;
    private final String parentKey;

    public Gs2Enhance(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2EnhanceRestClient(session);
        this.parentKey = "enhance";
    }

    public NamespaceDomain createNamespace(CreateNamespaceRequest request) {
        CreateNamespaceResult result = this.client.createNamespace(request);
        String parentKey = "enhance:Namespace";
        if (result.getItem() != null) {
            this.cache.put(parentKey, NamespaceDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, result.getItem().getName());
        return domain;
    }

    public DescribeNamespacesIterator namespaces() {
        return new DescribeNamespacesIterator(this.cache, this.client);
    }

    public NamespaceDomain namespace(String namespaceName) {
        return new NamespaceDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, namespaceName);
    }

    public static void updateCacheFromStampSheet(CacheDatabase cache, String method, String request, String result) {
        try {
            switch (method) {
                case "DirectEnhanceByUserId": {
                    DirectEnhanceByUserIdRequest requestModel = DirectEnhanceByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    DirectEnhanceByUserIdResult resultModel = DirectEnhanceByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), requestModel.getUserId().toString(), "Enhance");
                    String key = EnhanceDomain.createCacheKey();
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "CreateProgressByUserId": {
                    CreateProgressByUserIdRequest requestModel = CreateProgressByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    CreateProgressByUserIdResult resultModel = CreateProgressByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Progress");
                    String key = ProgressDomain.createCacheKey();
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static void updateCacheFromStampTask(CacheDatabase cache, String method, String request, String result) {
        try {
            switch (method) {
                case "DeleteProgressByUserId": {
                    DeleteProgressByUserIdRequest requestModel = DeleteProgressByUserIdRequest.fromJson(new ObjectMapper().readTree(request));
                    DeleteProgressByUserIdResult resultModel = DeleteProgressByUserIdResult.fromJson(new ObjectMapper().readTree(result));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Progress");
                    String key = ProgressDomain.createCacheKey();
                    cache.delete(parentKey, key, Progress.class);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static void updateCacheFromJobResult(CacheDatabase cache, String method, Job job, JobResultBody result) {
        try {
            switch (method) {
                case "direct_enhance_by_user_id": {
                    DirectEnhanceByUserIdRequest requestModel = DirectEnhanceByUserIdRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    DirectEnhanceByUserIdResult resultModel = DirectEnhanceByUserIdResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), requestModel.getUserId().toString(), "Enhance");
                    String key = EnhanceDomain.createCacheKey();
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
                case "create_progress_by_user_id": {
                    CreateProgressByUserIdRequest requestModel = CreateProgressByUserIdRequest.fromJson(new ObjectMapper().readTree(job.getArgs()));
                    CreateProgressByUserIdResult resultModel = CreateProgressByUserIdResult.fromJson(new ObjectMapper().readTree(result.getResult()));
                    String parentKey = UserDomain.createCacheParentKey(requestModel.getNamespaceName().toString(), resultModel.getItem().getUserId().toString(), "Progress");
                    String key = ProgressDomain.createCacheKey();
                    cache.put(parentKey, key, resultModel.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
                    break;
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }
}

