/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.distributor.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.distributor.Gs2DistributorRestClient;
import io.gs2.distributor.domain.iterator.DescribeDistributorModelMastersIterator;
import io.gs2.distributor.domain.iterator.DescribeDistributorModelsIterator;
import io.gs2.distributor.domain.model.CurrentDistributorMasterDomain;
import io.gs2.distributor.domain.model.DistributeDomain;
import io.gs2.distributor.domain.model.DistributorModelDomain;
import io.gs2.distributor.domain.model.DistributorModelMasterDomain;
import io.gs2.distributor.model.Namespace;
import io.gs2.distributor.request.CreateDistributorModelMasterRequest;
import io.gs2.distributor.request.DeleteNamespaceRequest;
import io.gs2.distributor.request.GetNamespaceRequest;
import io.gs2.distributor.request.GetNamespaceStatusRequest;
import io.gs2.distributor.request.UpdateNamespaceRequest;
import io.gs2.distributor.result.CreateDistributorModelMasterResult;
import io.gs2.distributor.result.DeleteNamespaceResult;
import io.gs2.distributor.result.GetNamespaceResult;
import io.gs2.distributor.result.GetNamespaceStatusResult;
import io.gs2.distributor.result.UpdateNamespaceResult;
import java.util.List;

public class NamespaceDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2DistributorRestClient client;
    private final String namespaceName;
    private final String parentKey;
    String status;
    String result;
    String contextStack;
    List<String> taskResults;
    String sheetResult;
    String nextPageToken;

    public String getStatus() {
        return this.status;
    }

    public String getResult() {
        return this.result;
    }

    public String getContextStack() {
        return this.contextStack;
    }

    public List<String> getTaskResults() {
        return this.taskResults;
    }

    public String getSheetResult() {
        return this.sheetResult;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public NamespaceDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2DistributorRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = "distributor:Namespace";
    }

    public NamespaceDomain getStatus(GetNamespaceStatusRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceStatusResult result = this.client.getNamespaceStatus(request);
        NamespaceDomain domain = this;
        this.status = result.getStatus();
        return domain;
    }

    private Namespace get(GetNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceResult result = this.client.getNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public NamespaceDomain update(UpdateNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateNamespaceResult result = this.client.updateNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = this;
        return domain;
    }

    public NamespaceDomain delete(DeleteNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        DeleteNamespaceResult result = null;
        try {
            result = this.client.deleteNamespace(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), Namespace.class);
        NamespaceDomain domain = this;
        return domain;
    }

    public DistributorModelMasterDomain createDistributorModelMaster(CreateDistributorModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateDistributorModelMasterResult result = this.client.createDistributorModelMaster(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "DistributorModelMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, DistributorModelMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        DistributorModelMasterDomain domain = new DistributorModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public CurrentDistributorMasterDomain currentDistributorMaster() {
        return new CurrentDistributorMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName);
    }

    public DescribeDistributorModelsIterator distributorModels() {
        return new DescribeDistributorModelsIterator(this.cache, this.client, this.namespaceName);
    }

    public DistributorModelDomain distributorModel(String distributorName) {
        return new DistributorModelDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, distributorName);
    }

    public DistributeDomain distribute() {
        return new DistributeDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName);
    }

    public DescribeDistributorModelMastersIterator distributorModelMasters() {
        return new DescribeDistributorModelMastersIterator(this.cache, this.client, this.namespaceName);
    }

    public DistributorModelMasterDomain distributorModelMaster(String distributorName) {
        return new DistributorModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, distributorName);
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "distributor", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public Namespace model() {
        Namespace value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        if (value == null) {
            try {
                this.get(new GetNamespaceRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
            }
            value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        }
        return value;
    }
}

