/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.distributor.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.distributor.Gs2DistributorRestClient;
import io.gs2.distributor.domain.model.NamespaceDomain;
import io.gs2.distributor.model.DistributorModelMaster;
import io.gs2.distributor.request.DeleteDistributorModelMasterRequest;
import io.gs2.distributor.request.GetDistributorModelMasterRequest;
import io.gs2.distributor.request.UpdateDistributorModelMasterRequest;
import io.gs2.distributor.result.DeleteDistributorModelMasterResult;
import io.gs2.distributor.result.GetDistributorModelMasterResult;
import io.gs2.distributor.result.UpdateDistributorModelMasterResult;

public class DistributorModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2DistributorRestClient client;
    private final String namespaceName;
    private final String distributorName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getDistributorName() {
        return this.distributorName;
    }

    public DistributorModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String distributorName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2DistributorRestClient(session);
        this.namespaceName = namespaceName;
        this.distributorName = distributorName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "DistributorModelMaster");
    }

    private DistributorModelMaster get(GetDistributorModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withDistributorName(this.distributorName);
        GetDistributorModelMasterResult result = this.client.getDistributorModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, DistributorModelMasterDomain.createCacheKey(request.getDistributorName() != null ? request.getDistributorName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public DistributorModelMasterDomain update(UpdateDistributorModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withDistributorName(this.distributorName);
        UpdateDistributorModelMasterResult result = this.client.updateDistributorModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, DistributorModelMasterDomain.createCacheKey(request.getDistributorName() != null ? request.getDistributorName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        DistributorModelMasterDomain domain = this;
        return domain;
    }

    public DistributorModelMasterDomain delete(DeleteDistributorModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withDistributorName(this.distributorName);
        DeleteDistributorModelMasterResult result = null;
        try {
            result = this.client.deleteDistributorModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, DistributorModelMasterDomain.createCacheKey(request.getDistributorName() != null ? request.getDistributorName().toString() : null), DistributorModelMaster.class);
        DistributorModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String distributorName, String childType) {
        return String.join((CharSequence)":", "distributor", namespaceName, distributorName, childType);
    }

    public static String createCacheKey(String distributorName) {
        return String.join((CharSequence)":", distributorName);
    }

    public DistributorModelMaster model() {
        DistributorModelMaster value = this.cache.get(this.parentKey, DistributorModelMasterDomain.createCacheKey(this.getDistributorName() != null ? this.getDistributorName().toString() : null), DistributorModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetDistributorModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, DistributorModelMasterDomain.createCacheKey(this.getDistributorName() != null ? this.getDistributorName().toString() : null), DistributorModelMaster.class);
            }
            value = this.cache.get(this.parentKey, DistributorModelMasterDomain.createCacheKey(this.getDistributorName() != null ? this.getDistributorName().toString() : null), DistributorModelMaster.class);
        }
        return value;
    }
}

