/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.distributor.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.distributor.Gs2DistributorRestClient;
import io.gs2.distributor.domain.model.NamespaceDomain;
import io.gs2.distributor.model.DistributorModel;
import io.gs2.distributor.request.GetDistributorModelRequest;
import io.gs2.distributor.result.GetDistributorModelResult;

public class DistributorModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2DistributorRestClient client;
    private final String namespaceName;
    private final String distributorName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getDistributorName() {
        return this.distributorName;
    }

    public DistributorModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String distributorName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2DistributorRestClient(session);
        this.namespaceName = namespaceName;
        this.distributorName = distributorName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "DistributorModel");
    }

    private DistributorModel get(GetDistributorModelRequest request) {
        request.withNamespaceName(this.namespaceName).withDistributorName(this.distributorName);
        GetDistributorModelResult result = this.client.getDistributorModel(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, DistributorModelDomain.createCacheKey(request.getDistributorName() != null ? request.getDistributorName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String distributorName, String childType) {
        return String.join((CharSequence)":", "distributor", namespaceName, distributorName, childType);
    }

    public static String createCacheKey(String distributorName) {
        return String.join((CharSequence)":", distributorName);
    }

    public DistributorModel model() {
        DistributorModel value = this.cache.get(this.parentKey, DistributorModelDomain.createCacheKey(this.getDistributorName() != null ? this.getDistributorName().toString() : null), DistributorModel.class);
        if (value == null) {
            try {
                this.get(new GetDistributorModelRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, DistributorModelDomain.createCacheKey(this.getDistributorName() != null ? this.getDistributorName().toString() : null), DistributorModel.class);
            }
            value = this.cache.get(this.parentKey, DistributorModelDomain.createCacheKey(this.getDistributorName() != null ? this.getDistributorName().toString() : null), DistributorModel.class);
        }
        return value;
    }
}

