/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.distributor.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.distributor.Gs2DistributorRestClient;
import io.gs2.distributor.domain.model.NamespaceDomain;
import io.gs2.distributor.model.CurrentDistributorMaster;
import io.gs2.distributor.request.ExportMasterRequest;
import io.gs2.distributor.request.GetCurrentDistributorMasterRequest;
import io.gs2.distributor.request.UpdateCurrentDistributorMasterFromGitHubRequest;
import io.gs2.distributor.request.UpdateCurrentDistributorMasterRequest;
import io.gs2.distributor.result.ExportMasterResult;
import io.gs2.distributor.result.GetCurrentDistributorMasterResult;
import io.gs2.distributor.result.UpdateCurrentDistributorMasterFromGitHubResult;
import io.gs2.distributor.result.UpdateCurrentDistributorMasterResult;

public class CurrentDistributorMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2DistributorRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentDistributorMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2DistributorRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentDistributorMaster");
    }

    public CurrentDistributorMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentDistributorMasterDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentDistributorMasterDomain domain = this;
        return domain;
    }

    private CurrentDistributorMaster get(GetCurrentDistributorMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentDistributorMasterResult result = this.client.getCurrentDistributorMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentDistributorMasterDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentDistributorMasterDomain update(UpdateCurrentDistributorMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentDistributorMasterResult result = this.client.updateCurrentDistributorMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentDistributorMasterDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentDistributorMasterDomain domain = this;
        return domain;
    }

    public CurrentDistributorMasterDomain updateFromGitHub(UpdateCurrentDistributorMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentDistributorMasterFromGitHubResult result = this.client.updateCurrentDistributorMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentDistributorMasterDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentDistributorMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "distributor", namespaceName, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public CurrentDistributorMaster model() {
        CurrentDistributorMaster value = this.cache.get(this.parentKey, CurrentDistributorMasterDomain.createCacheKey(), CurrentDistributorMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentDistributorMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentDistributorMasterDomain.createCacheKey(), CurrentDistributorMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentDistributorMasterDomain.createCacheKey(), CurrentDistributorMaster.class);
        }
        return value;
    }
}

