/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.distributor.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.distributor.Gs2DistributorRestClient;
import io.gs2.distributor.domain.model.DistributorModelMasterDomain;
import io.gs2.distributor.domain.model.NamespaceDomain;
import io.gs2.distributor.model.DistributorModelMaster;
import io.gs2.distributor.request.DescribeDistributorModelMastersRequest;
import io.gs2.distributor.result.DescribeDistributorModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeDistributorModelMastersIterator
implements Iterator<DistributorModelMaster>,
Iterable<DistributorModelMaster> {
    CacheDatabase cache;
    Gs2DistributorRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<DistributorModelMaster> result;
    Integer fetchSize;

    public DescribeDistributorModelMastersIterator(CacheDatabase cache, Gs2DistributorRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<DistributorModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "DistributorModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, DistributorModelMaster.class)) {
            this.result = this.cache.list(parentKey, DistributorModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeDistributorModelMastersResult r = this.client.describeDistributorModelMasters(new DescribeDistributorModelMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (DistributorModelMaster item : this.result) {
                this.cache.put(parentKey, DistributorModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, DistributorModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public DistributorModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        DistributorModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<DistributorModelMaster> iterator() {
        return this;
    }
}

