/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.dictionary.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.dictionary.Gs2DictionaryRestClient;
import io.gs2.dictionary.domain.iterator.DescribeEntriesByUserIdIterator;
import io.gs2.dictionary.domain.model.EntryDomain;
import io.gs2.dictionary.domain.model.NamespaceDomain;
import io.gs2.dictionary.model.Entry;
import io.gs2.dictionary.request.AddEntriesByUserIdRequest;
import io.gs2.dictionary.request.ResetByUserIdRequest;
import io.gs2.dictionary.result.AddEntriesByUserIdResult;
import io.gs2.dictionary.result.ResetByUserIdResult;

public class UserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2DictionaryRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;
    String nextPageToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2DictionaryRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public EntryDomain[] addEntries(AddEntriesByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        AddEntriesByUserIdResult result = this.client.addEntriesByUserId(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Entry");
        for (Entry item : result.getItems()) {
            if (item == null) continue;
            this.cache.put(parentKey, EntryDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        EntryDomain[] domain = new EntryDomain[result.getItems().size()];
        for (int i = 0; i < result.getItems().size(); ++i) {
            domain[i] = new EntryDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItems().get(i).getUserId(), result.getItems().get(i).getName());
        }
        return domain;
    }

    public UserDomain reset(ResetByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        ResetByUserIdResult result = this.client.resetByUserId(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Entry");
        for (Entry item : this.cache.list(parentKey, Entry.class)) {
            this.cache.delete(parentKey, EntryDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), Entry.class);
        }
        UserDomain domain = this;
        return domain;
    }

    public DescribeEntriesByUserIdIterator entries() {
        return new DescribeEntriesByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public EntryDomain entry(String entryModelName) {
        return new EntryDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, entryModelName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "dictionary", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

