/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.dictionary.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.dictionary.Gs2DictionaryRestClient;
import io.gs2.dictionary.domain.model.NamespaceDomain;
import io.gs2.dictionary.model.EntryModelMaster;
import io.gs2.dictionary.request.DeleteEntryModelMasterRequest;
import io.gs2.dictionary.request.GetEntryModelMasterRequest;
import io.gs2.dictionary.request.UpdateEntryModelMasterRequest;
import io.gs2.dictionary.result.DeleteEntryModelMasterResult;
import io.gs2.dictionary.result.GetEntryModelMasterResult;
import io.gs2.dictionary.result.UpdateEntryModelMasterResult;

public class EntryModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2DictionaryRestClient client;
    private final String namespaceName;
    private final String entryName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public EntryModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String entryName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2DictionaryRestClient(session);
        this.namespaceName = namespaceName;
        this.entryName = entryName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "EntryModelMaster");
    }

    private EntryModelMaster get(GetEntryModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withEntryName(this.entryName);
        GetEntryModelMasterResult result = this.client.getEntryModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, EntryModelMasterDomain.createCacheKey(request.getEntryName() != null ? request.getEntryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public EntryModelMasterDomain update(UpdateEntryModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withEntryName(this.entryName);
        UpdateEntryModelMasterResult result = this.client.updateEntryModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, EntryModelMasterDomain.createCacheKey(request.getEntryName() != null ? request.getEntryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        EntryModelMasterDomain domain = this;
        return domain;
    }

    public EntryModelMasterDomain delete(DeleteEntryModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withEntryName(this.entryName);
        DeleteEntryModelMasterResult result = null;
        try {
            result = this.client.deleteEntryModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, EntryModelMasterDomain.createCacheKey(request.getEntryName() != null ? request.getEntryName().toString() : null), EntryModelMaster.class);
        EntryModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String entryName, String childType) {
        return String.join((CharSequence)":", "dictionary", namespaceName, entryName, childType);
    }

    public static String createCacheKey(String entryName) {
        return String.join((CharSequence)":", entryName);
    }

    public EntryModelMaster model() {
        EntryModelMaster value = this.cache.get(this.parentKey, EntryModelMasterDomain.createCacheKey(this.getEntryName() != null ? this.getEntryName().toString() : null), EntryModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetEntryModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, EntryModelMasterDomain.createCacheKey(this.getEntryName() != null ? this.getEntryName().toString() : null), EntryModelMaster.class);
            }
            value = this.cache.get(this.parentKey, EntryModelMasterDomain.createCacheKey(this.getEntryName() != null ? this.getEntryName().toString() : null), EntryModelMaster.class);
        }
        return value;
    }
}

