/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.dictionary.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.dictionary.Gs2DictionaryRestClient;
import io.gs2.dictionary.domain.model.UserDomain;
import io.gs2.dictionary.model.Entry;
import io.gs2.dictionary.request.GetEntryByUserIdRequest;
import io.gs2.dictionary.request.GetEntryWithSignatureByUserIdRequest;
import io.gs2.dictionary.result.GetEntryByUserIdResult;
import io.gs2.dictionary.result.GetEntryWithSignatureByUserIdResult;

public class EntryDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2DictionaryRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String entryModelName;
    private final String parentKey;
    String body;
    String signature;

    public String getBody() {
        return this.body;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEntryModelName() {
        return this.entryModelName;
    }

    public EntryDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String entryModelName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2DictionaryRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.entryModelName = entryModelName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Entry");
    }

    private Entry get(GetEntryByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withEntryModelName(this.entryModelName);
        GetEntryByUserIdResult result = this.client.getEntryByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, EntryDomain.createCacheKey(request.getEntryModelName() != null ? request.getEntryModelName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public EntryDomain getWithSignature(GetEntryWithSignatureByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withEntryModelName(this.entryModelName);
        GetEntryWithSignatureByUserIdResult result = this.client.getEntryWithSignatureByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, EntryDomain.createCacheKey(request.getEntryModelName() != null ? request.getEntryModelName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        EntryDomain domain = this;
        domain.body = result.getBody();
        domain.signature = result.getSignature();
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String entryModelName, String childType) {
        return String.join((CharSequence)":", "dictionary", namespaceName, userId, entryModelName, childType);
    }

    public static String createCacheKey(String entryModelName) {
        return String.join((CharSequence)":", entryModelName);
    }

    public Entry model() {
        Entry value = this.cache.get(this.parentKey, EntryDomain.createCacheKey(this.getEntryModelName() != null ? this.getEntryModelName().toString() : null), Entry.class);
        if (value == null) {
            try {
                this.get(new GetEntryByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, EntryDomain.createCacheKey(this.getEntryModelName() != null ? this.getEntryModelName().toString() : null), Entry.class);
            }
            value = this.cache.get(this.parentKey, EntryDomain.createCacheKey(this.getEntryModelName() != null ? this.getEntryModelName().toString() : null), Entry.class);
        }
        return value;
    }
}

