/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.dictionary.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.dictionary.Gs2DictionaryRestClient;
import io.gs2.dictionary.domain.model.EntryDomain;
import io.gs2.dictionary.domain.model.UserDomain;
import io.gs2.dictionary.model.Entry;
import io.gs2.dictionary.request.GetEntryRequest;
import io.gs2.dictionary.request.GetEntryWithSignatureRequest;
import io.gs2.dictionary.result.GetEntryResult;
import io.gs2.dictionary.result.GetEntryWithSignatureResult;

public class EntryAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2DictionaryRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String entryModelName;
    private final String parentKey;
    String body;
    String signature;

    public String getBody() {
        return this.body;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getEntryModelName() {
        return this.entryModelName;
    }

    public EntryAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String entryModelName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2DictionaryRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.entryModelName = entryModelName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Entry");
    }

    private Entry get(GetEntryRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withEntryModelName(this.entryModelName);
        GetEntryResult result = this.client.getEntry(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, EntryDomain.createCacheKey(request.getEntryModelName() != null ? request.getEntryModelName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public EntryAccessTokenDomain getWithSignature(GetEntryWithSignatureRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withEntryModelName(this.entryModelName);
        GetEntryWithSignatureResult result = this.client.getEntryWithSignature(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, EntryDomain.createCacheKey(request.getEntryModelName() != null ? request.getEntryModelName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        EntryAccessTokenDomain domain = this;
        domain.body = result.getBody();
        domain.signature = result.getSignature();
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String entryModelName, String childType) {
        return String.join((CharSequence)":", "dictionary", namespaceName, userId, entryModelName, childType);
    }

    public static String createCacheKey(String entryModelName) {
        return String.join((CharSequence)":", entryModelName);
    }

    public Entry model() {
        Entry value = this.cache.get(this.parentKey, EntryDomain.createCacheKey(this.getEntryModelName() != null ? this.getEntryModelName().toString() : null), Entry.class);
        if (value == null) {
            try {
                this.get(new GetEntryRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, EntryDomain.createCacheKey(this.getEntryModelName() != null ? this.getEntryModelName().toString() : null), Entry.class);
            }
            value = this.cache.get(this.parentKey, EntryDomain.createCacheKey(this.getEntryModelName() != null ? this.getEntryModelName().toString() : null), Entry.class);
        }
        return value;
    }
}

