/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.deploy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.deploy.request.CreateStackFromGitHubRequest;
import io.gs2.deploy.request.CreateStackRequest;
import io.gs2.deploy.request.DeleteStackEntityRequest;
import io.gs2.deploy.request.DeleteStackRequest;
import io.gs2.deploy.request.DeleteStackResourcesRequest;
import io.gs2.deploy.request.DescribeEventsRequest;
import io.gs2.deploy.request.DescribeOutputsRequest;
import io.gs2.deploy.request.DescribeResourcesRequest;
import io.gs2.deploy.request.DescribeStacksRequest;
import io.gs2.deploy.request.ForceDeleteStackRequest;
import io.gs2.deploy.request.GetEventRequest;
import io.gs2.deploy.request.GetOutputRequest;
import io.gs2.deploy.request.GetResourceRequest;
import io.gs2.deploy.request.GetStackRequest;
import io.gs2.deploy.request.GetStackStatusRequest;
import io.gs2.deploy.request.UpdateStackFromGitHubRequest;
import io.gs2.deploy.request.UpdateStackRequest;
import io.gs2.deploy.request.ValidateRequest;
import io.gs2.deploy.result.CreateStackFromGitHubResult;
import io.gs2.deploy.result.CreateStackResult;
import io.gs2.deploy.result.DeleteStackEntityResult;
import io.gs2.deploy.result.DeleteStackResourcesResult;
import io.gs2.deploy.result.DeleteStackResult;
import io.gs2.deploy.result.DescribeEventsResult;
import io.gs2.deploy.result.DescribeOutputsResult;
import io.gs2.deploy.result.DescribeResourcesResult;
import io.gs2.deploy.result.DescribeStacksResult;
import io.gs2.deploy.result.ForceDeleteStackResult;
import io.gs2.deploy.result.GetEventResult;
import io.gs2.deploy.result.GetOutputResult;
import io.gs2.deploy.result.GetResourceResult;
import io.gs2.deploy.result.GetStackResult;
import io.gs2.deploy.result.GetStackStatusResult;
import io.gs2.deploy.result.UpdateStackFromGitHubResult;
import io.gs2.deploy.result.UpdateStackResult;
import io.gs2.deploy.result.ValidateResult;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2DeployRestClient
extends AbstractGs2Client<Gs2DeployRestClient> {
    public Gs2DeployRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeStacksAsync(DescribeStacksRequest request, AsyncAction<AsyncResult<DescribeStacksResult>> callback) {
        DescribeStacksTask task = new DescribeStacksTask(request, callback);
        this.session.execute(task);
    }

    public DescribeStacksResult describeStacks(DescribeStacksRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeStacksAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeStacksResult)resultAsyncResult[0].getResult();
    }

    public void createStackAsync(CreateStackRequest request, AsyncAction<AsyncResult<CreateStackResult>> callback) {
        CreateStackTask task = new CreateStackTask(request, callback);
        this.session.execute(task);
    }

    public CreateStackResult createStack(CreateStackRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createStackAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateStackResult)resultAsyncResult[0].getResult();
    }

    public void createStackFromGitHubAsync(CreateStackFromGitHubRequest request, AsyncAction<AsyncResult<CreateStackFromGitHubResult>> callback) {
        CreateStackFromGitHubTask task = new CreateStackFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public CreateStackFromGitHubResult createStackFromGitHub(CreateStackFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createStackFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateStackFromGitHubResult)resultAsyncResult[0].getResult();
    }

    public void validateAsync(ValidateRequest request, AsyncAction<AsyncResult<ValidateResult>> callback) {
        ValidateTask task = new ValidateTask(request, callback);
        this.session.execute(task);
    }

    public ValidateResult validate(ValidateRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.validateAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ValidateResult)resultAsyncResult[0].getResult();
    }

    public void getStackStatusAsync(GetStackStatusRequest request, AsyncAction<AsyncResult<GetStackStatusResult>> callback) {
        GetStackStatusTask task = new GetStackStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetStackStatusResult getStackStatus(GetStackStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getStackStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetStackStatusResult)resultAsyncResult[0].getResult();
    }

    public void getStackAsync(GetStackRequest request, AsyncAction<AsyncResult<GetStackResult>> callback) {
        GetStackTask task = new GetStackTask(request, callback);
        this.session.execute(task);
    }

    public GetStackResult getStack(GetStackRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getStackAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetStackResult)resultAsyncResult[0].getResult();
    }

    public void updateStackAsync(UpdateStackRequest request, AsyncAction<AsyncResult<UpdateStackResult>> callback) {
        UpdateStackTask task = new UpdateStackTask(request, callback);
        this.session.execute(task);
    }

    public UpdateStackResult updateStack(UpdateStackRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateStackAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateStackResult)resultAsyncResult[0].getResult();
    }

    public void updateStackFromGitHubAsync(UpdateStackFromGitHubRequest request, AsyncAction<AsyncResult<UpdateStackFromGitHubResult>> callback) {
        UpdateStackFromGitHubTask task = new UpdateStackFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateStackFromGitHubResult updateStackFromGitHub(UpdateStackFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateStackFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateStackFromGitHubResult)resultAsyncResult[0].getResult();
    }

    public void deleteStackAsync(DeleteStackRequest request, AsyncAction<AsyncResult<DeleteStackResult>> callback) {
        DeleteStackTask task = new DeleteStackTask(request, callback);
        this.session.execute(task);
    }

    public DeleteStackResult deleteStack(DeleteStackRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteStackAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteStackResult)resultAsyncResult[0].getResult();
    }

    public void forceDeleteStackAsync(ForceDeleteStackRequest request, AsyncAction<AsyncResult<ForceDeleteStackResult>> callback) {
        ForceDeleteStackTask task = new ForceDeleteStackTask(request, callback);
        this.session.execute(task);
    }

    public ForceDeleteStackResult forceDeleteStack(ForceDeleteStackRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.forceDeleteStackAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ForceDeleteStackResult)resultAsyncResult[0].getResult();
    }

    public void deleteStackResourcesAsync(DeleteStackResourcesRequest request, AsyncAction<AsyncResult<DeleteStackResourcesResult>> callback) {
        DeleteStackResourcesTask task = new DeleteStackResourcesTask(request, callback);
        this.session.execute(task);
    }

    public DeleteStackResourcesResult deleteStackResources(DeleteStackResourcesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteStackResourcesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteStackResourcesResult)resultAsyncResult[0].getResult();
    }

    public void deleteStackEntityAsync(DeleteStackEntityRequest request, AsyncAction<AsyncResult<DeleteStackEntityResult>> callback) {
        DeleteStackEntityTask task = new DeleteStackEntityTask(request, callback);
        this.session.execute(task);
    }

    public DeleteStackEntityResult deleteStackEntity(DeleteStackEntityRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteStackEntityAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteStackEntityResult)resultAsyncResult[0].getResult();
    }

    public void describeResourcesAsync(DescribeResourcesRequest request, AsyncAction<AsyncResult<DescribeResourcesResult>> callback) {
        DescribeResourcesTask task = new DescribeResourcesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeResourcesResult describeResources(DescribeResourcesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeResourcesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeResourcesResult)resultAsyncResult[0].getResult();
    }

    public void getResourceAsync(GetResourceRequest request, AsyncAction<AsyncResult<GetResourceResult>> callback) {
        GetResourceTask task = new GetResourceTask(request, callback);
        this.session.execute(task);
    }

    public GetResourceResult getResource(GetResourceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getResourceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetResourceResult)resultAsyncResult[0].getResult();
    }

    public void describeEventsAsync(DescribeEventsRequest request, AsyncAction<AsyncResult<DescribeEventsResult>> callback) {
        DescribeEventsTask task = new DescribeEventsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeEventsResult describeEvents(DescribeEventsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeEventsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeEventsResult)resultAsyncResult[0].getResult();
    }

    public void getEventAsync(GetEventRequest request, AsyncAction<AsyncResult<GetEventResult>> callback) {
        GetEventTask task = new GetEventTask(request, callback);
        this.session.execute(task);
    }

    public GetEventResult getEvent(GetEventRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEventAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEventResult)resultAsyncResult[0].getResult();
    }

    public void describeOutputsAsync(DescribeOutputsRequest request, AsyncAction<AsyncResult<DescribeOutputsResult>> callback) {
        DescribeOutputsTask task = new DescribeOutputsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeOutputsResult describeOutputs(DescribeOutputsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeOutputsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeOutputsResult)resultAsyncResult[0].getResult();
    }

    public void getOutputAsync(GetOutputRequest request, AsyncAction<AsyncResult<GetOutputResult>> callback) {
        GetOutputTask task = new GetOutputTask(request, callback);
        this.session.execute(task);
    }

    public GetOutputResult getOutput(GetOutputRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getOutputAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetOutputResult)resultAsyncResult[0].getResult();
    }

    class GetOutputTask
    extends Gs2RestSessionTask<GetOutputResult> {
        private GetOutputRequest request;

        public GetOutputTask(GetOutputRequest request, AsyncAction<AsyncResult<GetOutputResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetOutputResult parse(JsonNode data) {
            return GetOutputResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/{stackName}/output/{outputName}";
            url = url.replace("{stackName}", this.request.getStackName() == null || this.request.getStackName().length() == 0 ? "null" : String.valueOf(this.request.getStackName()));
            url = url.replace("{outputName}", this.request.getOutputName() == null || this.request.getOutputName().length() == 0 ? "null" : String.valueOf(this.request.getOutputName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeOutputsTask
    extends Gs2RestSessionTask<DescribeOutputsResult> {
        private DescribeOutputsRequest request;

        public DescribeOutputsTask(DescribeOutputsRequest request, AsyncAction<AsyncResult<DescribeOutputsResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeOutputsResult parse(JsonNode data) {
            return DescribeOutputsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/{stackName}/output";
            url = url.replace("{stackName}", this.request.getStackName() == null || this.request.getStackName().length() == 0 ? "null" : String.valueOf(this.request.getStackName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetEventTask
    extends Gs2RestSessionTask<GetEventResult> {
        private GetEventRequest request;

        public GetEventTask(GetEventRequest request, AsyncAction<AsyncResult<GetEventResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetEventResult parse(JsonNode data) {
            return GetEventResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/{stackName}/event/{eventName}";
            url = url.replace("{stackName}", this.request.getStackName() == null || this.request.getStackName().length() == 0 ? "null" : String.valueOf(this.request.getStackName()));
            url = url.replace("{eventName}", this.request.getEventName() == null || this.request.getEventName().length() == 0 ? "null" : String.valueOf(this.request.getEventName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeEventsTask
    extends Gs2RestSessionTask<DescribeEventsResult> {
        private DescribeEventsRequest request;

        public DescribeEventsTask(DescribeEventsRequest request, AsyncAction<AsyncResult<DescribeEventsResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeEventsResult parse(JsonNode data) {
            return DescribeEventsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/{stackName}/event";
            url = url.replace("{stackName}", this.request.getStackName() == null || this.request.getStackName().length() == 0 ? "null" : String.valueOf(this.request.getStackName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetResourceTask
    extends Gs2RestSessionTask<GetResourceResult> {
        private GetResourceRequest request;

        public GetResourceTask(GetResourceRequest request, AsyncAction<AsyncResult<GetResourceResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetResourceResult parse(JsonNode data) {
            return GetResourceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/{stackName}/resource/{resourceName}";
            url = url.replace("{stackName}", this.request.getStackName() == null || this.request.getStackName().length() == 0 ? "null" : String.valueOf(this.request.getStackName()));
            url = url.replace("{resourceName}", this.request.getResourceName() == null || this.request.getResourceName().length() == 0 ? "null" : String.valueOf(this.request.getResourceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeResourcesTask
    extends Gs2RestSessionTask<DescribeResourcesResult> {
        private DescribeResourcesRequest request;

        public DescribeResourcesTask(DescribeResourcesRequest request, AsyncAction<AsyncResult<DescribeResourcesResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeResourcesResult parse(JsonNode data) {
            return DescribeResourcesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/{stackName}/resource";
            url = url.replace("{stackName}", this.request.getStackName() == null || this.request.getStackName().length() == 0 ? "null" : String.valueOf(this.request.getStackName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteStackEntityTask
    extends Gs2RestSessionTask<DeleteStackEntityResult> {
        private DeleteStackEntityRequest request;

        public DeleteStackEntityTask(DeleteStackEntityRequest request, AsyncAction<AsyncResult<DeleteStackEntityResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteStackEntityResult parse(JsonNode data) {
            return DeleteStackEntityResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/{stackName}/entity";
            url = url.replace("{stackName}", this.request.getStackName() == null || this.request.getStackName().length() == 0 ? "null" : String.valueOf(this.request.getStackName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteStackResourcesTask
    extends Gs2RestSessionTask<DeleteStackResourcesResult> {
        private DeleteStackResourcesRequest request;

        public DeleteStackResourcesTask(DeleteStackResourcesRequest request, AsyncAction<AsyncResult<DeleteStackResourcesResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteStackResourcesResult parse(JsonNode data) {
            return DeleteStackResourcesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/{stackName}/resources";
            url = url.replace("{stackName}", this.request.getStackName() == null || this.request.getStackName().length() == 0 ? "null" : String.valueOf(this.request.getStackName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ForceDeleteStackTask
    extends Gs2RestSessionTask<ForceDeleteStackResult> {
        private ForceDeleteStackRequest request;

        public ForceDeleteStackTask(ForceDeleteStackRequest request, AsyncAction<AsyncResult<ForceDeleteStackResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ForceDeleteStackResult parse(JsonNode data) {
            return ForceDeleteStackResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/{stackName}/force";
            url = url.replace("{stackName}", this.request.getStackName() == null || this.request.getStackName().length() == 0 ? "null" : String.valueOf(this.request.getStackName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteStackTask
    extends Gs2RestSessionTask<DeleteStackResult> {
        private DeleteStackRequest request;

        public DeleteStackTask(DeleteStackRequest request, AsyncAction<AsyncResult<DeleteStackResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteStackResult parse(JsonNode data) {
            return DeleteStackResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/{stackName}";
            url = url.replace("{stackName}", this.request.getStackName() == null || this.request.getStackName().length() == 0 ? "null" : String.valueOf(this.request.getStackName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateStackFromGitHubTask
    extends Gs2RestSessionTask<UpdateStackFromGitHubResult> {
        private UpdateStackFromGitHubRequest request;

        public UpdateStackFromGitHubTask(UpdateStackFromGitHubRequest request, AsyncAction<AsyncResult<UpdateStackFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateStackFromGitHubResult parse(JsonNode data) {
            return UpdateStackFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/{stackName}/from_git_hub";
            url = url.replace("{stackName}", this.request.getStackName() == null || this.request.getStackName().length() == 0 ? "null" : String.valueOf(this.request.getStackName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateStackFromGitHubTask.this.request.getDescription());
                    this.put("checkoutSetting", UpdateStackFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateStackFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateStackFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateStackTask
    extends Gs2RestSessionTask<UpdateStackResult> {
        private UpdateStackRequest request;

        public UpdateStackTask(UpdateStackRequest request, AsyncAction<AsyncResult<UpdateStackResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateStackResult parse(JsonNode data) {
            return UpdateStackResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/{stackName}";
            url = url.replace("{stackName}", this.request.getStackName() == null || this.request.getStackName().length() == 0 ? "null" : String.valueOf(this.request.getStackName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateStackTask.this.request.getDescription());
                    this.put("template", UpdateStackTask.this.request.getTemplate());
                    this.put("contextStack", UpdateStackTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetStackTask
    extends Gs2RestSessionTask<GetStackResult> {
        private GetStackRequest request;

        public GetStackTask(GetStackRequest request, AsyncAction<AsyncResult<GetStackResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetStackResult parse(JsonNode data) {
            return GetStackResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/{stackName}";
            url = url.replace("{stackName}", this.request.getStackName() == null || this.request.getStackName().length() == 0 ? "null" : String.valueOf(this.request.getStackName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetStackStatusTask
    extends Gs2RestSessionTask<GetStackStatusResult> {
        private GetStackStatusRequest request;

        public GetStackStatusTask(GetStackStatusRequest request, AsyncAction<AsyncResult<GetStackStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetStackStatusResult parse(JsonNode data) {
            return GetStackStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/{stackName}/status";
            url = url.replace("{stackName}", this.request.getStackName() == null || this.request.getStackName().length() == 0 ? "null" : String.valueOf(this.request.getStackName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ValidateTask
    extends Gs2RestSessionTask<ValidateResult> {
        private ValidateRequest request;

        public ValidateTask(ValidateRequest request, AsyncAction<AsyncResult<ValidateResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ValidateResult parse(JsonNode data) {
            return ValidateResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/validate";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("template", ValidateTask.this.request.getTemplate());
                    this.put("contextStack", ValidateTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateStackFromGitHubTask
    extends Gs2RestSessionTask<CreateStackFromGitHubResult> {
        private CreateStackFromGitHubRequest request;

        public CreateStackFromGitHubTask(CreateStackFromGitHubRequest request, AsyncAction<AsyncResult<CreateStackFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateStackFromGitHubResult parse(JsonNode data) {
            return CreateStackFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack/from_git_hub";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateStackFromGitHubTask.this.request.getName());
                    this.put("description", CreateStackFromGitHubTask.this.request.getDescription());
                    this.put("checkoutSetting", CreateStackFromGitHubTask.this.request.getCheckoutSetting() != null ? CreateStackFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", CreateStackFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateStackTask
    extends Gs2RestSessionTask<CreateStackResult> {
        private CreateStackRequest request;

        public CreateStackTask(CreateStackRequest request, AsyncAction<AsyncResult<CreateStackResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateStackResult parse(JsonNode data) {
            return CreateStackResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateStackTask.this.request.getName());
                    this.put("description", CreateStackTask.this.request.getDescription());
                    this.put("template", CreateStackTask.this.request.getTemplate());
                    this.put("contextStack", CreateStackTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeStacksTask
    extends Gs2RestSessionTask<DescribeStacksResult> {
        private DescribeStacksRequest request;

        public DescribeStacksTask(DescribeStacksRequest request, AsyncAction<AsyncResult<DescribeStacksResult>> userCallback) {
            super((Gs2RestSession)Gs2DeployRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeStacksResult parse(JsonNode data) {
            return DescribeStacksResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "deploy").replace("{region}", Gs2DeployRestClient.this.session.getRegion().getName()) + "/stack";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

