/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.datastore.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.datastore.Gs2DatastoreRestClient;
import io.gs2.datastore.domain.iterator.DescribeDataObjectHistoriesByUserIdIterator;
import io.gs2.datastore.domain.model.DataObjectHistoryDomain;
import io.gs2.datastore.domain.model.UserDomain;
import io.gs2.datastore.model.DataObject;
import io.gs2.datastore.model.DataObjectHistory;
import io.gs2.datastore.request.DeleteDataObjectByUserIdRequest;
import io.gs2.datastore.request.DoneUploadByUserIdRequest;
import io.gs2.datastore.request.PrepareDownloadByUserIdAndDataObjectNameAndGenerationRequest;
import io.gs2.datastore.request.PrepareDownloadByUserIdAndDataObjectNameRequest;
import io.gs2.datastore.request.PrepareReUploadByUserIdRequest;
import io.gs2.datastore.request.UpdateDataObjectByUserIdRequest;
import io.gs2.datastore.result.DeleteDataObjectByUserIdResult;
import io.gs2.datastore.result.DoneUploadByUserIdResult;
import io.gs2.datastore.result.PrepareDownloadByUserIdAndDataObjectNameAndGenerationResult;
import io.gs2.datastore.result.PrepareDownloadByUserIdAndDataObjectNameResult;
import io.gs2.datastore.result.PrepareReUploadByUserIdResult;
import io.gs2.datastore.result.UpdateDataObjectByUserIdResult;

public class DataObjectDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2DatastoreRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String dataObjectName;
    private final String parentKey;
    String uploadUrl;
    String fileUrl;
    Long contentLength;
    String nextPageToken;

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDataObjectName() {
        return this.dataObjectName;
    }

    public DataObjectDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String dataObjectName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2DatastoreRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.dataObjectName = dataObjectName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "DataObject");
    }

    public DataObjectDomain update(UpdateDataObjectByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withDataObjectName(this.dataObjectName);
        UpdateDataObjectByUserIdResult result = this.client.updateDataObjectByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, DataObjectDomain.createCacheKey(request.getDataObjectName() != null ? request.getDataObjectName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        DataObjectDomain domain = this;
        return domain;
    }

    public DataObjectDomain prepareReUpload(PrepareReUploadByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withDataObjectName(this.dataObjectName);
        PrepareReUploadByUserIdResult result = this.client.prepareReUploadByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, DataObjectDomain.createCacheKey(request.getDataObjectName() != null ? request.getDataObjectName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        DataObjectDomain domain = this;
        domain.uploadUrl = result.getUploadUrl();
        return domain;
    }

    public DataObjectDomain doneUpload(DoneUploadByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withDataObjectName(this.dataObjectName);
        DoneUploadByUserIdResult result = this.client.doneUploadByUserId(request);
        this.cache.listCacheClear(DataObjectDomain.createCacheParentKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null, this.getUserId() != null ? this.getUserId().toString() : null, this.getDataObjectName() != null ? this.getDataObjectName().toString() : null, "DataObjectHistory"), DataObjectHistory.class);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, DataObjectDomain.createCacheKey(request.getDataObjectName() != null ? request.getDataObjectName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        DataObjectDomain domain = this;
        return domain;
    }

    public DataObjectDomain delete(DeleteDataObjectByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withDataObjectName(this.dataObjectName);
        DeleteDataObjectByUserIdResult result = null;
        try {
            result = this.client.deleteDataObjectByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, DataObjectDomain.createCacheKey(request.getDataObjectName() != null ? request.getDataObjectName().toString() : null), DataObject.class);
        DataObjectDomain domain = this;
        return domain;
    }

    public DataObjectDomain prepareDownloadByUserIdAndName(PrepareDownloadByUserIdAndDataObjectNameRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withDataObjectName(this.dataObjectName);
        PrepareDownloadByUserIdAndDataObjectNameResult result = this.client.prepareDownloadByUserIdAndDataObjectName(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, DataObjectDomain.createCacheKey(request.getDataObjectName() != null ? request.getDataObjectName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        DataObjectDomain domain = this;
        domain.fileUrl = result.getFileUrl();
        domain.contentLength = result.getContentLength();
        return domain;
    }

    public DataObjectDomain prepareDownloadByUserIdAndNameAndGeneration(PrepareDownloadByUserIdAndDataObjectNameAndGenerationRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withDataObjectName(this.dataObjectName);
        PrepareDownloadByUserIdAndDataObjectNameAndGenerationResult result = this.client.prepareDownloadByUserIdAndDataObjectNameAndGeneration(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, DataObjectDomain.createCacheKey(request.getDataObjectName() != null ? request.getDataObjectName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        DataObjectDomain domain = this;
        domain.fileUrl = result.getFileUrl();
        domain.contentLength = result.getContentLength();
        return domain;
    }

    public DescribeDataObjectHistoriesByUserIdIterator dataObjectHistories() {
        return new DescribeDataObjectHistoriesByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId, this.dataObjectName);
    }

    public DataObjectHistoryDomain dataObjectHistory(String generation) {
        return new DataObjectHistoryDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, this.dataObjectName, generation);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String dataObjectName, String childType) {
        return String.join((CharSequence)":", "datastore", namespaceName, userId, dataObjectName, childType);
    }

    public static String createCacheKey(String dataObjectName) {
        return String.join((CharSequence)":", dataObjectName);
    }

    public DataObject model() {
        DataObject value = this.cache.get(this.parentKey, DataObjectDomain.createCacheKey(this.getDataObjectName() != null ? this.getDataObjectName().toString() : null), DataObject.class);
        return value;
    }
}

