/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.core.net;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.exception.Gs2Exception;
import io.gs2.core.exception.NoInternetConnectionException;
import io.gs2.core.exception.UnknownException;
import io.gs2.core.model.BasicGs2Credential;
import io.gs2.core.model.Region;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.Gs2Session;
import io.gs2.core.net.HttpTask;
import io.gs2.core.net.HttpTaskBuilder;
import java.io.IOException;
import org.json.JSONObject;

public class Gs2WebSocketSession
extends Gs2Session {
    public static String EndpointHost = "https://{service}.{region}.gen2.gs2io.com";
    private boolean m_IsOpenCancelled;

    public Gs2WebSocketSession(BasicGs2Credential basicGs2Credential) {
        super(basicGs2Credential);
    }

    public Gs2WebSocketSession(BasicGs2Credential basicGs2Credential, Region region) {
        super(basicGs2Credential, region);
    }

    public Gs2WebSocketSession(BasicGs2Credential basicGs2Credential, String region) {
        super(basicGs2Credential, region);
    }

    public void execute(Gs2RestSessionTask gs2RestSessionTask) throws IOException {
        super.execute(gs2RestSessionTask);
    }

    @Override
    void openImpl() {
        this.m_IsOpenCancelled = false;
        try {
            new Gs2LoginTask(this).execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    void cancelOpenImpl() {
        this.m_IsOpenCancelled = true;
    }

    @Override
    boolean closeImpl() {
        NoInternetConnectionException gs2ClientException = new NoInternetConnectionException("");
        this.closeCallback(gs2ClientException, true);
        return true;
    }

    private class Gs2LoginTask {
        private Gs2WebSocketSession gs2RestSession;

        Gs2LoginTask(Gs2WebSocketSession gs2RestSession) {
            this.gs2RestSession = gs2RestSession;
        }

        void execute() throws IOException {
            JSONObject json = new JSONObject();
            json.put("client_id", (Object)this.gs2RestSession.getGs2Credential().getClientId());
            json.put("client_secret", (Object)this.gs2RestSession.getGs2Credential().getClientSecret());
            byte[] body = json.toString().getBytes();
            HttpTaskBuilder.create().setMethod(HttpTask.Method.POST).setUrl(EndpointHost.replace("{service}", "identifier").replace("{region}", this.gs2RestSession.getRegion().getName()) + "/projectToken/login").setHeader("Content-Type", "application/json").setHttpResponseHandler(response -> {
                Gs2Exception error = response.getGs2Exception();
                String accessToken = null;
                if (error == null) {
                    try {
                        ObjectMapper mapper = new ObjectMapper();
                        accessToken = ((LoginResult)mapper.readValue((String)response.getMessage(), LoginResult.class)).access_token;
                    }
                    catch (Exception e) {
                        error = new UnknownException("JSON parsing error: \n" + response.getMessage());
                    }
                }
                this.gs2RestSession.openCallback(accessToken, error);
            }).setBody(body).build().send();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LoginResult {
        public String access_token;
        public String token_type;
        public Integer expires_in;
    }
}

