/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.core.domain;

import io.gs2.core.domain.Gs2;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class CacheDatabase {
    private final Map<Class<?>, Map<String, Map<String, Pair<Object, Long>>>> cache = new HashMap();
    private final Map<Class<?>, Map<String, Boolean>> listCached = new HashMap();

    public void clear() {
        this.cache.clear();
        this.listCached.clear();
    }

    public <T> boolean isListCached(String parentKey, Class<T> clazz) {
        if (!this.listCached.containsKey(clazz)) {
            this.listCached.put(clazz, new HashMap());
        }
        return this.listCached.get(clazz).containsKey(parentKey);
    }

    public <T> void listCached(String parentKey, Class<T> clazz) {
        if (!this.listCached.containsKey(clazz)) {
            this.listCached.put(clazz, new HashMap());
        }
        this.listCached.get(clazz).put(parentKey, true);
    }

    public <T> void listCacheClear(String parentKey, Class<T> clazz) {
        if (!this.listCached.containsKey(clazz)) {
            this.listCached.put(clazz, new HashMap());
        }
        this.listCached.get(clazz).remove(parentKey);
    }

    public <T> void put(String parentKey, String key, T obj, long ttl) {
        if (!this.cache.containsKey(obj.getClass())) {
            this.cache.put(obj.getClass(), new HashMap());
        }
        if (!this.cache.get(obj.getClass()).containsKey(parentKey)) {
            this.cache.get(obj.getClass()).put(parentKey, new HashMap());
        }
        if (ttl == 0L) {
            ttl = System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes;
        }
        this.cache.get(obj.getClass()).get(parentKey).put(key, (Pair<Object, Long>)Pair.of(obj, (Object)ttl));
    }

    public <T> void delete(String parentKey, String key, Class<T> clazz) {
        if (!this.cache.containsKey(clazz)) {
            this.cache.put(clazz, new HashMap());
        }
        if (!this.cache.get(clazz).containsKey(parentKey)) {
            this.cache.get(clazz).put(parentKey, new HashMap());
        }
        this.cache.get(clazz).get(parentKey).remove(key);
    }

    public <T> T get(String parentKey, String key, Class<T> clazz) {
        if (!this.cache.containsKey(clazz)) {
            this.cache.put(clazz, new HashMap());
        }
        if (!this.cache.get(clazz).containsKey(parentKey)) {
            this.cache.get(clazz).put(parentKey, new HashMap());
        }
        if (this.cache.get(clazz).get(parentKey).containsKey(key)) {
            Pair<Object, Long> entry = this.cache.get(clazz).get(parentKey).get(key);
            Object obj = entry.getLeft();
            Long ttl = (Long)entry.getRight();
            if (ttl < System.currentTimeMillis()) {
                this.delete(parentKey, key, clazz);
                return null;
            }
            return (T)obj;
        }
        return null;
    }

    public <T> List<T> list(String parentKey, Class<T> clazz) {
        if (!this.cache.containsKey(clazz)) {
            this.cache.put(clazz, new HashMap());
        }
        if (!this.cache.get(clazz).containsKey(parentKey)) {
            this.cache.get(clazz).put(parentKey, new HashMap());
        }
        return this.cache.get(clazz).get(parentKey).values().stream().map(v -> v.getLeft()).collect(Collectors.toList());
    }
}

