/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.chat.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.chat.Gs2ChatRestClient;
import io.gs2.chat.domain.iterator.DescribeSubscribesIterator;
import io.gs2.chat.domain.model.NamespaceDomain;
import io.gs2.chat.domain.model.RoomAccessTokenDomain;
import io.gs2.chat.domain.model.RoomDomain;
import io.gs2.chat.domain.model.SubscribeAccessTokenDomain;
import io.gs2.chat.domain.model.UserDomain;
import io.gs2.chat.model.Room;
import io.gs2.chat.request.CreateRoomRequest;
import io.gs2.chat.request.DeleteRoomRequest;
import io.gs2.chat.result.CreateRoomResult;
import io.gs2.chat.result.DeleteRoomResult;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;

public class UserAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ChatRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;
    String nextPageToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public UserAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ChatRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public RoomAccessTokenDomain createRoom(CreateRoomRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        CreateRoomResult result = this.client.createRoom(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Singleton", "Room");
        if (result.getItem() != null) {
            this.cache.put(parentKey, RoomDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        RoomAccessTokenDomain domain = new RoomAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), this.accessToken, result.getItem().getName(), result.getItem().getPassword());
        return domain;
    }

    public RoomAccessTokenDomain deleteRoom(DeleteRoomRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        DeleteRoomResult result = null;
        try {
            result = this.client.deleteRoom(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Singleton", "Room");
        this.cache.delete(parentKey, RoomDomain.createCacheKey(request.getRoomName() != null ? request.getRoomName().toString() : null), Room.class);
        RoomAccessTokenDomain domain = new RoomAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), this.accessToken, result.getItem().getName(), result.getItem().getPassword());
        return domain;
    }

    public RoomAccessTokenDomain room(String roomName, String password) {
        return new RoomAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, roomName, password);
    }

    public DescribeSubscribesIterator subscribes() {
        return new DescribeSubscribesIterator(this.cache, this.client, this.namespaceName, this.accessToken);
    }

    public SubscribeAccessTokenDomain subscribe(String roomName) {
        return new SubscribeAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, roomName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "chat", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

