/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.chat.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.chat.Gs2ChatRestClient;
import io.gs2.chat.domain.model.SubscribeDomain;
import io.gs2.chat.domain.model.UserDomain;
import io.gs2.chat.model.Subscribe;
import io.gs2.chat.request.GetSubscribeRequest;
import io.gs2.chat.request.SubscribeRequest;
import io.gs2.chat.request.UnsubscribeRequest;
import io.gs2.chat.request.UpdateNotificationTypeRequest;
import io.gs2.chat.result.GetSubscribeResult;
import io.gs2.chat.result.SubscribeResult;
import io.gs2.chat.result.UnsubscribeResult;
import io.gs2.chat.result.UpdateNotificationTypeResult;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;

public class SubscribeAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ChatRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String roomName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getRoomName() {
        return this.roomName;
    }

    public SubscribeAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String roomName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ChatRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.roomName = roomName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Subscribe");
    }

    public SubscribeAccessTokenDomain subscribe(SubscribeRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withRoomName(this.roomName);
        SubscribeResult result = this.client.subscribe(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SubscribeDomain.createCacheKey(request.getRoomName() != null ? request.getRoomName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SubscribeAccessTokenDomain domain = this;
        return domain;
    }

    private Subscribe get(GetSubscribeRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withRoomName(this.roomName);
        GetSubscribeResult result = this.client.getSubscribe(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SubscribeDomain.createCacheKey(request.getRoomName() != null ? request.getRoomName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public SubscribeAccessTokenDomain updateNotificationType(UpdateNotificationTypeRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withRoomName(this.roomName);
        UpdateNotificationTypeResult result = this.client.updateNotificationType(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SubscribeDomain.createCacheKey(request.getRoomName() != null ? request.getRoomName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SubscribeAccessTokenDomain domain = this;
        return domain;
    }

    public SubscribeAccessTokenDomain unsubscribe(UnsubscribeRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withRoomName(this.roomName);
        UnsubscribeResult result = null;
        try {
            result = this.client.unsubscribe(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, SubscribeDomain.createCacheKey(request.getRoomName() != null ? request.getRoomName().toString() : null), Subscribe.class);
        SubscribeAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String roomName, String childType) {
        return String.join((CharSequence)":", "chat", namespaceName, userId, roomName, childType);
    }

    public static String createCacheKey(String roomName) {
        return String.join((CharSequence)":", roomName);
    }

    public Subscribe model() {
        Subscribe value = this.cache.get(this.parentKey, SubscribeDomain.createCacheKey(this.getRoomName() != null ? this.getRoomName().toString() : null), Subscribe.class);
        if (value == null) {
            try {
                this.get(new GetSubscribeRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, SubscribeDomain.createCacheKey(this.getRoomName() != null ? this.getRoomName().toString() : null), Subscribe.class);
            }
            value = this.cache.get(this.parentKey, SubscribeDomain.createCacheKey(this.getRoomName() != null ? this.getRoomName().toString() : null), Subscribe.class);
        }
        return value;
    }
}

