/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.chat.domain.iterator;

import io.gs2.chat.Gs2ChatRestClient;
import io.gs2.chat.model.Subscribe;
import io.gs2.chat.request.DescribeSubscribesByRoomNameRequest;
import io.gs2.chat.result.DescribeSubscribesByRoomNameResult;
import io.gs2.core.domain.CacheDatabase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DescribeSubscribesByRoomNameIterator
implements Iterator<Subscribe>,
Iterable<Subscribe> {
    CacheDatabase cache;
    Gs2ChatRestClient client;
    String namespaceName;
    String roomName;
    String pageToken;
    boolean last;
    List<Subscribe> result;
    Integer fetchSize;

    public DescribeSubscribesByRoomNameIterator(CacheDatabase cache, Gs2ChatRestClient client, String namespaceName, String roomName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.roomName = roomName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Subscribe>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        DescribeSubscribesByRoomNameResult r = this.client.describeSubscribesByRoomName(new DescribeSubscribesByRoomNameRequest().withNamespaceName(this.namespaceName).withRoomName(this.roomName).withPageToken(this.pageToken).withLimit(this.fetchSize));
        this.result = r.getItems();
        this.pageToken = r.getNextPageToken();
        this.last = this.pageToken == null;
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Subscribe next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Subscribe ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Subscribe> iterator() {
        return this;
    }
}

