/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.chat.domain.iterator;

import io.gs2.auth.model.AccessToken;
import io.gs2.chat.Gs2ChatRestClient;
import io.gs2.chat.domain.model.MessageDomain;
import io.gs2.chat.domain.model.RoomDomain;
import io.gs2.chat.model.Message;
import io.gs2.chat.request.DescribeMessagesRequest;
import io.gs2.chat.result.DescribeMessagesResult;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeMessagesIterator
implements Iterator<Message>,
Iterable<Message> {
    CacheDatabase cache;
    Gs2ChatRestClient client;
    String namespaceName;
    String roomName;
    String password;
    AccessToken accessToken;
    Long startAt;
    boolean last;
    List<Message> result;
    Integer fetchSize;

    public DescribeMessagesIterator(CacheDatabase cache, Gs2ChatRestClient client, String namespaceName, String roomName, String password, AccessToken accessToken) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.roomName = roomName;
        this.password = password;
        this.accessToken = accessToken;
        this.startAt = null;
        this.last = false;
        this.result = new ArrayList<Message>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = RoomDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Singleton", this.roomName != null ? this.roomName.toString() : null, "Message");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Message.class)) {
            this.result = this.cache.list(parentKey, Message.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeMessagesResult r = this.client.describeMessages(new DescribeMessagesRequest().withNamespaceName(this.namespaceName).withRoomName(this.roomName).withPassword(this.password).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withStartAt(this.startAt).withLimit(this.fetchSize));
            this.result = r.getItems();
            if (this.result.size() > 0) {
                this.startAt = this.result.get(this.result.size() - 1).getCreatedAt() + 1L;
            }
            for (Message item : this.result) {
                this.cache.put(parentKey, MessageDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Message.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Message next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Message ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Message> iterator() {
        return this;
    }
}

