/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.auth.domain.model;

import io.gs2.auth.Gs2AuthRestClient;
import io.gs2.auth.model.AccessToken;
import io.gs2.auth.request.LoginBySignatureRequest;
import io.gs2.auth.request.LoginRequest;
import io.gs2.auth.result.LoginBySignatureResult;
import io.gs2.auth.result.LoginResult;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;

public class AccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2AuthRestClient client;
    private final String parentKey;
    String token;
    String userId;
    Long expire;

    public String getToken() {
        return this.token;
    }

    public String getUserId() {
        return this.userId;
    }

    public Long getExpire() {
        return this.expire;
    }

    public AccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2AuthRestClient(session);
        this.parentKey = "auth:AccessToken";
    }

    public AccessTokenDomain login(LoginRequest request) {
        LoginResult result = this.client.login(request);
        AccessTokenDomain domain = this;
        this.cache.put(this.parentKey, AccessTokenDomain.createCacheKey(), new AccessToken().withToken(result.getToken()).withUserId(result.getUserId()).withExpire(result.getExpire()), System.currentTimeMillis() + 900000L);
        this.token = result.getToken();
        this.userId = result.getUserId();
        this.expire = result.getExpire();
        return domain;
    }

    public AccessTokenDomain loginBySignature(LoginBySignatureRequest request) {
        LoginBySignatureResult result = this.client.loginBySignature(request);
        AccessTokenDomain domain = this;
        this.cache.put(this.parentKey, AccessTokenDomain.createCacheKey(), new AccessToken().withToken(result.getToken()).withUserId(result.getUserId()).withExpire(result.getExpire()), System.currentTimeMillis() + 900000L);
        this.token = result.getToken();
        this.userId = result.getUserId();
        this.expire = result.getExpire();
        return domain;
    }

    public static String createCacheParentKey(String childType) {
        return String.join((CharSequence)":", "auth", childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public AccessToken model() {
        AccessToken value = this.cache.get(this.parentKey, AccessTokenDomain.createCacheKey(), AccessToken.class);
        return value;
    }
}

