/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.account.domain.model;

import io.gs2.account.Gs2AccountRestClient;
import io.gs2.account.domain.iterator.DescribeAccountsIterator;
import io.gs2.account.domain.model.AccountAccessTokenDomain;
import io.gs2.account.domain.model.AccountDomain;
import io.gs2.account.domain.model.TakeOverDomain;
import io.gs2.account.model.Namespace;
import io.gs2.account.model.TakeOver;
import io.gs2.account.request.CreateAccountRequest;
import io.gs2.account.request.DeleteNamespaceRequest;
import io.gs2.account.request.DeleteTakeOverByUserIdentifierRequest;
import io.gs2.account.request.DoTakeOverRequest;
import io.gs2.account.request.GetNamespaceRequest;
import io.gs2.account.request.GetNamespaceStatusRequest;
import io.gs2.account.request.UpdateNamespaceRequest;
import io.gs2.account.result.CreateAccountResult;
import io.gs2.account.result.DeleteNamespaceResult;
import io.gs2.account.result.DeleteTakeOverByUserIdentifierResult;
import io.gs2.account.result.DoTakeOverResult;
import io.gs2.account.result.GetNamespaceResult;
import io.gs2.account.result.GetNamespaceStatusResult;
import io.gs2.account.result.UpdateNamespaceResult;
import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;

public class NamespaceDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2AccountRestClient client;
    private final String namespaceName;
    private final String parentKey;
    String status;
    String nextPageToken;

    public String getStatus() {
        return this.status;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public NamespaceDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2AccountRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = "account:Namespace";
    }

    public NamespaceDomain getStatus(GetNamespaceStatusRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceStatusResult result = this.client.getNamespaceStatus(request);
        NamespaceDomain domain = this;
        this.status = result.getStatus();
        return domain;
    }

    private Namespace get(GetNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceResult result = this.client.getNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public NamespaceDomain update(UpdateNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateNamespaceResult result = this.client.updateNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = this;
        return domain;
    }

    public NamespaceDomain delete(DeleteNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        DeleteNamespaceResult result = null;
        try {
            result = this.client.deleteNamespace(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), Namespace.class);
        NamespaceDomain domain = this;
        return domain;
    }

    public AccountDomain createAccount(CreateAccountRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateAccountResult result = this.client.createAccount(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Account");
        if (result.getItem() != null) {
            this.cache.put(parentKey, AccountDomain.createCacheKey(result.getItem().getUserId() != null ? result.getItem().getUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        AccountDomain domain = new AccountDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId());
        return domain;
    }

    public TakeOverDomain deleteTakeOverByUserIdentifier(DeleteTakeOverByUserIdentifierRequest request) {
        request.withNamespaceName(this.namespaceName);
        DeleteTakeOverByUserIdentifierResult result = null;
        try {
            result = this.client.deleteTakeOverByUserIdentifier(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        String parentKey = AccountDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, result.getItem() != null ? result.getItem().getUserId() : null, "TakeOver");
        this.cache.delete(parentKey, TakeOverDomain.createCacheKey(request.getType() != null ? request.getType().toString() : null), TakeOver.class);
        TakeOverDomain domain = new TakeOverDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), result.getItem().getType());
        return domain;
    }

    public AccountDomain doTakeOver(DoTakeOverRequest request) {
        request.withNamespaceName(this.namespaceName);
        DoTakeOverResult result = this.client.doTakeOver(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Account");
        if (result.getItem() != null) {
            this.cache.put(parentKey, AccountDomain.createCacheKey(result.getItem().getUserId() != null ? result.getItem().getUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        AccountDomain domain = new AccountDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId());
        return domain;
    }

    public DescribeAccountsIterator accounts() {
        return new DescribeAccountsIterator(this.cache, this.client, this.namespaceName);
    }

    public AccountDomain account(String userId) {
        return new AccountDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, userId);
    }

    public AccountAccessTokenDomain accessToken(AccessToken accessToken) {
        return new AccountAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, accessToken);
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "account", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public Namespace model() {
        Namespace value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        if (value == null) {
            try {
                this.get(new GetNamespaceRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
            }
            value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        }
        return value;
    }
}

