/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.account.domain.model;

import io.gs2.account.Gs2AccountRestClient;
import io.gs2.account.domain.iterator.DescribeTakeOversByUserIdIterator;
import io.gs2.account.domain.model.NamespaceDomain;
import io.gs2.account.domain.model.TakeOverDomain;
import io.gs2.account.model.Account;
import io.gs2.account.request.AuthenticationRequest;
import io.gs2.account.request.DeleteAccountRequest;
import io.gs2.account.request.GetAccountRequest;
import io.gs2.account.request.UpdateTimeOffsetRequest;
import io.gs2.account.result.AuthenticationResult;
import io.gs2.account.result.DeleteAccountResult;
import io.gs2.account.result.GetAccountResult;
import io.gs2.account.result.UpdateTimeOffsetResult;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;

public class AccountDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2AccountRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;
    String body;
    String signature;
    String nextPageToken;

    public String getBody() {
        return this.body;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public AccountDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2AccountRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Account");
    }

    public AccountDomain updateTimeOffset(UpdateTimeOffsetRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        UpdateTimeOffsetResult result = this.client.updateTimeOffset(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, AccountDomain.createCacheKey(request.getUserId() != null ? request.getUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        AccountDomain domain = this;
        return domain;
    }

    private Account get(GetAccountRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        GetAccountResult result = this.client.getAccount(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, AccountDomain.createCacheKey(request.getUserId() != null ? request.getUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public AccountDomain delete(DeleteAccountRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        DeleteAccountResult result = null;
        try {
            result = this.client.deleteAccount(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, AccountDomain.createCacheKey(request.getUserId() != null ? request.getUserId().toString() : null), Account.class);
        AccountDomain domain = this;
        return domain;
    }

    public AccountDomain authentication(AuthenticationRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId);
        AuthenticationResult result = this.client.authentication(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, AccountDomain.createCacheKey(request.getUserId() != null ? request.getUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        AccountDomain domain = this;
        domain.body = result.getBody();
        domain.signature = result.getSignature();
        return domain;
    }

    public DescribeTakeOversByUserIdIterator takeOvers() {
        return new DescribeTakeOversByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public TakeOverDomain takeOver(Integer type) {
        return new TakeOverDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, type);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "account", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }

    public Account model() {
        Account value = this.cache.get(this.parentKey, AccountDomain.createCacheKey(this.getUserId() != null ? this.getUserId().toString() : null), Account.class);
        if (value == null) {
            try {
                this.get(new GetAccountRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, AccountDomain.createCacheKey(this.getUserId() != null ? this.getUserId().toString() : null), Account.class);
            }
            value = this.cache.get(this.parentKey, AccountDomain.createCacheKey(this.getUserId() != null ? this.getUserId().toString() : null), Account.class);
        }
        return value;
    }
}

