/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.account.domain.model;

import io.gs2.account.Gs2AccountRestClient;
import io.gs2.account.domain.iterator.DescribeTakeOversIterator;
import io.gs2.account.domain.model.AccountDomain;
import io.gs2.account.domain.model.NamespaceDomain;
import io.gs2.account.domain.model.TakeOverAccessTokenDomain;
import io.gs2.account.model.Account;
import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;

public class AccountAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2AccountRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;
    String body;
    String signature;
    String nextPageToken;

    public String getBody() {
        return this.body;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public AccountAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2AccountRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Account");
    }

    public DescribeTakeOversIterator takeOvers() {
        return new DescribeTakeOversIterator(this.cache, this.client, this.namespaceName, this.accessToken);
    }

    public TakeOverAccessTokenDomain takeOver(Integer type) {
        return new TakeOverAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, type);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "account", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }

    public Account model() {
        Account value = this.cache.get(this.parentKey, AccountDomain.createCacheKey(this.getUserId() != null ? this.getUserId().toString() : null), Account.class);
        return value;
    }
}

