/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.account.domain.iterator;

import io.gs2.account.Gs2AccountRestClient;
import io.gs2.account.domain.model.AccountDomain;
import io.gs2.account.domain.model.TakeOverDomain;
import io.gs2.account.model.TakeOver;
import io.gs2.account.request.DescribeTakeOversByUserIdRequest;
import io.gs2.account.result.DescribeTakeOversByUserIdResult;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeTakeOversByUserIdIterator
implements Iterator<TakeOver>,
Iterable<TakeOver> {
    CacheDatabase cache;
    Gs2AccountRestClient client;
    String namespaceName;
    String userId;
    String pageToken;
    boolean last;
    List<TakeOver> result;
    Integer fetchSize;

    public DescribeTakeOversByUserIdIterator(CacheDatabase cache, Gs2AccountRestClient client, String namespaceName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<TakeOver>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = AccountDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "TakeOver");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, TakeOver.class)) {
            this.result = this.cache.list(parentKey, TakeOver.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeTakeOversByUserIdResult r = this.client.describeTakeOversByUserId(new DescribeTakeOversByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (TakeOver item : this.result) {
                this.cache.put(parentKey, TakeOverDomain.createCacheKey(item.getType() != null ? item.getType().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, TakeOver.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public TakeOver next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        TakeOver ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<TakeOver> iterator() {
        return this;
    }
}

