/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.account.domain.iterator;

import io.gs2.account.Gs2AccountRestClient;
import io.gs2.account.domain.model.AccountDomain;
import io.gs2.account.domain.model.NamespaceDomain;
import io.gs2.account.model.Account;
import io.gs2.account.request.DescribeAccountsRequest;
import io.gs2.account.result.DescribeAccountsResult;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeAccountsIterator
implements Iterator<Account>,
Iterable<Account> {
    CacheDatabase cache;
    Gs2AccountRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<Account> result;
    Integer fetchSize;

    public DescribeAccountsIterator(CacheDatabase cache, Gs2AccountRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Account>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Account");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Account.class)) {
            this.result = this.cache.list(parentKey, Account.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeAccountsResult r = this.client.describeAccounts(new DescribeAccountsRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Account item : this.result) {
                this.cache.put(parentKey, AccountDomain.createCacheKey(item.getUserId() != null ? item.getUserId().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Account.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Account next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Account ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Account> iterator() {
        return this;
    }
}

