/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.datastore.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DataObject
implements IModel,
Serializable,
Comparable<DataObject> {
    private String dataObjectId;
    private String name;
    private String userId;
    private String scope;
    private List<String> allowUserIds;
    private String status;
    private String generation;
    private String previousGeneration;
    private Long createdAt;
    private Long updatedAt;
    private Long revision;

    public String getDataObjectId() {
        return this.dataObjectId;
    }

    public void setDataObjectId(String dataObjectId) {
        this.dataObjectId = dataObjectId;
    }

    public DataObject withDataObjectId(String dataObjectId) {
        this.dataObjectId = dataObjectId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataObject withName(String name) {
        this.name = name;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public DataObject withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public DataObject withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public List<String> getAllowUserIds() {
        return this.allowUserIds;
    }

    public void setAllowUserIds(List<String> allowUserIds) {
        this.allowUserIds = allowUserIds;
    }

    public DataObject withAllowUserIds(List<String> allowUserIds) {
        this.allowUserIds = allowUserIds;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public DataObject withStatus(String status) {
        this.status = status;
        return this;
    }

    public String getGeneration() {
        return this.generation;
    }

    public void setGeneration(String generation) {
        this.generation = generation;
    }

    public DataObject withGeneration(String generation) {
        this.generation = generation;
        return this;
    }

    public String getPreviousGeneration() {
        return this.previousGeneration;
    }

    public void setPreviousGeneration(String previousGeneration) {
        this.previousGeneration = previousGeneration;
    }

    public DataObject withPreviousGeneration(String previousGeneration) {
        this.previousGeneration = previousGeneration;
        return this;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public DataObject withCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public DataObject withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public Long getRevision() {
        return this.revision;
    }

    public void setRevision(Long revision) {
        this.revision = revision;
    }

    public DataObject withRevision(Long revision) {
        this.revision = revision;
        return this;
    }

    public static DataObject fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new DataObject().withDataObjectId(data.get("dataObjectId") == null || data.get("dataObjectId").isNull() ? null : data.get("dataObjectId").asText()).withName(data.get("name") == null || data.get("name").isNull() ? null : data.get("name").asText()).withUserId(data.get("userId") == null || data.get("userId").isNull() ? null : data.get("userId").asText()).withScope(data.get("scope") == null || data.get("scope").isNull() ? null : data.get("scope").asText()).withAllowUserIds(data.get("allowUserIds") == null || data.get("allowUserIds").isNull() ? new ArrayList<String>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("allowUserIds").elements(), 256), false).map(item -> item.asText()).collect(Collectors.toList())).withStatus(data.get("status") == null || data.get("status").isNull() ? null : data.get("status").asText()).withGeneration(data.get("generation") == null || data.get("generation").isNull() ? null : data.get("generation").asText()).withPreviousGeneration(data.get("previousGeneration") == null || data.get("previousGeneration").isNull() ? null : data.get("previousGeneration").asText()).withCreatedAt(data.get("createdAt") == null || data.get("createdAt").isNull() ? null : Long.valueOf(data.get("createdAt").longValue())).withUpdatedAt(data.get("updatedAt") == null || data.get("updatedAt").isNull() ? null : Long.valueOf(data.get("updatedAt").longValue())).withRevision(data.get("revision") == null || data.get("revision").isNull() ? null : Long.valueOf(data.get("revision").longValue()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("dataObjectId", DataObject.this.getDataObjectId());
                this.put("name", DataObject.this.getName());
                this.put("userId", DataObject.this.getUserId());
                this.put("scope", DataObject.this.getScope());
                this.put("allowUserIds", DataObject.this.getAllowUserIds() == null ? new ArrayList() : DataObject.this.getAllowUserIds().stream().map(item -> item).collect(Collectors.toList()));
                this.put("status", DataObject.this.getStatus());
                this.put("generation", DataObject.this.getGeneration());
                this.put("previousGeneration", DataObject.this.getPreviousGeneration());
                this.put("createdAt", DataObject.this.getCreatedAt());
                this.put("updatedAt", DataObject.this.getUpdatedAt());
                this.put("revision", DataObject.this.getRevision());
            }
        });
    }

    @Override
    public int compareTo(DataObject o) {
        return this.dataObjectId.compareTo(o.dataObjectId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataObjectId == null ? 0 : this.dataObjectId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.allowUserIds == null ? 0 : this.allowUserIds.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.generation == null ? 0 : this.generation.hashCode());
        result = 31 * result + (this.previousGeneration == null ? 0 : this.previousGeneration.hashCode());
        result = 31 * result + (this.createdAt == null ? 0 : this.createdAt.hashCode());
        result = 31 * result + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        DataObject other = (DataObject)o;
        if (this.dataObjectId == null) {
            return other.dataObjectId == null;
        }
        if (!this.dataObjectId.equals(other.dataObjectId)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.userId == null) {
            return other.userId == null;
        }
        if (!this.userId.equals(other.userId)) {
            return false;
        }
        if (this.scope == null) {
            return other.scope == null;
        }
        if (!this.scope.equals(other.scope)) {
            return false;
        }
        if (this.allowUserIds == null) {
            return other.allowUserIds == null;
        }
        if (!this.allowUserIds.equals(other.allowUserIds)) {
            return false;
        }
        if (this.status == null) {
            return other.status == null;
        }
        if (!this.status.equals(other.status)) {
            return false;
        }
        if (this.generation == null) {
            return other.generation == null;
        }
        if (!this.generation.equals(other.generation)) {
            return false;
        }
        if (this.previousGeneration == null) {
            return other.previousGeneration == null;
        }
        if (!this.previousGeneration.equals(other.previousGeneration)) {
            return false;
        }
        if (this.createdAt == null) {
            return other.createdAt == null;
        }
        if (!this.createdAt.equals(other.createdAt)) {
            return false;
        }
        if (this.updatedAt == null) {
            return other.updatedAt == null;
        }
        if (!this.updatedAt.equals(other.updatedAt)) {
            return false;
        }
        if (this.revision == null) {
            return other.revision == null;
        }
        return this.revision.equals(other.revision);
    }
}

