/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.watch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.watch.request.DescribeBillingActivitiesRequest;
import io.gs2.watch.request.GetBillingActivityRequest;
import io.gs2.watch.request.GetChartRequest;
import io.gs2.watch.request.GetCumulativeRequest;
import io.gs2.watch.result.DescribeBillingActivitiesResult;
import io.gs2.watch.result.GetBillingActivityResult;
import io.gs2.watch.result.GetChartResult;
import io.gs2.watch.result.GetCumulativeResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2WatchRestClient
extends AbstractGs2Client<Gs2WatchRestClient> {
    public Gs2WatchRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void getChartAsync(GetChartRequest request, AsyncAction<AsyncResult<GetChartResult>> callback) {
        GetChartTask task = new GetChartTask(request, callback);
        this.session.execute(task);
    }

    public GetChartResult getChart(GetChartRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getChartAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetChartResult)resultAsyncResult[0].getResult();
    }

    public void getCumulativeAsync(GetCumulativeRequest request, AsyncAction<AsyncResult<GetCumulativeResult>> callback) {
        GetCumulativeTask task = new GetCumulativeTask(request, callback);
        this.session.execute(task);
    }

    public GetCumulativeResult getCumulative(GetCumulativeRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCumulativeAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCumulativeResult)resultAsyncResult[0].getResult();
    }

    public void describeBillingActivitiesAsync(DescribeBillingActivitiesRequest request, AsyncAction<AsyncResult<DescribeBillingActivitiesResult>> callback) {
        DescribeBillingActivitiesTask task = new DescribeBillingActivitiesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeBillingActivitiesResult describeBillingActivities(DescribeBillingActivitiesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeBillingActivitiesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeBillingActivitiesResult)resultAsyncResult[0].getResult();
    }

    public void getBillingActivityAsync(GetBillingActivityRequest request, AsyncAction<AsyncResult<GetBillingActivityResult>> callback) {
        GetBillingActivityTask task = new GetBillingActivityTask(request, callback);
        this.session.execute(task);
    }

    public GetBillingActivityResult getBillingActivity(GetBillingActivityRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getBillingActivityAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetBillingActivityResult)resultAsyncResult[0].getResult();
    }

    class GetChartTask
    extends Gs2RestSessionTask<GetChartResult> {
        private GetChartRequest request;

        public GetChartTask(GetChartRequest request, AsyncAction<AsyncResult<GetChartResult>> userCallback) {
            super((Gs2RestSession)Gs2WatchRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetChartResult parse(JsonNode data) {
            return GetChartResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "watch").replace("{region}", Gs2WatchRestClient.this.session.getRegion().getName()) + "/chart/{metrics}";
            url = url.replace("{metrics}", this.request.getMetrics() == null || this.request.getMetrics().length() == 0 ? "null" : String.valueOf(this.request.getMetrics()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("grn", GetChartTask.this.request.getGrn());
                    this.put("queries", GetChartTask.this.request.getQueries() == null ? new ArrayList() : GetChartTask.this.request.getQueries().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("by", GetChartTask.this.request.getBy());
                    this.put("timeframe", GetChartTask.this.request.getTimeframe());
                    this.put("size", GetChartTask.this.request.getSize());
                    this.put("format", GetChartTask.this.request.getFormat());
                    this.put("aggregator", GetChartTask.this.request.getAggregator());
                    this.put("style", GetChartTask.this.request.getStyle());
                    this.put("title", GetChartTask.this.request.getTitle());
                    this.put("contextStack", GetChartTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCumulativeTask
    extends Gs2RestSessionTask<GetCumulativeResult> {
        private GetCumulativeRequest request;

        public GetCumulativeTask(GetCumulativeRequest request, AsyncAction<AsyncResult<GetCumulativeResult>> userCallback) {
            super((Gs2RestSession)Gs2WatchRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCumulativeResult parse(JsonNode data) {
            return GetCumulativeResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "watch").replace("{region}", Gs2WatchRestClient.this.session.getRegion().getName()) + "/cumulative/{name}";
            url = url.replace("{name}", this.request.getName() == null || this.request.getName().length() == 0 ? "null" : String.valueOf(this.request.getName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("resourceGrn", GetCumulativeTask.this.request.getResourceGrn());
                    this.put("contextStack", GetCumulativeTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeBillingActivitiesTask
    extends Gs2RestSessionTask<DescribeBillingActivitiesResult> {
        private DescribeBillingActivitiesRequest request;

        public DescribeBillingActivitiesTask(DescribeBillingActivitiesRequest request, AsyncAction<AsyncResult<DescribeBillingActivitiesResult>> userCallback) {
            super((Gs2RestSession)Gs2WatchRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeBillingActivitiesResult parse(JsonNode data) {
            return DescribeBillingActivitiesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "watch").replace("{region}", Gs2WatchRestClient.this.session.getRegion().getName()) + "/billingActivity/{year}/{month}";
            url = url.replace("{year}", this.request.getYear() == null ? "null" : String.valueOf(this.request.getYear()));
            url = url.replace("{month}", this.request.getMonth() == null ? "null" : String.valueOf(this.request.getMonth()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getService() != null) {
                queryStrings.add("service=" + EncodingUtil.urlEncode(String.valueOf(this.request.getService())));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetBillingActivityTask
    extends Gs2RestSessionTask<GetBillingActivityResult> {
        private GetBillingActivityRequest request;

        public GetBillingActivityTask(GetBillingActivityRequest request, AsyncAction<AsyncResult<GetBillingActivityResult>> userCallback) {
            super((Gs2RestSession)Gs2WatchRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetBillingActivityResult parse(JsonNode data) {
            return GetBillingActivityResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "watch").replace("{region}", Gs2WatchRestClient.this.session.getRegion().getName()) + "/billingActivity/{year}/{month}/{service}/{activityType}";
            url = url.replace("{year}", this.request.getYear() == null ? "null" : String.valueOf(this.request.getYear()));
            url = url.replace("{month}", this.request.getMonth() == null ? "null" : String.valueOf(this.request.getMonth()));
            url = url.replace("{service}", this.request.getService() == null || this.request.getService().length() == 0 ? "null" : String.valueOf(this.request.getService()));
            url = url.replace("{activityType}", this.request.getActivityType() == null || this.request.getActivityType().length() == 0 ? "null" : String.valueOf(this.request.getActivityType()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", GetBillingActivityTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

