/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.skillTree.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import io.gs2.skillTree.model.AcquireAction;
import io.gs2.skillTree.model.ConsumeAction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NodeModel
implements IModel,
Serializable,
Comparable<NodeModel> {
    private String nodeModelId;
    private String name;
    private String metadata;
    private List<ConsumeAction> releaseConsumeActions;
    private List<AcquireAction> returnAcquireActions;
    private Float restrainReturnRate;
    private List<String> premiseNodeNames;

    public String getNodeModelId() {
        return this.nodeModelId;
    }

    public void setNodeModelId(String nodeModelId) {
        this.nodeModelId = nodeModelId;
    }

    public NodeModel withNodeModelId(String nodeModelId) {
        this.nodeModelId = nodeModelId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NodeModel withName(String name) {
        this.name = name;
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public NodeModel withMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<ConsumeAction> getReleaseConsumeActions() {
        return this.releaseConsumeActions;
    }

    public void setReleaseConsumeActions(List<ConsumeAction> releaseConsumeActions) {
        this.releaseConsumeActions = releaseConsumeActions;
    }

    public NodeModel withReleaseConsumeActions(List<ConsumeAction> releaseConsumeActions) {
        this.releaseConsumeActions = releaseConsumeActions;
        return this;
    }

    public List<AcquireAction> getReturnAcquireActions() {
        return this.returnAcquireActions;
    }

    public void setReturnAcquireActions(List<AcquireAction> returnAcquireActions) {
        this.returnAcquireActions = returnAcquireActions;
    }

    public NodeModel withReturnAcquireActions(List<AcquireAction> returnAcquireActions) {
        this.returnAcquireActions = returnAcquireActions;
        return this;
    }

    public Float getRestrainReturnRate() {
        return this.restrainReturnRate;
    }

    public void setRestrainReturnRate(Float restrainReturnRate) {
        this.restrainReturnRate = restrainReturnRate;
    }

    public NodeModel withRestrainReturnRate(Float restrainReturnRate) {
        this.restrainReturnRate = restrainReturnRate;
        return this;
    }

    public List<String> getPremiseNodeNames() {
        return this.premiseNodeNames;
    }

    public void setPremiseNodeNames(List<String> premiseNodeNames) {
        this.premiseNodeNames = premiseNodeNames;
    }

    public NodeModel withPremiseNodeNames(List<String> premiseNodeNames) {
        this.premiseNodeNames = premiseNodeNames;
        return this;
    }

    public static NodeModel fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new NodeModel().withNodeModelId(data.get("nodeModelId") == null || data.get("nodeModelId").isNull() ? null : data.get("nodeModelId").asText()).withName(data.get("name") == null || data.get("name").isNull() ? null : data.get("name").asText()).withMetadata(data.get("metadata") == null || data.get("metadata").isNull() ? null : data.get("metadata").asText()).withReleaseConsumeActions(data.get("releaseConsumeActions") == null || data.get("releaseConsumeActions").isNull() ? new ArrayList<ConsumeAction>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("releaseConsumeActions").elements(), 256), false).map(item -> ConsumeAction.fromJson(item)).collect(Collectors.toList())).withReturnAcquireActions(data.get("returnAcquireActions") == null || data.get("returnAcquireActions").isNull() ? new ArrayList<AcquireAction>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("returnAcquireActions").elements(), 256), false).map(item -> AcquireAction.fromJson(item)).collect(Collectors.toList())).withRestrainReturnRate(data.get("restrainReturnRate") == null || data.get("restrainReturnRate").isNull() ? null : Float.valueOf(data.get("restrainReturnRate").floatValue())).withPremiseNodeNames(data.get("premiseNodeNames") == null || data.get("premiseNodeNames").isNull() ? new ArrayList<String>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("premiseNodeNames").elements(), 256), false).map(item -> item.asText()).collect(Collectors.toList()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("nodeModelId", NodeModel.this.getNodeModelId());
                this.put("name", NodeModel.this.getName());
                this.put("metadata", NodeModel.this.getMetadata());
                this.put("releaseConsumeActions", NodeModel.this.getReleaseConsumeActions() == null ? new ArrayList() : NodeModel.this.getReleaseConsumeActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                this.put("returnAcquireActions", NodeModel.this.getReturnAcquireActions() == null ? new ArrayList() : NodeModel.this.getReturnAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                this.put("restrainReturnRate", NodeModel.this.getRestrainReturnRate());
                this.put("premiseNodeNames", NodeModel.this.getPremiseNodeNames() == null ? new ArrayList() : NodeModel.this.getPremiseNodeNames().stream().map(item -> item).collect(Collectors.toList()));
            }
        });
    }

    @Override
    public int compareTo(NodeModel o) {
        return this.nodeModelId.compareTo(o.nodeModelId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeModelId == null ? 0 : this.nodeModelId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.releaseConsumeActions == null ? 0 : this.releaseConsumeActions.hashCode());
        result = 31 * result + (this.returnAcquireActions == null ? 0 : this.returnAcquireActions.hashCode());
        result = 31 * result + (this.restrainReturnRate == null ? 0 : this.restrainReturnRate.hashCode());
        result = 31 * result + (this.premiseNodeNames == null ? 0 : this.premiseNodeNames.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        NodeModel other = (NodeModel)o;
        if (this.nodeModelId == null) {
            return other.nodeModelId == null;
        }
        if (!this.nodeModelId.equals(other.nodeModelId)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.metadata == null) {
            return other.metadata == null;
        }
        if (!this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.releaseConsumeActions == null) {
            return other.releaseConsumeActions == null;
        }
        if (!this.releaseConsumeActions.equals(other.releaseConsumeActions)) {
            return false;
        }
        if (this.returnAcquireActions == null) {
            return other.returnAcquireActions == null;
        }
        if (!this.returnAcquireActions.equals(other.returnAcquireActions)) {
            return false;
        }
        if (this.restrainReturnRate == null) {
            return other.restrainReturnRate == null;
        }
        if (!this.restrainReturnRate.equals(other.restrainReturnRate)) {
            return false;
        }
        if (this.premiseNodeNames == null) {
            return other.premiseNodeNames == null;
        }
        return this.premiseNodeNames.equals(other.premiseNodeNames);
    }
}

