/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.gateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.gateway.request.CheckCleanUserDataByUserIdRequest;
import io.gs2.gateway.request.CheckDumpUserDataByUserIdRequest;
import io.gs2.gateway.request.CheckImportUserDataByUserIdRequest;
import io.gs2.gateway.request.CleanUserDataByUserIdRequest;
import io.gs2.gateway.request.CreateNamespaceRequest;
import io.gs2.gateway.request.DeleteFirebaseTokenByUserIdRequest;
import io.gs2.gateway.request.DeleteFirebaseTokenRequest;
import io.gs2.gateway.request.DeleteNamespaceRequest;
import io.gs2.gateway.request.DescribeNamespacesRequest;
import io.gs2.gateway.request.DescribeWebSocketSessionsByUserIdRequest;
import io.gs2.gateway.request.DescribeWebSocketSessionsRequest;
import io.gs2.gateway.request.DisconnectAllRequest;
import io.gs2.gateway.request.DisconnectByUserIdRequest;
import io.gs2.gateway.request.DumpUserDataByUserIdRequest;
import io.gs2.gateway.request.GetFirebaseTokenByUserIdRequest;
import io.gs2.gateway.request.GetFirebaseTokenRequest;
import io.gs2.gateway.request.GetNamespaceRequest;
import io.gs2.gateway.request.GetNamespaceStatusRequest;
import io.gs2.gateway.request.ImportUserDataByUserIdRequest;
import io.gs2.gateway.request.PrepareImportUserDataByUserIdRequest;
import io.gs2.gateway.request.SendMobileNotificationByUserIdRequest;
import io.gs2.gateway.request.SendNotificationRequest;
import io.gs2.gateway.request.SetFirebaseTokenByUserIdRequest;
import io.gs2.gateway.request.SetFirebaseTokenRequest;
import io.gs2.gateway.request.SetUserIdByUserIdRequest;
import io.gs2.gateway.request.SetUserIdRequest;
import io.gs2.gateway.request.UpdateNamespaceRequest;
import io.gs2.gateway.result.CheckCleanUserDataByUserIdResult;
import io.gs2.gateway.result.CheckDumpUserDataByUserIdResult;
import io.gs2.gateway.result.CheckImportUserDataByUserIdResult;
import io.gs2.gateway.result.CleanUserDataByUserIdResult;
import io.gs2.gateway.result.CreateNamespaceResult;
import io.gs2.gateway.result.DeleteFirebaseTokenByUserIdResult;
import io.gs2.gateway.result.DeleteFirebaseTokenResult;
import io.gs2.gateway.result.DeleteNamespaceResult;
import io.gs2.gateway.result.DescribeNamespacesResult;
import io.gs2.gateway.result.DescribeWebSocketSessionsByUserIdResult;
import io.gs2.gateway.result.DescribeWebSocketSessionsResult;
import io.gs2.gateway.result.DisconnectAllResult;
import io.gs2.gateway.result.DisconnectByUserIdResult;
import io.gs2.gateway.result.DumpUserDataByUserIdResult;
import io.gs2.gateway.result.GetFirebaseTokenByUserIdResult;
import io.gs2.gateway.result.GetFirebaseTokenResult;
import io.gs2.gateway.result.GetNamespaceResult;
import io.gs2.gateway.result.GetNamespaceStatusResult;
import io.gs2.gateway.result.ImportUserDataByUserIdResult;
import io.gs2.gateway.result.PrepareImportUserDataByUserIdResult;
import io.gs2.gateway.result.SendMobileNotificationByUserIdResult;
import io.gs2.gateway.result.SendNotificationResult;
import io.gs2.gateway.result.SetFirebaseTokenByUserIdResult;
import io.gs2.gateway.result.SetFirebaseTokenResult;
import io.gs2.gateway.result.SetUserIdByUserIdResult;
import io.gs2.gateway.result.SetUserIdResult;
import io.gs2.gateway.result.UpdateNamespaceResult;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2GatewayRestClient
extends AbstractGs2Client<Gs2GatewayRestClient> {
    public Gs2GatewayRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void dumpUserDataByUserIdAsync(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> callback) {
        DumpUserDataByUserIdTask task = new DumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DumpUserDataByUserIdResult dumpUserDataByUserId(DumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.dumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkDumpUserDataByUserIdAsync(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> callback) {
        CheckDumpUserDataByUserIdTask task = new CheckDumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckDumpUserDataByUserIdResult checkDumpUserDataByUserId(CheckDumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkDumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckDumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void cleanUserDataByUserIdAsync(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> callback) {
        CleanUserDataByUserIdTask task = new CleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CleanUserDataByUserIdResult cleanUserDataByUserId(CleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.cleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkCleanUserDataByUserIdAsync(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> callback) {
        CheckCleanUserDataByUserIdTask task = new CheckCleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckCleanUserDataByUserIdResult checkCleanUserDataByUserId(CheckCleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkCleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckCleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareImportUserDataByUserIdAsync(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> callback) {
        PrepareImportUserDataByUserIdTask task = new PrepareImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareImportUserDataByUserIdResult prepareImportUserDataByUserId(PrepareImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void importUserDataByUserIdAsync(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> callback) {
        ImportUserDataByUserIdTask task = new ImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ImportUserDataByUserIdResult importUserDataByUserId(ImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.importUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkImportUserDataByUserIdAsync(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> callback) {
        CheckImportUserDataByUserIdTask task = new CheckImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckImportUserDataByUserIdResult checkImportUserDataByUserId(CheckImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeWebSocketSessionsAsync(DescribeWebSocketSessionsRequest request, AsyncAction<AsyncResult<DescribeWebSocketSessionsResult>> callback) {
        DescribeWebSocketSessionsTask task = new DescribeWebSocketSessionsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeWebSocketSessionsResult describeWebSocketSessions(DescribeWebSocketSessionsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeWebSocketSessionsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeWebSocketSessionsResult)resultAsyncResult[0].getResult();
    }

    public void describeWebSocketSessionsByUserIdAsync(DescribeWebSocketSessionsByUserIdRequest request, AsyncAction<AsyncResult<DescribeWebSocketSessionsByUserIdResult>> callback) {
        DescribeWebSocketSessionsByUserIdTask task = new DescribeWebSocketSessionsByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeWebSocketSessionsByUserIdResult describeWebSocketSessionsByUserId(DescribeWebSocketSessionsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeWebSocketSessionsByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeWebSocketSessionsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void setUserIdAsync(SetUserIdRequest request, AsyncAction<AsyncResult<SetUserIdResult>> callback) {
        SetUserIdTask task = new SetUserIdTask(request, callback);
        this.session.execute(task);
    }

    public SetUserIdResult setUserId(SetUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.setUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SetUserIdResult)resultAsyncResult[0].getResult();
    }

    public void setUserIdByUserIdAsync(SetUserIdByUserIdRequest request, AsyncAction<AsyncResult<SetUserIdByUserIdResult>> callback) {
        SetUserIdByUserIdTask task = new SetUserIdByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public SetUserIdByUserIdResult setUserIdByUserId(SetUserIdByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.setUserIdByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SetUserIdByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void sendNotificationAsync(SendNotificationRequest request, AsyncAction<AsyncResult<SendNotificationResult>> callback) {
        SendNotificationTask task = new SendNotificationTask(request, callback);
        this.session.execute(task);
    }

    public SendNotificationResult sendNotification(SendNotificationRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.sendNotificationAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SendNotificationResult)resultAsyncResult[0].getResult();
    }

    public void disconnectByUserIdAsync(DisconnectByUserIdRequest request, AsyncAction<AsyncResult<DisconnectByUserIdResult>> callback) {
        DisconnectByUserIdTask task = new DisconnectByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DisconnectByUserIdResult disconnectByUserId(DisconnectByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.disconnectByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DisconnectByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void disconnectAllAsync(DisconnectAllRequest request, AsyncAction<AsyncResult<DisconnectAllResult>> callback) {
        DisconnectAllTask task = new DisconnectAllTask(request, callback);
        this.session.execute(task);
    }

    public DisconnectAllResult disconnectAll(DisconnectAllRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.disconnectAllAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DisconnectAllResult)resultAsyncResult[0].getResult();
    }

    public void setFirebaseTokenAsync(SetFirebaseTokenRequest request, AsyncAction<AsyncResult<SetFirebaseTokenResult>> callback) {
        SetFirebaseTokenTask task = new SetFirebaseTokenTask(request, callback);
        this.session.execute(task);
    }

    public SetFirebaseTokenResult setFirebaseToken(SetFirebaseTokenRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.setFirebaseTokenAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SetFirebaseTokenResult)resultAsyncResult[0].getResult();
    }

    public void setFirebaseTokenByUserIdAsync(SetFirebaseTokenByUserIdRequest request, AsyncAction<AsyncResult<SetFirebaseTokenByUserIdResult>> callback) {
        SetFirebaseTokenByUserIdTask task = new SetFirebaseTokenByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public SetFirebaseTokenByUserIdResult setFirebaseTokenByUserId(SetFirebaseTokenByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.setFirebaseTokenByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SetFirebaseTokenByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getFirebaseTokenAsync(GetFirebaseTokenRequest request, AsyncAction<AsyncResult<GetFirebaseTokenResult>> callback) {
        GetFirebaseTokenTask task = new GetFirebaseTokenTask(request, callback);
        this.session.execute(task);
    }

    public GetFirebaseTokenResult getFirebaseToken(GetFirebaseTokenRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getFirebaseTokenAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetFirebaseTokenResult)resultAsyncResult[0].getResult();
    }

    public void getFirebaseTokenByUserIdAsync(GetFirebaseTokenByUserIdRequest request, AsyncAction<AsyncResult<GetFirebaseTokenByUserIdResult>> callback) {
        GetFirebaseTokenByUserIdTask task = new GetFirebaseTokenByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetFirebaseTokenByUserIdResult getFirebaseTokenByUserId(GetFirebaseTokenByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getFirebaseTokenByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetFirebaseTokenByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteFirebaseTokenAsync(DeleteFirebaseTokenRequest request, AsyncAction<AsyncResult<DeleteFirebaseTokenResult>> callback) {
        DeleteFirebaseTokenTask task = new DeleteFirebaseTokenTask(request, callback);
        this.session.execute(task);
    }

    public DeleteFirebaseTokenResult deleteFirebaseToken(DeleteFirebaseTokenRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteFirebaseTokenAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteFirebaseTokenResult)resultAsyncResult[0].getResult();
    }

    public void deleteFirebaseTokenByUserIdAsync(DeleteFirebaseTokenByUserIdRequest request, AsyncAction<AsyncResult<DeleteFirebaseTokenByUserIdResult>> callback) {
        DeleteFirebaseTokenByUserIdTask task = new DeleteFirebaseTokenByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteFirebaseTokenByUserIdResult deleteFirebaseTokenByUserId(DeleteFirebaseTokenByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteFirebaseTokenByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteFirebaseTokenByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void sendMobileNotificationByUserIdAsync(SendMobileNotificationByUserIdRequest request, AsyncAction<AsyncResult<SendMobileNotificationByUserIdResult>> callback) {
        SendMobileNotificationByUserIdTask task = new SendMobileNotificationByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public SendMobileNotificationByUserIdResult sendMobileNotificationByUserId(SendMobileNotificationByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.sendMobileNotificationByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SendMobileNotificationByUserIdResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("firebaseSecret", CreateNamespaceTask.this.request.getFirebaseSecret());
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("firebaseSecret", UpdateNamespaceTask.this.request.getFirebaseSecret());
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DumpUserDataByUserIdTask
    extends Gs2RestSessionTask<DumpUserDataByUserIdResult> {
        private DumpUserDataByUserIdRequest request;

        public DumpUserDataByUserIdTask(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DumpUserDataByUserIdResult parse(JsonNode data) {
            return DumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DumpUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class CheckDumpUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckDumpUserDataByUserIdResult> {
        private CheckDumpUserDataByUserIdRequest request;

        public CheckDumpUserDataByUserIdTask(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckDumpUserDataByUserIdResult parse(JsonNode data) {
            return CheckDumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class CleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CleanUserDataByUserIdResult> {
        private CleanUserDataByUserIdRequest request;

        public CleanUserDataByUserIdTask(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CleanUserDataByUserIdResult parse(JsonNode data) {
            return CleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CleanUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class CheckCleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckCleanUserDataByUserIdResult> {
        private CheckCleanUserDataByUserIdRequest request;

        public CheckCleanUserDataByUserIdTask(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckCleanUserDataByUserIdResult parse(JsonNode data) {
            return CheckCleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class PrepareImportUserDataByUserIdTask
    extends Gs2RestSessionTask<PrepareImportUserDataByUserIdResult> {
        private PrepareImportUserDataByUserIdRequest request;

        public PrepareImportUserDataByUserIdTask(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareImportUserDataByUserIdResult parse(JsonNode data) {
            return PrepareImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/prepare";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PrepareImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class ImportUserDataByUserIdTask
    extends Gs2RestSessionTask<ImportUserDataByUserIdResult> {
        private ImportUserDataByUserIdRequest request;

        public ImportUserDataByUserIdTask(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ImportUserDataByUserIdResult parse(JsonNode data) {
            return ImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("uploadToken", ImportUserDataByUserIdTask.this.request.getUploadToken());
                    this.put("contextStack", ImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class CheckImportUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckImportUserDataByUserIdResult> {
        private CheckImportUserDataByUserIdRequest request;

        public CheckImportUserDataByUserIdTask(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckImportUserDataByUserIdResult parse(JsonNode data) {
            return CheckImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/{uploadToken}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{uploadToken}", this.request.getUploadToken() == null || this.request.getUploadToken().length() == 0 ? "null" : String.valueOf(this.request.getUploadToken()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeWebSocketSessionsTask
    extends Gs2RestSessionTask<DescribeWebSocketSessionsResult> {
        private DescribeWebSocketSessionsRequest request;

        public DescribeWebSocketSessionsTask(DescribeWebSocketSessionsRequest request, AsyncAction<AsyncResult<DescribeWebSocketSessionsResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeWebSocketSessionsResult parse(JsonNode data) {
            return DescribeWebSocketSessionsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}/session/user/me";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeWebSocketSessionsByUserIdTask
    extends Gs2RestSessionTask<DescribeWebSocketSessionsByUserIdResult> {
        private DescribeWebSocketSessionsByUserIdRequest request;

        public DescribeWebSocketSessionsByUserIdTask(DescribeWebSocketSessionsByUserIdRequest request, AsyncAction<AsyncResult<DescribeWebSocketSessionsByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeWebSocketSessionsByUserIdResult parse(JsonNode data) {
            return DescribeWebSocketSessionsByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}/session/user/{userId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class SetUserIdTask
    extends Gs2RestSessionTask<SetUserIdResult> {
        private SetUserIdRequest request;

        public SetUserIdTask(SetUserIdRequest request, AsyncAction<AsyncResult<SetUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SetUserIdResult parse(JsonNode data) {
            return SetUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}/session/user/me/user";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("allowConcurrentAccess", SetUserIdTask.this.request.getAllowConcurrentAccess());
                    this.put("contextStack", SetUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class SetUserIdByUserIdTask
    extends Gs2RestSessionTask<SetUserIdByUserIdResult> {
        private SetUserIdByUserIdRequest request;

        public SetUserIdByUserIdTask(SetUserIdByUserIdRequest request, AsyncAction<AsyncResult<SetUserIdByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SetUserIdByUserIdResult parse(JsonNode data) {
            return SetUserIdByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}/session/user/{userId}/user";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("allowConcurrentAccess", SetUserIdByUserIdTask.this.request.getAllowConcurrentAccess());
                    this.put("contextStack", SetUserIdByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class SendNotificationTask
    extends Gs2RestSessionTask<SendNotificationResult> {
        private SendNotificationRequest request;

        public SendNotificationTask(SendNotificationRequest request, AsyncAction<AsyncResult<SendNotificationResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SendNotificationResult parse(JsonNode data) {
            return SendNotificationResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}/session/user/{userId}/notification";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("subject", SendNotificationTask.this.request.getSubject());
                    this.put("payload", SendNotificationTask.this.request.getPayload());
                    this.put("enableTransferMobileNotification", SendNotificationTask.this.request.getEnableTransferMobileNotification());
                    this.put("sound", SendNotificationTask.this.request.getSound());
                    this.put("contextStack", SendNotificationTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class DisconnectByUserIdTask
    extends Gs2RestSessionTask<DisconnectByUserIdResult> {
        private DisconnectByUserIdRequest request;

        public DisconnectByUserIdTask(DisconnectByUserIdRequest request, AsyncAction<AsyncResult<DisconnectByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DisconnectByUserIdResult parse(JsonNode data) {
            return DisconnectByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}/session/user/{userId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class DisconnectAllTask
    extends Gs2RestSessionTask<DisconnectAllResult> {
        private DisconnectAllRequest request;

        public DisconnectAllTask(DisconnectAllRequest request, AsyncAction<AsyncResult<DisconnectAllResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DisconnectAllResult parse(JsonNode data) {
            return DisconnectAllResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}/session";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class SetFirebaseTokenTask
    extends Gs2RestSessionTask<SetFirebaseTokenResult> {
        private SetFirebaseTokenRequest request;

        public SetFirebaseTokenTask(SetFirebaseTokenRequest request, AsyncAction<AsyncResult<SetFirebaseTokenResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SetFirebaseTokenResult parse(JsonNode data) {
            return SetFirebaseTokenResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/firebase/token";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("token", SetFirebaseTokenTask.this.request.getToken());
                    this.put("contextStack", SetFirebaseTokenTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class SetFirebaseTokenByUserIdTask
    extends Gs2RestSessionTask<SetFirebaseTokenByUserIdResult> {
        private SetFirebaseTokenByUserIdRequest request;

        public SetFirebaseTokenByUserIdTask(SetFirebaseTokenByUserIdRequest request, AsyncAction<AsyncResult<SetFirebaseTokenByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SetFirebaseTokenByUserIdResult parse(JsonNode data) {
            return SetFirebaseTokenByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/firebase/token";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("token", SetFirebaseTokenByUserIdTask.this.request.getToken());
                    this.put("contextStack", SetFirebaseTokenByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class GetFirebaseTokenTask
    extends Gs2RestSessionTask<GetFirebaseTokenResult> {
        private GetFirebaseTokenRequest request;

        public GetFirebaseTokenTask(GetFirebaseTokenRequest request, AsyncAction<AsyncResult<GetFirebaseTokenResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetFirebaseTokenResult parse(JsonNode data) {
            return GetFirebaseTokenResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/firebase/token";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetFirebaseTokenByUserIdTask
    extends Gs2RestSessionTask<GetFirebaseTokenByUserIdResult> {
        private GetFirebaseTokenByUserIdRequest request;

        public GetFirebaseTokenByUserIdTask(GetFirebaseTokenByUserIdRequest request, AsyncAction<AsyncResult<GetFirebaseTokenByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetFirebaseTokenByUserIdResult parse(JsonNode data) {
            return GetFirebaseTokenByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/firebase/token";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class DeleteFirebaseTokenTask
    extends Gs2RestSessionTask<DeleteFirebaseTokenResult> {
        private DeleteFirebaseTokenRequest request;

        public DeleteFirebaseTokenTask(DeleteFirebaseTokenRequest request, AsyncAction<AsyncResult<DeleteFirebaseTokenResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteFirebaseTokenResult parse(JsonNode data) {
            return DeleteFirebaseTokenResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/firebase/token";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteFirebaseTokenByUserIdTask
    extends Gs2RestSessionTask<DeleteFirebaseTokenByUserIdResult> {
        private DeleteFirebaseTokenByUserIdRequest request;

        public DeleteFirebaseTokenByUserIdTask(DeleteFirebaseTokenByUserIdRequest request, AsyncAction<AsyncResult<DeleteFirebaseTokenByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteFirebaseTokenByUserIdResult parse(JsonNode data) {
            return DeleteFirebaseTokenByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/firebase/token";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class SendMobileNotificationByUserIdTask
    extends Gs2RestSessionTask<SendMobileNotificationByUserIdResult> {
        private SendMobileNotificationByUserIdRequest request;

        public SendMobileNotificationByUserIdTask(SendMobileNotificationByUserIdRequest request, AsyncAction<AsyncResult<SendMobileNotificationByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2GatewayRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SendMobileNotificationByUserIdResult parse(JsonNode data) {
            return SendMobileNotificationByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "gateway").replace("{region}", Gs2GatewayRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/firebase/token/notification";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("subject", SendMobileNotificationByUserIdTask.this.request.getSubject());
                    this.put("payload", SendMobileNotificationByUserIdTask.this.request.getPayload());
                    this.put("sound", SendMobileNotificationByUserIdTask.this.request.getSound());
                    this.put("contextStack", SendMobileNotificationByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }
}

