/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.core.net;

import io.gs2.core.net.HttpTask;
import io.gs2.core.net.IResponseHandler;
import java.util.HashMap;
import java.util.Map;

public class HttpTaskBuilder {
    private HttpTask.Method method;
    private String url;
    private Map<String, String> headers = new HashMap<String, String>();
    private byte[] body;
    private IResponseHandler handler;

    private HttpTaskBuilder() {
    }

    public static HttpTaskBuilder create() {
        return new HttpTaskBuilder();
    }

    public HttpTaskBuilder setMethod(HttpTask.Method method) {
        this.method = method;
        return this;
    }

    public HttpTaskBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public HttpTaskBuilder setHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public HttpTaskBuilder setBody(byte[] body) {
        this.body = body;
        return this;
    }

    public HttpTaskBuilder setHttpResponseHandler(IResponseHandler handler) {
        this.handler = handler;
        return this;
    }

    public HttpTask build() {
        HttpTask httpTask = new HttpTask(this.method, this.url, this.handler);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            httpTask.addHeaderEntry(entry.getKey(), entry.getValue());
        }
        if (this.method == HttpTask.Method.POST || this.method == HttpTask.Method.PUT) {
            httpTask.setBody(this.body);
        }
        return httpTask;
    }
}

