/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.formation.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import io.gs2.formation.model.SlotModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FormModel
implements IModel,
Serializable,
Comparable<FormModel> {
    private String formModelId;
    private String name;
    private String metadata;
    private List<SlotModel> slots;

    public String getFormModelId() {
        return this.formModelId;
    }

    public void setFormModelId(String formModelId) {
        this.formModelId = formModelId;
    }

    public FormModel withFormModelId(String formModelId) {
        this.formModelId = formModelId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FormModel withName(String name) {
        this.name = name;
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public FormModel withMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<SlotModel> getSlots() {
        return this.slots;
    }

    public void setSlots(List<SlotModel> slots) {
        this.slots = slots;
    }

    public FormModel withSlots(List<SlotModel> slots) {
        this.slots = slots;
        return this;
    }

    public static FormModel fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new FormModel().withFormModelId(data.get("formModelId") == null || data.get("formModelId").isNull() ? null : data.get("formModelId").asText()).withName(data.get("name") == null || data.get("name").isNull() ? null : data.get("name").asText()).withMetadata(data.get("metadata") == null || data.get("metadata").isNull() ? null : data.get("metadata").asText()).withSlots(data.get("slots") == null || data.get("slots").isNull() ? new ArrayList<SlotModel>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("slots").elements(), 256), false).map(item -> SlotModel.fromJson(item)).collect(Collectors.toList()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("formModelId", FormModel.this.getFormModelId());
                this.put("name", FormModel.this.getName());
                this.put("metadata", FormModel.this.getMetadata());
                this.put("slots", FormModel.this.getSlots() == null ? new ArrayList() : FormModel.this.getSlots().stream().map(item -> item.toJson()).collect(Collectors.toList()));
            }
        });
    }

    @Override
    public int compareTo(FormModel o) {
        return this.formModelId.compareTo(o.formModelId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.formModelId == null ? 0 : this.formModelId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.slots == null ? 0 : this.slots.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        FormModel other = (FormModel)o;
        if (this.formModelId == null) {
            return other.formModelId == null;
        }
        if (!this.formModelId.equals(other.formModelId)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.metadata == null) {
            return other.metadata == null;
        }
        if (!this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.slots == null) {
            return other.slots == null;
        }
        return this.slots.equals(other.slots);
    }
}

