/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.experience.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import io.gs2.experience.model.AcquireActionRate;
import io.gs2.experience.model.Threshold;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExperienceModel
implements IModel,
Serializable,
Comparable<ExperienceModel> {
    private String experienceModelId;
    private String name;
    private String metadata;
    private Long defaultExperience;
    private Long defaultRankCap;
    private Long maxRankCap;
    private Threshold rankThreshold;
    private List<AcquireActionRate> acquireActionRates;

    public String getExperienceModelId() {
        return this.experienceModelId;
    }

    public void setExperienceModelId(String experienceModelId) {
        this.experienceModelId = experienceModelId;
    }

    public ExperienceModel withExperienceModelId(String experienceModelId) {
        this.experienceModelId = experienceModelId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExperienceModel withName(String name) {
        this.name = name;
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public ExperienceModel withMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public Long getDefaultExperience() {
        return this.defaultExperience;
    }

    public void setDefaultExperience(Long defaultExperience) {
        this.defaultExperience = defaultExperience;
    }

    public ExperienceModel withDefaultExperience(Long defaultExperience) {
        this.defaultExperience = defaultExperience;
        return this;
    }

    public Long getDefaultRankCap() {
        return this.defaultRankCap;
    }

    public void setDefaultRankCap(Long defaultRankCap) {
        this.defaultRankCap = defaultRankCap;
    }

    public ExperienceModel withDefaultRankCap(Long defaultRankCap) {
        this.defaultRankCap = defaultRankCap;
        return this;
    }

    public Long getMaxRankCap() {
        return this.maxRankCap;
    }

    public void setMaxRankCap(Long maxRankCap) {
        this.maxRankCap = maxRankCap;
    }

    public ExperienceModel withMaxRankCap(Long maxRankCap) {
        this.maxRankCap = maxRankCap;
        return this;
    }

    public Threshold getRankThreshold() {
        return this.rankThreshold;
    }

    public void setRankThreshold(Threshold rankThreshold) {
        this.rankThreshold = rankThreshold;
    }

    public ExperienceModel withRankThreshold(Threshold rankThreshold) {
        this.rankThreshold = rankThreshold;
        return this;
    }

    public List<AcquireActionRate> getAcquireActionRates() {
        return this.acquireActionRates;
    }

    public void setAcquireActionRates(List<AcquireActionRate> acquireActionRates) {
        this.acquireActionRates = acquireActionRates;
    }

    public ExperienceModel withAcquireActionRates(List<AcquireActionRate> acquireActionRates) {
        this.acquireActionRates = acquireActionRates;
        return this;
    }

    public static ExperienceModel fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new ExperienceModel().withExperienceModelId(data.get("experienceModelId") == null || data.get("experienceModelId").isNull() ? null : data.get("experienceModelId").asText()).withName(data.get("name") == null || data.get("name").isNull() ? null : data.get("name").asText()).withMetadata(data.get("metadata") == null || data.get("metadata").isNull() ? null : data.get("metadata").asText()).withDefaultExperience(data.get("defaultExperience") == null || data.get("defaultExperience").isNull() ? null : Long.valueOf(data.get("defaultExperience").longValue())).withDefaultRankCap(data.get("defaultRankCap") == null || data.get("defaultRankCap").isNull() ? null : Long.valueOf(data.get("defaultRankCap").longValue())).withMaxRankCap(data.get("maxRankCap") == null || data.get("maxRankCap").isNull() ? null : Long.valueOf(data.get("maxRankCap").longValue())).withRankThreshold(data.get("rankThreshold") == null || data.get("rankThreshold").isNull() ? null : Threshold.fromJson(data.get("rankThreshold"))).withAcquireActionRates(data.get("acquireActionRates") == null || data.get("acquireActionRates").isNull() ? new ArrayList<AcquireActionRate>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("acquireActionRates").elements(), 256), false).map(item -> AcquireActionRate.fromJson(item)).collect(Collectors.toList()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("experienceModelId", ExperienceModel.this.getExperienceModelId());
                this.put("name", ExperienceModel.this.getName());
                this.put("metadata", ExperienceModel.this.getMetadata());
                this.put("defaultExperience", ExperienceModel.this.getDefaultExperience());
                this.put("defaultRankCap", ExperienceModel.this.getDefaultRankCap());
                this.put("maxRankCap", ExperienceModel.this.getMaxRankCap());
                this.put("rankThreshold", ExperienceModel.this.getRankThreshold() != null ? ExperienceModel.this.getRankThreshold().toJson() : null);
                this.put("acquireActionRates", ExperienceModel.this.getAcquireActionRates() == null ? new ArrayList() : ExperienceModel.this.getAcquireActionRates().stream().map(item -> item.toJson()).collect(Collectors.toList()));
            }
        });
    }

    @Override
    public int compareTo(ExperienceModel o) {
        return this.experienceModelId.compareTo(o.experienceModelId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.experienceModelId == null ? 0 : this.experienceModelId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.defaultExperience == null ? 0 : this.defaultExperience.hashCode());
        result = 31 * result + (this.defaultRankCap == null ? 0 : this.defaultRankCap.hashCode());
        result = 31 * result + (this.maxRankCap == null ? 0 : this.maxRankCap.hashCode());
        result = 31 * result + (this.rankThreshold == null ? 0 : this.rankThreshold.hashCode());
        result = 31 * result + (this.acquireActionRates == null ? 0 : this.acquireActionRates.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ExperienceModel other = (ExperienceModel)o;
        if (this.experienceModelId == null) {
            return other.experienceModelId == null;
        }
        if (!this.experienceModelId.equals(other.experienceModelId)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.metadata == null) {
            return other.metadata == null;
        }
        if (!this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.defaultExperience == null) {
            return other.defaultExperience == null;
        }
        if (!this.defaultExperience.equals(other.defaultExperience)) {
            return false;
        }
        if (this.defaultRankCap == null) {
            return other.defaultRankCap == null;
        }
        if (!this.defaultRankCap.equals(other.defaultRankCap)) {
            return false;
        }
        if (this.maxRankCap == null) {
            return other.maxRankCap == null;
        }
        if (!this.maxRankCap.equals(other.maxRankCap)) {
            return false;
        }
        if (this.rankThreshold == null) {
            return other.rankThreshold == null;
        }
        if (!this.rankThreshold.equals(other.rankThreshold)) {
            return false;
        }
        if (this.acquireActionRates == null) {
            return other.acquireActionRates == null;
        }
        return this.acquireActionRates.equals(other.acquireActionRates);
    }
}

