/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.datastore;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.datastore.request.CheckCleanUserDataByUserIdRequest;
import io.gs2.datastore.request.CheckDumpUserDataByUserIdRequest;
import io.gs2.datastore.request.CheckImportUserDataByUserIdRequest;
import io.gs2.datastore.request.CleanUserDataByUserIdRequest;
import io.gs2.datastore.request.CreateNamespaceRequest;
import io.gs2.datastore.request.DeleteDataObjectByUserIdRequest;
import io.gs2.datastore.request.DeleteDataObjectRequest;
import io.gs2.datastore.request.DeleteNamespaceRequest;
import io.gs2.datastore.request.DescribeDataObjectHistoriesByUserIdRequest;
import io.gs2.datastore.request.DescribeDataObjectHistoriesRequest;
import io.gs2.datastore.request.DescribeDataObjectsByUserIdRequest;
import io.gs2.datastore.request.DescribeDataObjectsRequest;
import io.gs2.datastore.request.DescribeNamespacesRequest;
import io.gs2.datastore.request.DoneUploadByUserIdRequest;
import io.gs2.datastore.request.DoneUploadRequest;
import io.gs2.datastore.request.DumpUserDataByUserIdRequest;
import io.gs2.datastore.request.GetDataObjectHistoryByUserIdRequest;
import io.gs2.datastore.request.GetDataObjectHistoryRequest;
import io.gs2.datastore.request.GetNamespaceRequest;
import io.gs2.datastore.request.GetNamespaceStatusRequest;
import io.gs2.datastore.request.ImportUserDataByUserIdRequest;
import io.gs2.datastore.request.PrepareDownloadByGenerationAndUserIdRequest;
import io.gs2.datastore.request.PrepareDownloadByGenerationRequest;
import io.gs2.datastore.request.PrepareDownloadByUserIdAndDataObjectNameAndGenerationRequest;
import io.gs2.datastore.request.PrepareDownloadByUserIdAndDataObjectNameRequest;
import io.gs2.datastore.request.PrepareDownloadByUserIdRequest;
import io.gs2.datastore.request.PrepareDownloadOwnDataByGenerationRequest;
import io.gs2.datastore.request.PrepareDownloadOwnDataRequest;
import io.gs2.datastore.request.PrepareDownloadRequest;
import io.gs2.datastore.request.PrepareImportUserDataByUserIdRequest;
import io.gs2.datastore.request.PrepareReUploadByUserIdRequest;
import io.gs2.datastore.request.PrepareReUploadRequest;
import io.gs2.datastore.request.PrepareUploadByUserIdRequest;
import io.gs2.datastore.request.PrepareUploadRequest;
import io.gs2.datastore.request.RestoreDataObjectRequest;
import io.gs2.datastore.request.UpdateDataObjectByUserIdRequest;
import io.gs2.datastore.request.UpdateDataObjectRequest;
import io.gs2.datastore.request.UpdateNamespaceRequest;
import io.gs2.datastore.result.CheckCleanUserDataByUserIdResult;
import io.gs2.datastore.result.CheckDumpUserDataByUserIdResult;
import io.gs2.datastore.result.CheckImportUserDataByUserIdResult;
import io.gs2.datastore.result.CleanUserDataByUserIdResult;
import io.gs2.datastore.result.CreateNamespaceResult;
import io.gs2.datastore.result.DeleteDataObjectByUserIdResult;
import io.gs2.datastore.result.DeleteDataObjectResult;
import io.gs2.datastore.result.DeleteNamespaceResult;
import io.gs2.datastore.result.DescribeDataObjectHistoriesByUserIdResult;
import io.gs2.datastore.result.DescribeDataObjectHistoriesResult;
import io.gs2.datastore.result.DescribeDataObjectsByUserIdResult;
import io.gs2.datastore.result.DescribeDataObjectsResult;
import io.gs2.datastore.result.DescribeNamespacesResult;
import io.gs2.datastore.result.DoneUploadByUserIdResult;
import io.gs2.datastore.result.DoneUploadResult;
import io.gs2.datastore.result.DumpUserDataByUserIdResult;
import io.gs2.datastore.result.GetDataObjectHistoryByUserIdResult;
import io.gs2.datastore.result.GetDataObjectHistoryResult;
import io.gs2.datastore.result.GetNamespaceResult;
import io.gs2.datastore.result.GetNamespaceStatusResult;
import io.gs2.datastore.result.ImportUserDataByUserIdResult;
import io.gs2.datastore.result.PrepareDownloadByGenerationAndUserIdResult;
import io.gs2.datastore.result.PrepareDownloadByGenerationResult;
import io.gs2.datastore.result.PrepareDownloadByUserIdAndDataObjectNameAndGenerationResult;
import io.gs2.datastore.result.PrepareDownloadByUserIdAndDataObjectNameResult;
import io.gs2.datastore.result.PrepareDownloadByUserIdResult;
import io.gs2.datastore.result.PrepareDownloadOwnDataByGenerationResult;
import io.gs2.datastore.result.PrepareDownloadOwnDataResult;
import io.gs2.datastore.result.PrepareDownloadResult;
import io.gs2.datastore.result.PrepareImportUserDataByUserIdResult;
import io.gs2.datastore.result.PrepareReUploadByUserIdResult;
import io.gs2.datastore.result.PrepareReUploadResult;
import io.gs2.datastore.result.PrepareUploadByUserIdResult;
import io.gs2.datastore.result.PrepareUploadResult;
import io.gs2.datastore.result.RestoreDataObjectResult;
import io.gs2.datastore.result.UpdateDataObjectByUserIdResult;
import io.gs2.datastore.result.UpdateDataObjectResult;
import io.gs2.datastore.result.UpdateNamespaceResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2DatastoreRestClient
extends AbstractGs2Client<Gs2DatastoreRestClient> {
    public Gs2DatastoreRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void dumpUserDataByUserIdAsync(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> callback) {
        DumpUserDataByUserIdTask task = new DumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DumpUserDataByUserIdResult dumpUserDataByUserId(DumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.dumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkDumpUserDataByUserIdAsync(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> callback) {
        CheckDumpUserDataByUserIdTask task = new CheckDumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckDumpUserDataByUserIdResult checkDumpUserDataByUserId(CheckDumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkDumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckDumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void cleanUserDataByUserIdAsync(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> callback) {
        CleanUserDataByUserIdTask task = new CleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CleanUserDataByUserIdResult cleanUserDataByUserId(CleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.cleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkCleanUserDataByUserIdAsync(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> callback) {
        CheckCleanUserDataByUserIdTask task = new CheckCleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckCleanUserDataByUserIdResult checkCleanUserDataByUserId(CheckCleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkCleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckCleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareImportUserDataByUserIdAsync(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> callback) {
        PrepareImportUserDataByUserIdTask task = new PrepareImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareImportUserDataByUserIdResult prepareImportUserDataByUserId(PrepareImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void importUserDataByUserIdAsync(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> callback) {
        ImportUserDataByUserIdTask task = new ImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ImportUserDataByUserIdResult importUserDataByUserId(ImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.importUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkImportUserDataByUserIdAsync(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> callback) {
        CheckImportUserDataByUserIdTask task = new CheckImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckImportUserDataByUserIdResult checkImportUserDataByUserId(CheckImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeDataObjectsAsync(DescribeDataObjectsRequest request, AsyncAction<AsyncResult<DescribeDataObjectsResult>> callback) {
        DescribeDataObjectsTask task = new DescribeDataObjectsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeDataObjectsResult describeDataObjects(DescribeDataObjectsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeDataObjectsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeDataObjectsResult)resultAsyncResult[0].getResult();
    }

    public void describeDataObjectsByUserIdAsync(DescribeDataObjectsByUserIdRequest request, AsyncAction<AsyncResult<DescribeDataObjectsByUserIdResult>> callback) {
        DescribeDataObjectsByUserIdTask task = new DescribeDataObjectsByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeDataObjectsByUserIdResult describeDataObjectsByUserId(DescribeDataObjectsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeDataObjectsByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeDataObjectsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareUploadAsync(PrepareUploadRequest request, AsyncAction<AsyncResult<PrepareUploadResult>> callback) {
        PrepareUploadTask task = new PrepareUploadTask(request, callback);
        this.session.execute(task);
    }

    public PrepareUploadResult prepareUpload(PrepareUploadRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareUploadAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareUploadResult)resultAsyncResult[0].getResult();
    }

    public void prepareUploadByUserIdAsync(PrepareUploadByUserIdRequest request, AsyncAction<AsyncResult<PrepareUploadByUserIdResult>> callback) {
        PrepareUploadByUserIdTask task = new PrepareUploadByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareUploadByUserIdResult prepareUploadByUserId(PrepareUploadByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareUploadByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareUploadByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void updateDataObjectAsync(UpdateDataObjectRequest request, AsyncAction<AsyncResult<UpdateDataObjectResult>> callback) {
        UpdateDataObjectTask task = new UpdateDataObjectTask(request, callback);
        this.session.execute(task);
    }

    public UpdateDataObjectResult updateDataObject(UpdateDataObjectRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateDataObjectAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateDataObjectResult)resultAsyncResult[0].getResult();
    }

    public void updateDataObjectByUserIdAsync(UpdateDataObjectByUserIdRequest request, AsyncAction<AsyncResult<UpdateDataObjectByUserIdResult>> callback) {
        UpdateDataObjectByUserIdTask task = new UpdateDataObjectByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public UpdateDataObjectByUserIdResult updateDataObjectByUserId(UpdateDataObjectByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateDataObjectByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateDataObjectByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareReUploadAsync(PrepareReUploadRequest request, AsyncAction<AsyncResult<PrepareReUploadResult>> callback) {
        PrepareReUploadTask task = new PrepareReUploadTask(request, callback);
        this.session.execute(task);
    }

    public PrepareReUploadResult prepareReUpload(PrepareReUploadRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareReUploadAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareReUploadResult)resultAsyncResult[0].getResult();
    }

    public void prepareReUploadByUserIdAsync(PrepareReUploadByUserIdRequest request, AsyncAction<AsyncResult<PrepareReUploadByUserIdResult>> callback) {
        PrepareReUploadByUserIdTask task = new PrepareReUploadByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareReUploadByUserIdResult prepareReUploadByUserId(PrepareReUploadByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareReUploadByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareReUploadByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void doneUploadAsync(DoneUploadRequest request, AsyncAction<AsyncResult<DoneUploadResult>> callback) {
        DoneUploadTask task = new DoneUploadTask(request, callback);
        this.session.execute(task);
    }

    public DoneUploadResult doneUpload(DoneUploadRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.doneUploadAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DoneUploadResult)resultAsyncResult[0].getResult();
    }

    public void doneUploadByUserIdAsync(DoneUploadByUserIdRequest request, AsyncAction<AsyncResult<DoneUploadByUserIdResult>> callback) {
        DoneUploadByUserIdTask task = new DoneUploadByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DoneUploadByUserIdResult doneUploadByUserId(DoneUploadByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.doneUploadByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DoneUploadByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteDataObjectAsync(DeleteDataObjectRequest request, AsyncAction<AsyncResult<DeleteDataObjectResult>> callback) {
        DeleteDataObjectTask task = new DeleteDataObjectTask(request, callback);
        this.session.execute(task);
    }

    public DeleteDataObjectResult deleteDataObject(DeleteDataObjectRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteDataObjectAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteDataObjectResult)resultAsyncResult[0].getResult();
    }

    public void deleteDataObjectByUserIdAsync(DeleteDataObjectByUserIdRequest request, AsyncAction<AsyncResult<DeleteDataObjectByUserIdResult>> callback) {
        DeleteDataObjectByUserIdTask task = new DeleteDataObjectByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteDataObjectByUserIdResult deleteDataObjectByUserId(DeleteDataObjectByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteDataObjectByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteDataObjectByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareDownloadAsync(PrepareDownloadRequest request, AsyncAction<AsyncResult<PrepareDownloadResult>> callback) {
        PrepareDownloadTask task = new PrepareDownloadTask(request, callback);
        this.session.execute(task);
    }

    public PrepareDownloadResult prepareDownload(PrepareDownloadRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareDownloadAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareDownloadResult)resultAsyncResult[0].getResult();
    }

    public void prepareDownloadByUserIdAsync(PrepareDownloadByUserIdRequest request, AsyncAction<AsyncResult<PrepareDownloadByUserIdResult>> callback) {
        PrepareDownloadByUserIdTask task = new PrepareDownloadByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareDownloadByUserIdResult prepareDownloadByUserId(PrepareDownloadByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareDownloadByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareDownloadByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareDownloadByGenerationAsync(PrepareDownloadByGenerationRequest request, AsyncAction<AsyncResult<PrepareDownloadByGenerationResult>> callback) {
        PrepareDownloadByGenerationTask task = new PrepareDownloadByGenerationTask(request, callback);
        this.session.execute(task);
    }

    public PrepareDownloadByGenerationResult prepareDownloadByGeneration(PrepareDownloadByGenerationRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareDownloadByGenerationAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareDownloadByGenerationResult)resultAsyncResult[0].getResult();
    }

    public void prepareDownloadByGenerationAndUserIdAsync(PrepareDownloadByGenerationAndUserIdRequest request, AsyncAction<AsyncResult<PrepareDownloadByGenerationAndUserIdResult>> callback) {
        PrepareDownloadByGenerationAndUserIdTask task = new PrepareDownloadByGenerationAndUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareDownloadByGenerationAndUserIdResult prepareDownloadByGenerationAndUserId(PrepareDownloadByGenerationAndUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareDownloadByGenerationAndUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareDownloadByGenerationAndUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareDownloadOwnDataAsync(PrepareDownloadOwnDataRequest request, AsyncAction<AsyncResult<PrepareDownloadOwnDataResult>> callback) {
        PrepareDownloadOwnDataTask task = new PrepareDownloadOwnDataTask(request, callback);
        this.session.execute(task);
    }

    public PrepareDownloadOwnDataResult prepareDownloadOwnData(PrepareDownloadOwnDataRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareDownloadOwnDataAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareDownloadOwnDataResult)resultAsyncResult[0].getResult();
    }

    public void prepareDownloadByUserIdAndDataObjectNameAsync(PrepareDownloadByUserIdAndDataObjectNameRequest request, AsyncAction<AsyncResult<PrepareDownloadByUserIdAndDataObjectNameResult>> callback) {
        PrepareDownloadByUserIdAndDataObjectNameTask task = new PrepareDownloadByUserIdAndDataObjectNameTask(request, callback);
        this.session.execute(task);
    }

    public PrepareDownloadByUserIdAndDataObjectNameResult prepareDownloadByUserIdAndDataObjectName(PrepareDownloadByUserIdAndDataObjectNameRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareDownloadByUserIdAndDataObjectNameAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareDownloadByUserIdAndDataObjectNameResult)resultAsyncResult[0].getResult();
    }

    public void prepareDownloadOwnDataByGenerationAsync(PrepareDownloadOwnDataByGenerationRequest request, AsyncAction<AsyncResult<PrepareDownloadOwnDataByGenerationResult>> callback) {
        PrepareDownloadOwnDataByGenerationTask task = new PrepareDownloadOwnDataByGenerationTask(request, callback);
        this.session.execute(task);
    }

    public PrepareDownloadOwnDataByGenerationResult prepareDownloadOwnDataByGeneration(PrepareDownloadOwnDataByGenerationRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareDownloadOwnDataByGenerationAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareDownloadOwnDataByGenerationResult)resultAsyncResult[0].getResult();
    }

    public void prepareDownloadByUserIdAndDataObjectNameAndGenerationAsync(PrepareDownloadByUserIdAndDataObjectNameAndGenerationRequest request, AsyncAction<AsyncResult<PrepareDownloadByUserIdAndDataObjectNameAndGenerationResult>> callback) {
        PrepareDownloadByUserIdAndDataObjectNameAndGenerationTask task = new PrepareDownloadByUserIdAndDataObjectNameAndGenerationTask(request, callback);
        this.session.execute(task);
    }

    public PrepareDownloadByUserIdAndDataObjectNameAndGenerationResult prepareDownloadByUserIdAndDataObjectNameAndGeneration(PrepareDownloadByUserIdAndDataObjectNameAndGenerationRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareDownloadByUserIdAndDataObjectNameAndGenerationAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareDownloadByUserIdAndDataObjectNameAndGenerationResult)resultAsyncResult[0].getResult();
    }

    public void restoreDataObjectAsync(RestoreDataObjectRequest request, AsyncAction<AsyncResult<RestoreDataObjectResult>> callback) {
        RestoreDataObjectTask task = new RestoreDataObjectTask(request, callback);
        this.session.execute(task);
    }

    public RestoreDataObjectResult restoreDataObject(RestoreDataObjectRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.restoreDataObjectAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RestoreDataObjectResult)resultAsyncResult[0].getResult();
    }

    public void describeDataObjectHistoriesAsync(DescribeDataObjectHistoriesRequest request, AsyncAction<AsyncResult<DescribeDataObjectHistoriesResult>> callback) {
        DescribeDataObjectHistoriesTask task = new DescribeDataObjectHistoriesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeDataObjectHistoriesResult describeDataObjectHistories(DescribeDataObjectHistoriesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeDataObjectHistoriesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeDataObjectHistoriesResult)resultAsyncResult[0].getResult();
    }

    public void describeDataObjectHistoriesByUserIdAsync(DescribeDataObjectHistoriesByUserIdRequest request, AsyncAction<AsyncResult<DescribeDataObjectHistoriesByUserIdResult>> callback) {
        DescribeDataObjectHistoriesByUserIdTask task = new DescribeDataObjectHistoriesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeDataObjectHistoriesByUserIdResult describeDataObjectHistoriesByUserId(DescribeDataObjectHistoriesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeDataObjectHistoriesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeDataObjectHistoriesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getDataObjectHistoryAsync(GetDataObjectHistoryRequest request, AsyncAction<AsyncResult<GetDataObjectHistoryResult>> callback) {
        GetDataObjectHistoryTask task = new GetDataObjectHistoryTask(request, callback);
        this.session.execute(task);
    }

    public GetDataObjectHistoryResult getDataObjectHistory(GetDataObjectHistoryRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getDataObjectHistoryAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetDataObjectHistoryResult)resultAsyncResult[0].getResult();
    }

    public void getDataObjectHistoryByUserIdAsync(GetDataObjectHistoryByUserIdRequest request, AsyncAction<AsyncResult<GetDataObjectHistoryByUserIdResult>> callback) {
        GetDataObjectHistoryByUserIdTask task = new GetDataObjectHistoryByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetDataObjectHistoryByUserIdResult getDataObjectHistoryByUserId(GetDataObjectHistoryByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getDataObjectHistoryByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetDataObjectHistoryByUserIdResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("doneUploadScript", CreateNamespaceTask.this.request.getDoneUploadScript() != null ? CreateNamespaceTask.this.request.getDoneUploadScript().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("doneUploadScript", UpdateNamespaceTask.this.request.getDoneUploadScript() != null ? UpdateNamespaceTask.this.request.getDoneUploadScript().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DumpUserDataByUserIdTask
    extends Gs2RestSessionTask<DumpUserDataByUserIdResult> {
        private DumpUserDataByUserIdRequest request;

        public DumpUserDataByUserIdTask(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DumpUserDataByUserIdResult parse(JsonNode data) {
            return DumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DumpUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckDumpUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckDumpUserDataByUserIdResult> {
        private CheckDumpUserDataByUserIdRequest request;

        public CheckDumpUserDataByUserIdTask(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckDumpUserDataByUserIdResult parse(JsonNode data) {
            return CheckDumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CleanUserDataByUserIdResult> {
        private CleanUserDataByUserIdRequest request;

        public CleanUserDataByUserIdTask(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CleanUserDataByUserIdResult parse(JsonNode data) {
            return CleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CleanUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckCleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckCleanUserDataByUserIdResult> {
        private CheckCleanUserDataByUserIdRequest request;

        public CheckCleanUserDataByUserIdTask(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckCleanUserDataByUserIdResult parse(JsonNode data) {
            return CheckCleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareImportUserDataByUserIdTask
    extends Gs2RestSessionTask<PrepareImportUserDataByUserIdResult> {
        private PrepareImportUserDataByUserIdRequest request;

        public PrepareImportUserDataByUserIdTask(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareImportUserDataByUserIdResult parse(JsonNode data) {
            return PrepareImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/prepare";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PrepareImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ImportUserDataByUserIdTask
    extends Gs2RestSessionTask<ImportUserDataByUserIdResult> {
        private ImportUserDataByUserIdRequest request;

        public ImportUserDataByUserIdTask(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ImportUserDataByUserIdResult parse(JsonNode data) {
            return ImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("uploadToken", ImportUserDataByUserIdTask.this.request.getUploadToken());
                    this.put("contextStack", ImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckImportUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckImportUserDataByUserIdResult> {
        private CheckImportUserDataByUserIdRequest request;

        public CheckImportUserDataByUserIdTask(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckImportUserDataByUserIdResult parse(JsonNode data) {
            return CheckImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/{uploadToken}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{uploadToken}", this.request.getUploadToken() == null || this.request.getUploadToken().length() == 0 ? "null" : String.valueOf(this.request.getUploadToken()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeDataObjectsTask
    extends Gs2RestSessionTask<DescribeDataObjectsResult> {
        private DescribeDataObjectsRequest request;

        public DescribeDataObjectsTask(DescribeDataObjectsRequest request, AsyncAction<AsyncResult<DescribeDataObjectsResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeDataObjectsResult parse(JsonNode data) {
            return DescribeDataObjectsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/data";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getStatus() != null) {
                queryStrings.add("status=" + EncodingUtil.urlEncode(String.valueOf(this.request.getStatus())));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeDataObjectsByUserIdTask
    extends Gs2RestSessionTask<DescribeDataObjectsByUserIdResult> {
        private DescribeDataObjectsByUserIdRequest request;

        public DescribeDataObjectsByUserIdTask(DescribeDataObjectsByUserIdRequest request, AsyncAction<AsyncResult<DescribeDataObjectsByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeDataObjectsByUserIdResult parse(JsonNode data) {
            return DescribeDataObjectsByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/data";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getStatus() != null) {
                queryStrings.add("status=" + EncodingUtil.urlEncode(String.valueOf(this.request.getStatus())));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class PrepareUploadTask
    extends Gs2RestSessionTask<PrepareUploadResult> {
        private PrepareUploadRequest request;

        public PrepareUploadTask(PrepareUploadRequest request, AsyncAction<AsyncResult<PrepareUploadResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareUploadResult parse(JsonNode data) {
            return PrepareUploadResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/data/file";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", PrepareUploadTask.this.request.getName());
                    this.put("contentType", PrepareUploadTask.this.request.getContentType());
                    this.put("scope", PrepareUploadTask.this.request.getScope());
                    this.put("allowUserIds", PrepareUploadTask.this.request.getAllowUserIds() == null ? new ArrayList() : PrepareUploadTask.this.request.getAllowUserIds().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("updateIfExists", PrepareUploadTask.this.request.getUpdateIfExists());
                    this.put("contextStack", PrepareUploadTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareUploadByUserIdTask
    extends Gs2RestSessionTask<PrepareUploadByUserIdResult> {
        private PrepareUploadByUserIdRequest request;

        public PrepareUploadByUserIdTask(PrepareUploadByUserIdRequest request, AsyncAction<AsyncResult<PrepareUploadByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareUploadByUserIdResult parse(JsonNode data) {
            return PrepareUploadByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/data/file";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", PrepareUploadByUserIdTask.this.request.getName());
                    this.put("contentType", PrepareUploadByUserIdTask.this.request.getContentType());
                    this.put("scope", PrepareUploadByUserIdTask.this.request.getScope());
                    this.put("allowUserIds", PrepareUploadByUserIdTask.this.request.getAllowUserIds() == null ? new ArrayList() : PrepareUploadByUserIdTask.this.request.getAllowUserIds().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("updateIfExists", PrepareUploadByUserIdTask.this.request.getUpdateIfExists());
                    this.put("contextStack", PrepareUploadByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class UpdateDataObjectTask
    extends Gs2RestSessionTask<UpdateDataObjectResult> {
        private UpdateDataObjectRequest request;

        public UpdateDataObjectTask(UpdateDataObjectRequest request, AsyncAction<AsyncResult<UpdateDataObjectResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateDataObjectResult parse(JsonNode data) {
            return UpdateDataObjectResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/data/{dataObjectName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("scope", UpdateDataObjectTask.this.request.getScope());
                    this.put("allowUserIds", UpdateDataObjectTask.this.request.getAllowUserIds() == null ? new ArrayList() : UpdateDataObjectTask.this.request.getAllowUserIds().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", UpdateDataObjectTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class UpdateDataObjectByUserIdTask
    extends Gs2RestSessionTask<UpdateDataObjectByUserIdResult> {
        private UpdateDataObjectByUserIdRequest request;

        public UpdateDataObjectByUserIdTask(UpdateDataObjectByUserIdRequest request, AsyncAction<AsyncResult<UpdateDataObjectByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateDataObjectByUserIdResult parse(JsonNode data) {
            return UpdateDataObjectByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/data/{dataObjectName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("scope", UpdateDataObjectByUserIdTask.this.request.getScope());
                    this.put("allowUserIds", UpdateDataObjectByUserIdTask.this.request.getAllowUserIds() == null ? new ArrayList() : UpdateDataObjectByUserIdTask.this.request.getAllowUserIds().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", UpdateDataObjectByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareReUploadTask
    extends Gs2RestSessionTask<PrepareReUploadResult> {
        private PrepareReUploadRequest request;

        public PrepareReUploadTask(PrepareReUploadRequest request, AsyncAction<AsyncResult<PrepareReUploadResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareReUploadResult parse(JsonNode data) {
            return PrepareReUploadResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/data/{dataObjectName}/file/reUpload";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contentType", PrepareReUploadTask.this.request.getContentType());
                    this.put("contextStack", PrepareReUploadTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareReUploadByUserIdTask
    extends Gs2RestSessionTask<PrepareReUploadByUserIdResult> {
        private PrepareReUploadByUserIdRequest request;

        public PrepareReUploadByUserIdTask(PrepareReUploadByUserIdRequest request, AsyncAction<AsyncResult<PrepareReUploadByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareReUploadByUserIdResult parse(JsonNode data) {
            return PrepareReUploadByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/data/{dataObjectName}/file/reUpload";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contentType", PrepareReUploadByUserIdTask.this.request.getContentType());
                    this.put("contextStack", PrepareReUploadByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DoneUploadTask
    extends Gs2RestSessionTask<DoneUploadResult> {
        private DoneUploadRequest request;

        public DoneUploadTask(DoneUploadRequest request, AsyncAction<AsyncResult<DoneUploadResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DoneUploadResult parse(JsonNode data) {
            return DoneUploadResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/data/{dataObjectName}/done";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DoneUploadTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DoneUploadByUserIdTask
    extends Gs2RestSessionTask<DoneUploadByUserIdResult> {
        private DoneUploadByUserIdRequest request;

        public DoneUploadByUserIdTask(DoneUploadByUserIdRequest request, AsyncAction<AsyncResult<DoneUploadByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DoneUploadByUserIdResult parse(JsonNode data) {
            return DoneUploadByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/data/{dataObjectName}/done";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DoneUploadByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteDataObjectTask
    extends Gs2RestSessionTask<DeleteDataObjectResult> {
        private DeleteDataObjectRequest request;

        public DeleteDataObjectTask(DeleteDataObjectRequest request, AsyncAction<AsyncResult<DeleteDataObjectResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteDataObjectResult parse(JsonNode data) {
            return DeleteDataObjectResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/data/{dataObjectName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteDataObjectByUserIdTask
    extends Gs2RestSessionTask<DeleteDataObjectByUserIdResult> {
        private DeleteDataObjectByUserIdRequest request;

        public DeleteDataObjectByUserIdTask(DeleteDataObjectByUserIdRequest request, AsyncAction<AsyncResult<DeleteDataObjectByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteDataObjectByUserIdResult parse(JsonNode data) {
            return DeleteDataObjectByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/data/{dataObjectName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareDownloadTask
    extends Gs2RestSessionTask<PrepareDownloadResult> {
        private PrepareDownloadRequest request;

        public PrepareDownloadTask(PrepareDownloadRequest request, AsyncAction<AsyncResult<PrepareDownloadResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareDownloadResult parse(JsonNode data) {
            return PrepareDownloadResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/file";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("dataObjectId", PrepareDownloadTask.this.request.getDataObjectId());
                    this.put("contextStack", PrepareDownloadTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareDownloadByUserIdTask
    extends Gs2RestSessionTask<PrepareDownloadByUserIdResult> {
        private PrepareDownloadByUserIdRequest request;

        public PrepareDownloadByUserIdTask(PrepareDownloadByUserIdRequest request, AsyncAction<AsyncResult<PrepareDownloadByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareDownloadByUserIdResult parse(JsonNode data) {
            return PrepareDownloadByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/file";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("dataObjectId", PrepareDownloadByUserIdTask.this.request.getDataObjectId());
                    this.put("contextStack", PrepareDownloadByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareDownloadByGenerationTask
    extends Gs2RestSessionTask<PrepareDownloadByGenerationResult> {
        private PrepareDownloadByGenerationRequest request;

        public PrepareDownloadByGenerationTask(PrepareDownloadByGenerationRequest request, AsyncAction<AsyncResult<PrepareDownloadByGenerationResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareDownloadByGenerationResult parse(JsonNode data) {
            return PrepareDownloadByGenerationResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/file/generation/{generation}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{generation}", this.request.getGeneration() == null || this.request.getGeneration().length() == 0 ? "null" : String.valueOf(this.request.getGeneration()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("dataObjectId", PrepareDownloadByGenerationTask.this.request.getDataObjectId());
                    this.put("contextStack", PrepareDownloadByGenerationTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareDownloadByGenerationAndUserIdTask
    extends Gs2RestSessionTask<PrepareDownloadByGenerationAndUserIdResult> {
        private PrepareDownloadByGenerationAndUserIdRequest request;

        public PrepareDownloadByGenerationAndUserIdTask(PrepareDownloadByGenerationAndUserIdRequest request, AsyncAction<AsyncResult<PrepareDownloadByGenerationAndUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareDownloadByGenerationAndUserIdResult parse(JsonNode data) {
            return PrepareDownloadByGenerationAndUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/file/generation/{generation}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{generation}", this.request.getGeneration() == null || this.request.getGeneration().length() == 0 ? "null" : String.valueOf(this.request.getGeneration()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("dataObjectId", PrepareDownloadByGenerationAndUserIdTask.this.request.getDataObjectId());
                    this.put("contextStack", PrepareDownloadByGenerationAndUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareDownloadOwnDataTask
    extends Gs2RestSessionTask<PrepareDownloadOwnDataResult> {
        private PrepareDownloadOwnDataRequest request;

        public PrepareDownloadOwnDataTask(PrepareDownloadOwnDataRequest request, AsyncAction<AsyncResult<PrepareDownloadOwnDataResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareDownloadOwnDataResult parse(JsonNode data) {
            return PrepareDownloadOwnDataResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/data/{dataObjectName}/file";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PrepareDownloadOwnDataTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareDownloadByUserIdAndDataObjectNameTask
    extends Gs2RestSessionTask<PrepareDownloadByUserIdAndDataObjectNameResult> {
        private PrepareDownloadByUserIdAndDataObjectNameRequest request;

        public PrepareDownloadByUserIdAndDataObjectNameTask(PrepareDownloadByUserIdAndDataObjectNameRequest request, AsyncAction<AsyncResult<PrepareDownloadByUserIdAndDataObjectNameResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareDownloadByUserIdAndDataObjectNameResult parse(JsonNode data) {
            return PrepareDownloadByUserIdAndDataObjectNameResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/data/{dataObjectName}/file";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareDownloadOwnDataByGenerationTask
    extends Gs2RestSessionTask<PrepareDownloadOwnDataByGenerationResult> {
        private PrepareDownloadOwnDataByGenerationRequest request;

        public PrepareDownloadOwnDataByGenerationTask(PrepareDownloadOwnDataByGenerationRequest request, AsyncAction<AsyncResult<PrepareDownloadOwnDataByGenerationResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareDownloadOwnDataByGenerationResult parse(JsonNode data) {
            return PrepareDownloadOwnDataByGenerationResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/data/{dataObjectName}/generation/{generation}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            url = url.replace("{generation}", this.request.getGeneration() == null || this.request.getGeneration().length() == 0 ? "null" : String.valueOf(this.request.getGeneration()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PrepareDownloadOwnDataByGenerationTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareDownloadByUserIdAndDataObjectNameAndGenerationTask
    extends Gs2RestSessionTask<PrepareDownloadByUserIdAndDataObjectNameAndGenerationResult> {
        private PrepareDownloadByUserIdAndDataObjectNameAndGenerationRequest request;

        public PrepareDownloadByUserIdAndDataObjectNameAndGenerationTask(PrepareDownloadByUserIdAndDataObjectNameAndGenerationRequest request, AsyncAction<AsyncResult<PrepareDownloadByUserIdAndDataObjectNameAndGenerationResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareDownloadByUserIdAndDataObjectNameAndGenerationResult parse(JsonNode data) {
            return PrepareDownloadByUserIdAndDataObjectNameAndGenerationResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/data/{dataObjectName}/generation/{generation}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            url = url.replace("{generation}", this.request.getGeneration() == null || this.request.getGeneration().length() == 0 ? "null" : String.valueOf(this.request.getGeneration()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PrepareDownloadByUserIdAndDataObjectNameAndGenerationTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class RestoreDataObjectTask
    extends Gs2RestSessionTask<RestoreDataObjectResult> {
        private RestoreDataObjectRequest request;

        public RestoreDataObjectTask(RestoreDataObjectRequest request, AsyncAction<AsyncResult<RestoreDataObjectResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RestoreDataObjectResult parse(JsonNode data) {
            return RestoreDataObjectResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/file/restore";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("dataObjectId", RestoreDataObjectTask.this.request.getDataObjectId());
                    this.put("contextStack", RestoreDataObjectTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeDataObjectHistoriesTask
    extends Gs2RestSessionTask<DescribeDataObjectHistoriesResult> {
        private DescribeDataObjectHistoriesRequest request;

        public DescribeDataObjectHistoriesTask(DescribeDataObjectHistoriesRequest request, AsyncAction<AsyncResult<DescribeDataObjectHistoriesResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeDataObjectHistoriesResult parse(JsonNode data) {
            return DescribeDataObjectHistoriesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/data/{dataObjectName}/history";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeDataObjectHistoriesByUserIdTask
    extends Gs2RestSessionTask<DescribeDataObjectHistoriesByUserIdResult> {
        private DescribeDataObjectHistoriesByUserIdRequest request;

        public DescribeDataObjectHistoriesByUserIdTask(DescribeDataObjectHistoriesByUserIdRequest request, AsyncAction<AsyncResult<DescribeDataObjectHistoriesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeDataObjectHistoriesByUserIdResult parse(JsonNode data) {
            return DescribeDataObjectHistoriesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/data/{dataObjectName}/history";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetDataObjectHistoryTask
    extends Gs2RestSessionTask<GetDataObjectHistoryResult> {
        private GetDataObjectHistoryRequest request;

        public GetDataObjectHistoryTask(GetDataObjectHistoryRequest request, AsyncAction<AsyncResult<GetDataObjectHistoryResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetDataObjectHistoryResult parse(JsonNode data) {
            return GetDataObjectHistoryResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/data/{dataObjectName}/history/{generation}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            url = url.replace("{generation}", this.request.getGeneration() == null || this.request.getGeneration().length() == 0 ? "null" : String.valueOf(this.request.getGeneration()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", GetDataObjectHistoryTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetDataObjectHistoryByUserIdTask
    extends Gs2RestSessionTask<GetDataObjectHistoryByUserIdResult> {
        private GetDataObjectHistoryByUserIdRequest request;

        public GetDataObjectHistoryByUserIdTask(GetDataObjectHistoryByUserIdRequest request, AsyncAction<AsyncResult<GetDataObjectHistoryByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DatastoreRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetDataObjectHistoryByUserIdResult parse(JsonNode data) {
            return GetDataObjectHistoryByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "datastore").replace("{region}", Gs2DatastoreRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/data/{dataObjectName}/history/{generation}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{dataObjectName}", this.request.getDataObjectName() == null || this.request.getDataObjectName().length() == 0 ? "null" : String.valueOf(this.request.getDataObjectName()));
            url = url.replace("{generation}", this.request.getGeneration() == null || this.request.getGeneration().length() == 0 ? "null" : String.valueOf(this.request.getGeneration()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", GetDataObjectHistoryByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

