/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.account.result;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.account.model.Account;
import io.gs2.account.model.BanStatus;
import io.gs2.core.model.IResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AuthenticationResult
implements IResult,
Serializable {
    private Account item;
    private List<BanStatus> banStatuses;
    private String body;
    private String signature;

    public Account getItem() {
        return this.item;
    }

    public void setItem(Account item) {
        this.item = item;
    }

    public AuthenticationResult withItem(Account item) {
        this.item = item;
        return this;
    }

    public List<BanStatus> getBanStatuses() {
        return this.banStatuses;
    }

    public void setBanStatuses(List<BanStatus> banStatuses) {
        this.banStatuses = banStatuses;
    }

    public AuthenticationResult withBanStatuses(List<BanStatus> banStatuses) {
        this.banStatuses = banStatuses;
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public AuthenticationResult withBody(String body) {
        this.body = body;
        return this;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public AuthenticationResult withSignature(String signature) {
        this.signature = signature;
        return this;
    }

    public static AuthenticationResult fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new AuthenticationResult().withItem(data.get("item") == null || data.get("item").isNull() ? null : Account.fromJson(data.get("item"))).withBanStatuses(data.get("banStatuses") == null || data.get("banStatuses").isNull() ? new ArrayList<BanStatus>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("banStatuses").elements(), 256), false).map(item -> BanStatus.fromJson(item)).collect(Collectors.toList())).withBody(data.get("body") == null || data.get("body").isNull() ? null : data.get("body").asText()).withSignature(data.get("signature") == null || data.get("signature").isNull() ? null : data.get("signature").asText());
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("item", AuthenticationResult.this.getItem() != null ? AuthenticationResult.this.getItem().toJson() : null);
                this.put("banStatuses", AuthenticationResult.this.getBanStatuses() == null ? new ArrayList() : AuthenticationResult.this.getBanStatuses().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                this.put("body", AuthenticationResult.this.getBody());
                this.put("signature", AuthenticationResult.this.getSignature());
            }
        });
    }
}

