/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.version;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.version.request.AcceptByUserIdRequest;
import io.gs2.version.request.AcceptRequest;
import io.gs2.version.request.CalculateSignatureRequest;
import io.gs2.version.request.CheckCleanUserDataByUserIdRequest;
import io.gs2.version.request.CheckDumpUserDataByUserIdRequest;
import io.gs2.version.request.CheckImportUserDataByUserIdRequest;
import io.gs2.version.request.CheckVersionByUserIdRequest;
import io.gs2.version.request.CheckVersionRequest;
import io.gs2.version.request.CleanUserDataByUserIdRequest;
import io.gs2.version.request.CreateNamespaceRequest;
import io.gs2.version.request.CreateVersionModelMasterRequest;
import io.gs2.version.request.DeleteAcceptVersionByUserIdRequest;
import io.gs2.version.request.DeleteAcceptVersionRequest;
import io.gs2.version.request.DeleteNamespaceRequest;
import io.gs2.version.request.DeleteVersionModelMasterRequest;
import io.gs2.version.request.DescribeAcceptVersionsByUserIdRequest;
import io.gs2.version.request.DescribeAcceptVersionsRequest;
import io.gs2.version.request.DescribeNamespacesRequest;
import io.gs2.version.request.DescribeVersionModelMastersRequest;
import io.gs2.version.request.DescribeVersionModelsRequest;
import io.gs2.version.request.DumpUserDataByUserIdRequest;
import io.gs2.version.request.ExportMasterRequest;
import io.gs2.version.request.GetAcceptVersionByUserIdRequest;
import io.gs2.version.request.GetAcceptVersionRequest;
import io.gs2.version.request.GetCurrentVersionMasterRequest;
import io.gs2.version.request.GetNamespaceRequest;
import io.gs2.version.request.GetNamespaceStatusRequest;
import io.gs2.version.request.GetVersionModelMasterRequest;
import io.gs2.version.request.GetVersionModelRequest;
import io.gs2.version.request.ImportUserDataByUserIdRequest;
import io.gs2.version.request.PrepareImportUserDataByUserIdRequest;
import io.gs2.version.request.UpdateCurrentVersionMasterFromGitHubRequest;
import io.gs2.version.request.UpdateCurrentVersionMasterRequest;
import io.gs2.version.request.UpdateNamespaceRequest;
import io.gs2.version.request.UpdateVersionModelMasterRequest;
import io.gs2.version.result.AcceptByUserIdResult;
import io.gs2.version.result.AcceptResult;
import io.gs2.version.result.CalculateSignatureResult;
import io.gs2.version.result.CheckCleanUserDataByUserIdResult;
import io.gs2.version.result.CheckDumpUserDataByUserIdResult;
import io.gs2.version.result.CheckImportUserDataByUserIdResult;
import io.gs2.version.result.CheckVersionByUserIdResult;
import io.gs2.version.result.CheckVersionResult;
import io.gs2.version.result.CleanUserDataByUserIdResult;
import io.gs2.version.result.CreateNamespaceResult;
import io.gs2.version.result.CreateVersionModelMasterResult;
import io.gs2.version.result.DeleteAcceptVersionByUserIdResult;
import io.gs2.version.result.DeleteAcceptVersionResult;
import io.gs2.version.result.DeleteNamespaceResult;
import io.gs2.version.result.DeleteVersionModelMasterResult;
import io.gs2.version.result.DescribeAcceptVersionsByUserIdResult;
import io.gs2.version.result.DescribeAcceptVersionsResult;
import io.gs2.version.result.DescribeNamespacesResult;
import io.gs2.version.result.DescribeVersionModelMastersResult;
import io.gs2.version.result.DescribeVersionModelsResult;
import io.gs2.version.result.DumpUserDataByUserIdResult;
import io.gs2.version.result.ExportMasterResult;
import io.gs2.version.result.GetAcceptVersionByUserIdResult;
import io.gs2.version.result.GetAcceptVersionResult;
import io.gs2.version.result.GetCurrentVersionMasterResult;
import io.gs2.version.result.GetNamespaceResult;
import io.gs2.version.result.GetNamespaceStatusResult;
import io.gs2.version.result.GetVersionModelMasterResult;
import io.gs2.version.result.GetVersionModelResult;
import io.gs2.version.result.ImportUserDataByUserIdResult;
import io.gs2.version.result.PrepareImportUserDataByUserIdResult;
import io.gs2.version.result.UpdateCurrentVersionMasterFromGitHubResult;
import io.gs2.version.result.UpdateCurrentVersionMasterResult;
import io.gs2.version.result.UpdateNamespaceResult;
import io.gs2.version.result.UpdateVersionModelMasterResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2VersionRestClient
extends AbstractGs2Client<Gs2VersionRestClient> {
    public Gs2VersionRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void dumpUserDataByUserIdAsync(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> callback) {
        DumpUserDataByUserIdTask task = new DumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DumpUserDataByUserIdResult dumpUserDataByUserId(DumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.dumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkDumpUserDataByUserIdAsync(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> callback) {
        CheckDumpUserDataByUserIdTask task = new CheckDumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckDumpUserDataByUserIdResult checkDumpUserDataByUserId(CheckDumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkDumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckDumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void cleanUserDataByUserIdAsync(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> callback) {
        CleanUserDataByUserIdTask task = new CleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CleanUserDataByUserIdResult cleanUserDataByUserId(CleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.cleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkCleanUserDataByUserIdAsync(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> callback) {
        CheckCleanUserDataByUserIdTask task = new CheckCleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckCleanUserDataByUserIdResult checkCleanUserDataByUserId(CheckCleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkCleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckCleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareImportUserDataByUserIdAsync(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> callback) {
        PrepareImportUserDataByUserIdTask task = new PrepareImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareImportUserDataByUserIdResult prepareImportUserDataByUserId(PrepareImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void importUserDataByUserIdAsync(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> callback) {
        ImportUserDataByUserIdTask task = new ImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ImportUserDataByUserIdResult importUserDataByUserId(ImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.importUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkImportUserDataByUserIdAsync(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> callback) {
        CheckImportUserDataByUserIdTask task = new CheckImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckImportUserDataByUserIdResult checkImportUserDataByUserId(CheckImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeVersionModelMastersAsync(DescribeVersionModelMastersRequest request, AsyncAction<AsyncResult<DescribeVersionModelMastersResult>> callback) {
        DescribeVersionModelMastersTask task = new DescribeVersionModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeVersionModelMastersResult describeVersionModelMasters(DescribeVersionModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeVersionModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeVersionModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createVersionModelMasterAsync(CreateVersionModelMasterRequest request, AsyncAction<AsyncResult<CreateVersionModelMasterResult>> callback) {
        CreateVersionModelMasterTask task = new CreateVersionModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateVersionModelMasterResult createVersionModelMaster(CreateVersionModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createVersionModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateVersionModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getVersionModelMasterAsync(GetVersionModelMasterRequest request, AsyncAction<AsyncResult<GetVersionModelMasterResult>> callback) {
        GetVersionModelMasterTask task = new GetVersionModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetVersionModelMasterResult getVersionModelMaster(GetVersionModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getVersionModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetVersionModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateVersionModelMasterAsync(UpdateVersionModelMasterRequest request, AsyncAction<AsyncResult<UpdateVersionModelMasterResult>> callback) {
        UpdateVersionModelMasterTask task = new UpdateVersionModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateVersionModelMasterResult updateVersionModelMaster(UpdateVersionModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateVersionModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateVersionModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteVersionModelMasterAsync(DeleteVersionModelMasterRequest request, AsyncAction<AsyncResult<DeleteVersionModelMasterResult>> callback) {
        DeleteVersionModelMasterTask task = new DeleteVersionModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteVersionModelMasterResult deleteVersionModelMaster(DeleteVersionModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteVersionModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteVersionModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeVersionModelsAsync(DescribeVersionModelsRequest request, AsyncAction<AsyncResult<DescribeVersionModelsResult>> callback) {
        DescribeVersionModelsTask task = new DescribeVersionModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeVersionModelsResult describeVersionModels(DescribeVersionModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeVersionModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeVersionModelsResult)resultAsyncResult[0].getResult();
    }

    public void getVersionModelAsync(GetVersionModelRequest request, AsyncAction<AsyncResult<GetVersionModelResult>> callback) {
        GetVersionModelTask task = new GetVersionModelTask(request, callback);
        this.session.execute(task);
    }

    public GetVersionModelResult getVersionModel(GetVersionModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getVersionModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetVersionModelResult)resultAsyncResult[0].getResult();
    }

    public void describeAcceptVersionsAsync(DescribeAcceptVersionsRequest request, AsyncAction<AsyncResult<DescribeAcceptVersionsResult>> callback) {
        DescribeAcceptVersionsTask task = new DescribeAcceptVersionsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeAcceptVersionsResult describeAcceptVersions(DescribeAcceptVersionsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeAcceptVersionsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeAcceptVersionsResult)resultAsyncResult[0].getResult();
    }

    public void describeAcceptVersionsByUserIdAsync(DescribeAcceptVersionsByUserIdRequest request, AsyncAction<AsyncResult<DescribeAcceptVersionsByUserIdResult>> callback) {
        DescribeAcceptVersionsByUserIdTask task = new DescribeAcceptVersionsByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeAcceptVersionsByUserIdResult describeAcceptVersionsByUserId(DescribeAcceptVersionsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeAcceptVersionsByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeAcceptVersionsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void acceptAsync(AcceptRequest request, AsyncAction<AsyncResult<AcceptResult>> callback) {
        AcceptTask task = new AcceptTask(request, callback);
        this.session.execute(task);
    }

    public AcceptResult accept(AcceptRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.acceptAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AcceptResult)resultAsyncResult[0].getResult();
    }

    public void acceptByUserIdAsync(AcceptByUserIdRequest request, AsyncAction<AsyncResult<AcceptByUserIdResult>> callback) {
        AcceptByUserIdTask task = new AcceptByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public AcceptByUserIdResult acceptByUserId(AcceptByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.acceptByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AcceptByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getAcceptVersionAsync(GetAcceptVersionRequest request, AsyncAction<AsyncResult<GetAcceptVersionResult>> callback) {
        GetAcceptVersionTask task = new GetAcceptVersionTask(request, callback);
        this.session.execute(task);
    }

    public GetAcceptVersionResult getAcceptVersion(GetAcceptVersionRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getAcceptVersionAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetAcceptVersionResult)resultAsyncResult[0].getResult();
    }

    public void getAcceptVersionByUserIdAsync(GetAcceptVersionByUserIdRequest request, AsyncAction<AsyncResult<GetAcceptVersionByUserIdResult>> callback) {
        GetAcceptVersionByUserIdTask task = new GetAcceptVersionByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetAcceptVersionByUserIdResult getAcceptVersionByUserId(GetAcceptVersionByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getAcceptVersionByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetAcceptVersionByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteAcceptVersionAsync(DeleteAcceptVersionRequest request, AsyncAction<AsyncResult<DeleteAcceptVersionResult>> callback) {
        DeleteAcceptVersionTask task = new DeleteAcceptVersionTask(request, callback);
        this.session.execute(task);
    }

    public DeleteAcceptVersionResult deleteAcceptVersion(DeleteAcceptVersionRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteAcceptVersionAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteAcceptVersionResult)resultAsyncResult[0].getResult();
    }

    public void deleteAcceptVersionByUserIdAsync(DeleteAcceptVersionByUserIdRequest request, AsyncAction<AsyncResult<DeleteAcceptVersionByUserIdResult>> callback) {
        DeleteAcceptVersionByUserIdTask task = new DeleteAcceptVersionByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteAcceptVersionByUserIdResult deleteAcceptVersionByUserId(DeleteAcceptVersionByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteAcceptVersionByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteAcceptVersionByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkVersionAsync(CheckVersionRequest request, AsyncAction<AsyncResult<CheckVersionResult>> callback) {
        CheckVersionTask task = new CheckVersionTask(request, callback);
        this.session.execute(task);
    }

    public CheckVersionResult checkVersion(CheckVersionRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkVersionAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckVersionResult)resultAsyncResult[0].getResult();
    }

    public void checkVersionByUserIdAsync(CheckVersionByUserIdRequest request, AsyncAction<AsyncResult<CheckVersionByUserIdResult>> callback) {
        CheckVersionByUserIdTask task = new CheckVersionByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckVersionByUserIdResult checkVersionByUserId(CheckVersionByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkVersionByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckVersionByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void calculateSignatureAsync(CalculateSignatureRequest request, AsyncAction<AsyncResult<CalculateSignatureResult>> callback) {
        CalculateSignatureTask task = new CalculateSignatureTask(request, callback);
        this.session.execute(task);
    }

    public CalculateSignatureResult calculateSignature(CalculateSignatureRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.calculateSignatureAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CalculateSignatureResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentVersionMasterAsync(GetCurrentVersionMasterRequest request, AsyncAction<AsyncResult<GetCurrentVersionMasterResult>> callback) {
        GetCurrentVersionMasterTask task = new GetCurrentVersionMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentVersionMasterResult getCurrentVersionMaster(GetCurrentVersionMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentVersionMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentVersionMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentVersionMasterAsync(UpdateCurrentVersionMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentVersionMasterResult>> callback) {
        UpdateCurrentVersionMasterTask task = new UpdateCurrentVersionMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentVersionMasterResult updateCurrentVersionMaster(UpdateCurrentVersionMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentVersionMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentVersionMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentVersionMasterFromGitHubAsync(UpdateCurrentVersionMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentVersionMasterFromGitHubResult>> callback) {
        UpdateCurrentVersionMasterFromGitHubTask task = new UpdateCurrentVersionMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentVersionMasterFromGitHubResult updateCurrentVersionMasterFromGitHub(UpdateCurrentVersionMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentVersionMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentVersionMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("assumeUserId", CreateNamespaceTask.this.request.getAssumeUserId());
                    this.put("acceptVersionScript", CreateNamespaceTask.this.request.getAcceptVersionScript() != null ? CreateNamespaceTask.this.request.getAcceptVersionScript().toJson() : null);
                    this.put("checkVersionTriggerScriptId", CreateNamespaceTask.this.request.getCheckVersionTriggerScriptId());
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("assumeUserId", UpdateNamespaceTask.this.request.getAssumeUserId());
                    this.put("acceptVersionScript", UpdateNamespaceTask.this.request.getAcceptVersionScript() != null ? UpdateNamespaceTask.this.request.getAcceptVersionScript().toJson() : null);
                    this.put("checkVersionTriggerScriptId", UpdateNamespaceTask.this.request.getCheckVersionTriggerScriptId());
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DumpUserDataByUserIdTask
    extends Gs2RestSessionTask<DumpUserDataByUserIdResult> {
        private DumpUserDataByUserIdRequest request;

        public DumpUserDataByUserIdTask(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DumpUserDataByUserIdResult parse(JsonNode data) {
            return DumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DumpUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckDumpUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckDumpUserDataByUserIdResult> {
        private CheckDumpUserDataByUserIdRequest request;

        public CheckDumpUserDataByUserIdTask(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckDumpUserDataByUserIdResult parse(JsonNode data) {
            return CheckDumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CleanUserDataByUserIdResult> {
        private CleanUserDataByUserIdRequest request;

        public CleanUserDataByUserIdTask(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CleanUserDataByUserIdResult parse(JsonNode data) {
            return CleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CleanUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckCleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckCleanUserDataByUserIdResult> {
        private CheckCleanUserDataByUserIdRequest request;

        public CheckCleanUserDataByUserIdTask(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckCleanUserDataByUserIdResult parse(JsonNode data) {
            return CheckCleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareImportUserDataByUserIdTask
    extends Gs2RestSessionTask<PrepareImportUserDataByUserIdResult> {
        private PrepareImportUserDataByUserIdRequest request;

        public PrepareImportUserDataByUserIdTask(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareImportUserDataByUserIdResult parse(JsonNode data) {
            return PrepareImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/prepare";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PrepareImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ImportUserDataByUserIdTask
    extends Gs2RestSessionTask<ImportUserDataByUserIdResult> {
        private ImportUserDataByUserIdRequest request;

        public ImportUserDataByUserIdTask(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ImportUserDataByUserIdResult parse(JsonNode data) {
            return ImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("uploadToken", ImportUserDataByUserIdTask.this.request.getUploadToken());
                    this.put("contextStack", ImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckImportUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckImportUserDataByUserIdResult> {
        private CheckImportUserDataByUserIdRequest request;

        public CheckImportUserDataByUserIdTask(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckImportUserDataByUserIdResult parse(JsonNode data) {
            return CheckImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/{uploadToken}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{uploadToken}", this.request.getUploadToken() == null || this.request.getUploadToken().length() == 0 ? "null" : String.valueOf(this.request.getUploadToken()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeVersionModelMastersTask
    extends Gs2RestSessionTask<DescribeVersionModelMastersResult> {
        private DescribeVersionModelMastersRequest request;

        public DescribeVersionModelMastersTask(DescribeVersionModelMastersRequest request, AsyncAction<AsyncResult<DescribeVersionModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeVersionModelMastersResult parse(JsonNode data) {
            return DescribeVersionModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/version";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateVersionModelMasterTask
    extends Gs2RestSessionTask<CreateVersionModelMasterResult> {
        private CreateVersionModelMasterRequest request;

        public CreateVersionModelMasterTask(CreateVersionModelMasterRequest request, AsyncAction<AsyncResult<CreateVersionModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateVersionModelMasterResult parse(JsonNode data) {
            return CreateVersionModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/version";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateVersionModelMasterTask.this.request.getName());
                    this.put("description", CreateVersionModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateVersionModelMasterTask.this.request.getMetadata());
                    this.put("scope", CreateVersionModelMasterTask.this.request.getScope());
                    this.put("type", CreateVersionModelMasterTask.this.request.getType());
                    this.put("currentVersion", CreateVersionModelMasterTask.this.request.getCurrentVersion() != null ? CreateVersionModelMasterTask.this.request.getCurrentVersion().toJson() : null);
                    this.put("warningVersion", CreateVersionModelMasterTask.this.request.getWarningVersion() != null ? CreateVersionModelMasterTask.this.request.getWarningVersion().toJson() : null);
                    this.put("errorVersion", CreateVersionModelMasterTask.this.request.getErrorVersion() != null ? CreateVersionModelMasterTask.this.request.getErrorVersion().toJson() : null);
                    this.put("scheduleVersions", CreateVersionModelMasterTask.this.request.getScheduleVersions() == null ? new ArrayList() : CreateVersionModelMasterTask.this.request.getScheduleVersions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("needSignature", CreateVersionModelMasterTask.this.request.getNeedSignature());
                    this.put("signatureKeyId", CreateVersionModelMasterTask.this.request.getSignatureKeyId());
                    this.put("contextStack", CreateVersionModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetVersionModelMasterTask
    extends Gs2RestSessionTask<GetVersionModelMasterResult> {
        private GetVersionModelMasterRequest request;

        public GetVersionModelMasterTask(GetVersionModelMasterRequest request, AsyncAction<AsyncResult<GetVersionModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetVersionModelMasterResult parse(JsonNode data) {
            return GetVersionModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/version/{versionName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{versionName}", this.request.getVersionName() == null || this.request.getVersionName().length() == 0 ? "null" : String.valueOf(this.request.getVersionName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateVersionModelMasterTask
    extends Gs2RestSessionTask<UpdateVersionModelMasterResult> {
        private UpdateVersionModelMasterRequest request;

        public UpdateVersionModelMasterTask(UpdateVersionModelMasterRequest request, AsyncAction<AsyncResult<UpdateVersionModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateVersionModelMasterResult parse(JsonNode data) {
            return UpdateVersionModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/version/{versionName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{versionName}", this.request.getVersionName() == null || this.request.getVersionName().length() == 0 ? "null" : String.valueOf(this.request.getVersionName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateVersionModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateVersionModelMasterTask.this.request.getMetadata());
                    this.put("scope", UpdateVersionModelMasterTask.this.request.getScope());
                    this.put("type", UpdateVersionModelMasterTask.this.request.getType());
                    this.put("currentVersion", UpdateVersionModelMasterTask.this.request.getCurrentVersion() != null ? UpdateVersionModelMasterTask.this.request.getCurrentVersion().toJson() : null);
                    this.put("warningVersion", UpdateVersionModelMasterTask.this.request.getWarningVersion() != null ? UpdateVersionModelMasterTask.this.request.getWarningVersion().toJson() : null);
                    this.put("errorVersion", UpdateVersionModelMasterTask.this.request.getErrorVersion() != null ? UpdateVersionModelMasterTask.this.request.getErrorVersion().toJson() : null);
                    this.put("scheduleVersions", UpdateVersionModelMasterTask.this.request.getScheduleVersions() == null ? new ArrayList() : UpdateVersionModelMasterTask.this.request.getScheduleVersions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("needSignature", UpdateVersionModelMasterTask.this.request.getNeedSignature());
                    this.put("signatureKeyId", UpdateVersionModelMasterTask.this.request.getSignatureKeyId());
                    this.put("contextStack", UpdateVersionModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteVersionModelMasterTask
    extends Gs2RestSessionTask<DeleteVersionModelMasterResult> {
        private DeleteVersionModelMasterRequest request;

        public DeleteVersionModelMasterTask(DeleteVersionModelMasterRequest request, AsyncAction<AsyncResult<DeleteVersionModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteVersionModelMasterResult parse(JsonNode data) {
            return DeleteVersionModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/version/{versionName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{versionName}", this.request.getVersionName() == null || this.request.getVersionName().length() == 0 ? "null" : String.valueOf(this.request.getVersionName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeVersionModelsTask
    extends Gs2RestSessionTask<DescribeVersionModelsResult> {
        private DescribeVersionModelsRequest request;

        public DescribeVersionModelsTask(DescribeVersionModelsRequest request, AsyncAction<AsyncResult<DescribeVersionModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeVersionModelsResult parse(JsonNode data) {
            return DescribeVersionModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/version";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetVersionModelTask
    extends Gs2RestSessionTask<GetVersionModelResult> {
        private GetVersionModelRequest request;

        public GetVersionModelTask(GetVersionModelRequest request, AsyncAction<AsyncResult<GetVersionModelResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetVersionModelResult parse(JsonNode data) {
            return GetVersionModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/version/{versionName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{versionName}", this.request.getVersionName() == null || this.request.getVersionName().length() == 0 ? "null" : String.valueOf(this.request.getVersionName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeAcceptVersionsTask
    extends Gs2RestSessionTask<DescribeAcceptVersionsResult> {
        private DescribeAcceptVersionsRequest request;

        public DescribeAcceptVersionsTask(DescribeAcceptVersionsRequest request, AsyncAction<AsyncResult<DescribeAcceptVersionsResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeAcceptVersionsResult parse(JsonNode data) {
            return DescribeAcceptVersionsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/acceptVersion";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeAcceptVersionsByUserIdTask
    extends Gs2RestSessionTask<DescribeAcceptVersionsByUserIdResult> {
        private DescribeAcceptVersionsByUserIdRequest request;

        public DescribeAcceptVersionsByUserIdTask(DescribeAcceptVersionsByUserIdRequest request, AsyncAction<AsyncResult<DescribeAcceptVersionsByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeAcceptVersionsByUserIdResult parse(JsonNode data) {
            return DescribeAcceptVersionsByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/acceptVersion";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getUserId())));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class AcceptTask
    extends Gs2RestSessionTask<AcceptResult> {
        private AcceptRequest request;

        public AcceptTask(AcceptRequest request, AsyncAction<AsyncResult<AcceptResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AcceptResult parse(JsonNode data) {
            return AcceptResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/acceptVersion";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("versionName", AcceptTask.this.request.getVersionName());
                    this.put("contextStack", AcceptTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class AcceptByUserIdTask
    extends Gs2RestSessionTask<AcceptByUserIdResult> {
        private AcceptByUserIdRequest request;

        public AcceptByUserIdTask(AcceptByUserIdRequest request, AsyncAction<AsyncResult<AcceptByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AcceptByUserIdResult parse(JsonNode data) {
            return AcceptByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/acceptVersion";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("versionName", AcceptByUserIdTask.this.request.getVersionName());
                    this.put("contextStack", AcceptByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class GetAcceptVersionTask
    extends Gs2RestSessionTask<GetAcceptVersionResult> {
        private GetAcceptVersionRequest request;

        public GetAcceptVersionTask(GetAcceptVersionRequest request, AsyncAction<AsyncResult<GetAcceptVersionResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetAcceptVersionResult parse(JsonNode data) {
            return GetAcceptVersionResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/{versionName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{versionName}", this.request.getVersionName() == null || this.request.getVersionName().length() == 0 ? "null" : String.valueOf(this.request.getVersionName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetAcceptVersionByUserIdTask
    extends Gs2RestSessionTask<GetAcceptVersionByUserIdResult> {
        private GetAcceptVersionByUserIdRequest request;

        public GetAcceptVersionByUserIdTask(GetAcceptVersionByUserIdRequest request, AsyncAction<AsyncResult<GetAcceptVersionByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetAcceptVersionByUserIdResult parse(JsonNode data) {
            return GetAcceptVersionByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/{versionName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{versionName}", this.request.getVersionName() == null || this.request.getVersionName().length() == 0 ? "null" : String.valueOf(this.request.getVersionName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteAcceptVersionTask
    extends Gs2RestSessionTask<DeleteAcceptVersionResult> {
        private DeleteAcceptVersionRequest request;

        public DeleteAcceptVersionTask(DeleteAcceptVersionRequest request, AsyncAction<AsyncResult<DeleteAcceptVersionResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteAcceptVersionResult parse(JsonNode data) {
            return DeleteAcceptVersionResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/{versionName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{versionName}", this.request.getVersionName() == null || this.request.getVersionName().length() == 0 ? "null" : String.valueOf(this.request.getVersionName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteAcceptVersionByUserIdTask
    extends Gs2RestSessionTask<DeleteAcceptVersionByUserIdResult> {
        private DeleteAcceptVersionByUserIdRequest request;

        public DeleteAcceptVersionByUserIdTask(DeleteAcceptVersionByUserIdRequest request, AsyncAction<AsyncResult<DeleteAcceptVersionByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteAcceptVersionByUserIdResult parse(JsonNode data) {
            return DeleteAcceptVersionByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/{versionName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{versionName}", this.request.getVersionName() == null || this.request.getVersionName().length() == 0 ? "null" : String.valueOf(this.request.getVersionName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckVersionTask
    extends Gs2RestSessionTask<CheckVersionResult> {
        private CheckVersionRequest request;

        public CheckVersionTask(CheckVersionRequest request, AsyncAction<AsyncResult<CheckVersionResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckVersionResult parse(JsonNode data) {
            return CheckVersionResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/check";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("targetVersions", CheckVersionTask.this.request.getTargetVersions() == null ? new ArrayList() : CheckVersionTask.this.request.getTargetVersions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", CheckVersionTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckVersionByUserIdTask
    extends Gs2RestSessionTask<CheckVersionByUserIdResult> {
        private CheckVersionByUserIdRequest request;

        public CheckVersionByUserIdTask(CheckVersionByUserIdRequest request, AsyncAction<AsyncResult<CheckVersionByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckVersionByUserIdResult parse(JsonNode data) {
            return CheckVersionByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/check";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("targetVersions", CheckVersionByUserIdTask.this.request.getTargetVersions() == null ? new ArrayList() : CheckVersionByUserIdTask.this.request.getTargetVersions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", CheckVersionByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CalculateSignatureTask
    extends Gs2RestSessionTask<CalculateSignatureResult> {
        private CalculateSignatureRequest request;

        public CalculateSignatureTask(CalculateSignatureRequest request, AsyncAction<AsyncResult<CalculateSignatureResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CalculateSignatureResult parse(JsonNode data) {
            return CalculateSignatureResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/version/{versionName}/calculate/signature";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{versionName}", this.request.getVersionName() == null || this.request.getVersionName().length() == 0 ? "null" : String.valueOf(this.request.getVersionName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("version", CalculateSignatureTask.this.request.getVersion() != null ? CalculateSignatureTask.this.request.getVersion().toJson() : null);
                    this.put("contextStack", CalculateSignatureTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentVersionMasterTask
    extends Gs2RestSessionTask<GetCurrentVersionMasterResult> {
        private GetCurrentVersionMasterRequest request;

        public GetCurrentVersionMasterTask(GetCurrentVersionMasterRequest request, AsyncAction<AsyncResult<GetCurrentVersionMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentVersionMasterResult parse(JsonNode data) {
            return GetCurrentVersionMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentVersionMasterTask
    extends Gs2RestSessionTask<UpdateCurrentVersionMasterResult> {
        private UpdateCurrentVersionMasterRequest request;

        public UpdateCurrentVersionMasterTask(UpdateCurrentVersionMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentVersionMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentVersionMasterResult parse(JsonNode data) {
            return UpdateCurrentVersionMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentVersionMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentVersionMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentVersionMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentVersionMasterFromGitHubResult> {
        private UpdateCurrentVersionMasterFromGitHubRequest request;

        public UpdateCurrentVersionMasterFromGitHubTask(UpdateCurrentVersionMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentVersionMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2VersionRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentVersionMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentVersionMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "version").replace("{region}", Gs2VersionRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentVersionMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentVersionMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentVersionMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

