/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inbox;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.inbox.request.CheckCleanUserDataByUserIdRequest;
import io.gs2.inbox.request.CheckDumpUserDataByUserIdRequest;
import io.gs2.inbox.request.CheckImportUserDataByUserIdRequest;
import io.gs2.inbox.request.CleanUserDataByUserIdRequest;
import io.gs2.inbox.request.CreateGlobalMessageMasterRequest;
import io.gs2.inbox.request.CreateNamespaceRequest;
import io.gs2.inbox.request.DeleteGlobalMessageMasterRequest;
import io.gs2.inbox.request.DeleteMessageByStampTaskRequest;
import io.gs2.inbox.request.DeleteMessageByUserIdRequest;
import io.gs2.inbox.request.DeleteMessageRequest;
import io.gs2.inbox.request.DeleteNamespaceRequest;
import io.gs2.inbox.request.DeleteReceivedByUserIdRequest;
import io.gs2.inbox.request.DescribeGlobalMessageMastersRequest;
import io.gs2.inbox.request.DescribeGlobalMessagesRequest;
import io.gs2.inbox.request.DescribeMessagesByUserIdRequest;
import io.gs2.inbox.request.DescribeMessagesRequest;
import io.gs2.inbox.request.DescribeNamespacesRequest;
import io.gs2.inbox.request.DumpUserDataByUserIdRequest;
import io.gs2.inbox.request.ExportMasterRequest;
import io.gs2.inbox.request.GetCurrentMessageMasterRequest;
import io.gs2.inbox.request.GetGlobalMessageMasterRequest;
import io.gs2.inbox.request.GetGlobalMessageRequest;
import io.gs2.inbox.request.GetMessageByUserIdRequest;
import io.gs2.inbox.request.GetMessageRequest;
import io.gs2.inbox.request.GetNamespaceRequest;
import io.gs2.inbox.request.GetNamespaceStatusRequest;
import io.gs2.inbox.request.GetReceivedByUserIdRequest;
import io.gs2.inbox.request.ImportUserDataByUserIdRequest;
import io.gs2.inbox.request.OpenByStampTaskRequest;
import io.gs2.inbox.request.OpenMessageByUserIdRequest;
import io.gs2.inbox.request.OpenMessageRequest;
import io.gs2.inbox.request.PrepareImportUserDataByUserIdRequest;
import io.gs2.inbox.request.ReadMessageByUserIdRequest;
import io.gs2.inbox.request.ReadMessageRequest;
import io.gs2.inbox.request.ReceiveGlobalMessageByUserIdRequest;
import io.gs2.inbox.request.ReceiveGlobalMessageRequest;
import io.gs2.inbox.request.SendByStampSheetRequest;
import io.gs2.inbox.request.SendMessageByUserIdRequest;
import io.gs2.inbox.request.UpdateCurrentMessageMasterFromGitHubRequest;
import io.gs2.inbox.request.UpdateCurrentMessageMasterRequest;
import io.gs2.inbox.request.UpdateGlobalMessageMasterRequest;
import io.gs2.inbox.request.UpdateNamespaceRequest;
import io.gs2.inbox.request.UpdateReceivedByUserIdRequest;
import io.gs2.inbox.result.CheckCleanUserDataByUserIdResult;
import io.gs2.inbox.result.CheckDumpUserDataByUserIdResult;
import io.gs2.inbox.result.CheckImportUserDataByUserIdResult;
import io.gs2.inbox.result.CleanUserDataByUserIdResult;
import io.gs2.inbox.result.CreateGlobalMessageMasterResult;
import io.gs2.inbox.result.CreateNamespaceResult;
import io.gs2.inbox.result.DeleteGlobalMessageMasterResult;
import io.gs2.inbox.result.DeleteMessageByStampTaskResult;
import io.gs2.inbox.result.DeleteMessageByUserIdResult;
import io.gs2.inbox.result.DeleteMessageResult;
import io.gs2.inbox.result.DeleteNamespaceResult;
import io.gs2.inbox.result.DeleteReceivedByUserIdResult;
import io.gs2.inbox.result.DescribeGlobalMessageMastersResult;
import io.gs2.inbox.result.DescribeGlobalMessagesResult;
import io.gs2.inbox.result.DescribeMessagesByUserIdResult;
import io.gs2.inbox.result.DescribeMessagesResult;
import io.gs2.inbox.result.DescribeNamespacesResult;
import io.gs2.inbox.result.DumpUserDataByUserIdResult;
import io.gs2.inbox.result.ExportMasterResult;
import io.gs2.inbox.result.GetCurrentMessageMasterResult;
import io.gs2.inbox.result.GetGlobalMessageMasterResult;
import io.gs2.inbox.result.GetGlobalMessageResult;
import io.gs2.inbox.result.GetMessageByUserIdResult;
import io.gs2.inbox.result.GetMessageResult;
import io.gs2.inbox.result.GetNamespaceResult;
import io.gs2.inbox.result.GetNamespaceStatusResult;
import io.gs2.inbox.result.GetReceivedByUserIdResult;
import io.gs2.inbox.result.ImportUserDataByUserIdResult;
import io.gs2.inbox.result.OpenByStampTaskResult;
import io.gs2.inbox.result.OpenMessageByUserIdResult;
import io.gs2.inbox.result.OpenMessageResult;
import io.gs2.inbox.result.PrepareImportUserDataByUserIdResult;
import io.gs2.inbox.result.ReadMessageByUserIdResult;
import io.gs2.inbox.result.ReadMessageResult;
import io.gs2.inbox.result.ReceiveGlobalMessageByUserIdResult;
import io.gs2.inbox.result.ReceiveGlobalMessageResult;
import io.gs2.inbox.result.SendByStampSheetResult;
import io.gs2.inbox.result.SendMessageByUserIdResult;
import io.gs2.inbox.result.UpdateCurrentMessageMasterFromGitHubResult;
import io.gs2.inbox.result.UpdateCurrentMessageMasterResult;
import io.gs2.inbox.result.UpdateGlobalMessageMasterResult;
import io.gs2.inbox.result.UpdateNamespaceResult;
import io.gs2.inbox.result.UpdateReceivedByUserIdResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2InboxRestClient
extends AbstractGs2Client<Gs2InboxRestClient> {
    public Gs2InboxRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void dumpUserDataByUserIdAsync(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> callback) {
        DumpUserDataByUserIdTask task = new DumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DumpUserDataByUserIdResult dumpUserDataByUserId(DumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.dumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkDumpUserDataByUserIdAsync(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> callback) {
        CheckDumpUserDataByUserIdTask task = new CheckDumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckDumpUserDataByUserIdResult checkDumpUserDataByUserId(CheckDumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkDumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckDumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void cleanUserDataByUserIdAsync(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> callback) {
        CleanUserDataByUserIdTask task = new CleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CleanUserDataByUserIdResult cleanUserDataByUserId(CleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.cleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkCleanUserDataByUserIdAsync(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> callback) {
        CheckCleanUserDataByUserIdTask task = new CheckCleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckCleanUserDataByUserIdResult checkCleanUserDataByUserId(CheckCleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkCleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckCleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareImportUserDataByUserIdAsync(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> callback) {
        PrepareImportUserDataByUserIdTask task = new PrepareImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareImportUserDataByUserIdResult prepareImportUserDataByUserId(PrepareImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void importUserDataByUserIdAsync(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> callback) {
        ImportUserDataByUserIdTask task = new ImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ImportUserDataByUserIdResult importUserDataByUserId(ImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.importUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkImportUserDataByUserIdAsync(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> callback) {
        CheckImportUserDataByUserIdTask task = new CheckImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckImportUserDataByUserIdResult checkImportUserDataByUserId(CheckImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeMessagesAsync(DescribeMessagesRequest request, AsyncAction<AsyncResult<DescribeMessagesResult>> callback) {
        DescribeMessagesTask task = new DescribeMessagesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeMessagesResult describeMessages(DescribeMessagesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeMessagesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeMessagesResult)resultAsyncResult[0].getResult();
    }

    public void describeMessagesByUserIdAsync(DescribeMessagesByUserIdRequest request, AsyncAction<AsyncResult<DescribeMessagesByUserIdResult>> callback) {
        DescribeMessagesByUserIdTask task = new DescribeMessagesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeMessagesByUserIdResult describeMessagesByUserId(DescribeMessagesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeMessagesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeMessagesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void sendMessageByUserIdAsync(SendMessageByUserIdRequest request, AsyncAction<AsyncResult<SendMessageByUserIdResult>> callback) {
        SendMessageByUserIdTask task = new SendMessageByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public SendMessageByUserIdResult sendMessageByUserId(SendMessageByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.sendMessageByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SendMessageByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getMessageAsync(GetMessageRequest request, AsyncAction<AsyncResult<GetMessageResult>> callback) {
        GetMessageTask task = new GetMessageTask(request, callback);
        this.session.execute(task);
    }

    public GetMessageResult getMessage(GetMessageRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getMessageAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetMessageResult)resultAsyncResult[0].getResult();
    }

    public void getMessageByUserIdAsync(GetMessageByUserIdRequest request, AsyncAction<AsyncResult<GetMessageByUserIdResult>> callback) {
        GetMessageByUserIdTask task = new GetMessageByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetMessageByUserIdResult getMessageByUserId(GetMessageByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getMessageByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetMessageByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void receiveGlobalMessageAsync(ReceiveGlobalMessageRequest request, AsyncAction<AsyncResult<ReceiveGlobalMessageResult>> callback) {
        ReceiveGlobalMessageTask task = new ReceiveGlobalMessageTask(request, callback);
        this.session.execute(task);
    }

    public ReceiveGlobalMessageResult receiveGlobalMessage(ReceiveGlobalMessageRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.receiveGlobalMessageAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ReceiveGlobalMessageResult)resultAsyncResult[0].getResult();
    }

    public void receiveGlobalMessageByUserIdAsync(ReceiveGlobalMessageByUserIdRequest request, AsyncAction<AsyncResult<ReceiveGlobalMessageByUserIdResult>> callback) {
        ReceiveGlobalMessageByUserIdTask task = new ReceiveGlobalMessageByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ReceiveGlobalMessageByUserIdResult receiveGlobalMessageByUserId(ReceiveGlobalMessageByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.receiveGlobalMessageByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ReceiveGlobalMessageByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void openMessageAsync(OpenMessageRequest request, AsyncAction<AsyncResult<OpenMessageResult>> callback) {
        OpenMessageTask task = new OpenMessageTask(request, callback);
        this.session.execute(task);
    }

    public OpenMessageResult openMessage(OpenMessageRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.openMessageAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (OpenMessageResult)resultAsyncResult[0].getResult();
    }

    public void openMessageByUserIdAsync(OpenMessageByUserIdRequest request, AsyncAction<AsyncResult<OpenMessageByUserIdResult>> callback) {
        OpenMessageByUserIdTask task = new OpenMessageByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public OpenMessageByUserIdResult openMessageByUserId(OpenMessageByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.openMessageByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (OpenMessageByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void readMessageAsync(ReadMessageRequest request, AsyncAction<AsyncResult<ReadMessageResult>> callback) {
        ReadMessageTask task = new ReadMessageTask(request, callback);
        this.session.execute(task);
    }

    public ReadMessageResult readMessage(ReadMessageRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.readMessageAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ReadMessageResult)resultAsyncResult[0].getResult();
    }

    public void readMessageByUserIdAsync(ReadMessageByUserIdRequest request, AsyncAction<AsyncResult<ReadMessageByUserIdResult>> callback) {
        ReadMessageByUserIdTask task = new ReadMessageByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ReadMessageByUserIdResult readMessageByUserId(ReadMessageByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.readMessageByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ReadMessageByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteMessageAsync(DeleteMessageRequest request, AsyncAction<AsyncResult<DeleteMessageResult>> callback) {
        DeleteMessageTask task = new DeleteMessageTask(request, callback);
        this.session.execute(task);
    }

    public DeleteMessageResult deleteMessage(DeleteMessageRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteMessageAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteMessageResult)resultAsyncResult[0].getResult();
    }

    public void deleteMessageByUserIdAsync(DeleteMessageByUserIdRequest request, AsyncAction<AsyncResult<DeleteMessageByUserIdResult>> callback) {
        DeleteMessageByUserIdTask task = new DeleteMessageByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteMessageByUserIdResult deleteMessageByUserId(DeleteMessageByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteMessageByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteMessageByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void sendByStampSheetAsync(SendByStampSheetRequest request, AsyncAction<AsyncResult<SendByStampSheetResult>> callback) {
        SendByStampSheetTask task = new SendByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public SendByStampSheetResult sendByStampSheet(SendByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.sendByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (SendByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void openByStampTaskAsync(OpenByStampTaskRequest request, AsyncAction<AsyncResult<OpenByStampTaskResult>> callback) {
        OpenByStampTaskTask task = new OpenByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public OpenByStampTaskResult openByStampTask(OpenByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.openByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (OpenByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void deleteMessageByStampTaskAsync(DeleteMessageByStampTaskRequest request, AsyncAction<AsyncResult<DeleteMessageByStampTaskResult>> callback) {
        DeleteMessageByStampTaskTask task = new DeleteMessageByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public DeleteMessageByStampTaskResult deleteMessageByStampTask(DeleteMessageByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteMessageByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteMessageByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentMessageMasterAsync(GetCurrentMessageMasterRequest request, AsyncAction<AsyncResult<GetCurrentMessageMasterResult>> callback) {
        GetCurrentMessageMasterTask task = new GetCurrentMessageMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentMessageMasterResult getCurrentMessageMaster(GetCurrentMessageMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentMessageMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentMessageMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentMessageMasterAsync(UpdateCurrentMessageMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentMessageMasterResult>> callback) {
        UpdateCurrentMessageMasterTask task = new UpdateCurrentMessageMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentMessageMasterResult updateCurrentMessageMaster(UpdateCurrentMessageMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentMessageMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentMessageMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentMessageMasterFromGitHubAsync(UpdateCurrentMessageMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentMessageMasterFromGitHubResult>> callback) {
        UpdateCurrentMessageMasterFromGitHubTask task = new UpdateCurrentMessageMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentMessageMasterFromGitHubResult updateCurrentMessageMasterFromGitHub(UpdateCurrentMessageMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentMessageMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentMessageMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    public void describeGlobalMessageMastersAsync(DescribeGlobalMessageMastersRequest request, AsyncAction<AsyncResult<DescribeGlobalMessageMastersResult>> callback) {
        DescribeGlobalMessageMastersTask task = new DescribeGlobalMessageMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeGlobalMessageMastersResult describeGlobalMessageMasters(DescribeGlobalMessageMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeGlobalMessageMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeGlobalMessageMastersResult)resultAsyncResult[0].getResult();
    }

    public void createGlobalMessageMasterAsync(CreateGlobalMessageMasterRequest request, AsyncAction<AsyncResult<CreateGlobalMessageMasterResult>> callback) {
        CreateGlobalMessageMasterTask task = new CreateGlobalMessageMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateGlobalMessageMasterResult createGlobalMessageMaster(CreateGlobalMessageMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createGlobalMessageMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateGlobalMessageMasterResult)resultAsyncResult[0].getResult();
    }

    public void getGlobalMessageMasterAsync(GetGlobalMessageMasterRequest request, AsyncAction<AsyncResult<GetGlobalMessageMasterResult>> callback) {
        GetGlobalMessageMasterTask task = new GetGlobalMessageMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetGlobalMessageMasterResult getGlobalMessageMaster(GetGlobalMessageMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getGlobalMessageMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetGlobalMessageMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateGlobalMessageMasterAsync(UpdateGlobalMessageMasterRequest request, AsyncAction<AsyncResult<UpdateGlobalMessageMasterResult>> callback) {
        UpdateGlobalMessageMasterTask task = new UpdateGlobalMessageMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateGlobalMessageMasterResult updateGlobalMessageMaster(UpdateGlobalMessageMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateGlobalMessageMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateGlobalMessageMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteGlobalMessageMasterAsync(DeleteGlobalMessageMasterRequest request, AsyncAction<AsyncResult<DeleteGlobalMessageMasterResult>> callback) {
        DeleteGlobalMessageMasterTask task = new DeleteGlobalMessageMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteGlobalMessageMasterResult deleteGlobalMessageMaster(DeleteGlobalMessageMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteGlobalMessageMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteGlobalMessageMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeGlobalMessagesAsync(DescribeGlobalMessagesRequest request, AsyncAction<AsyncResult<DescribeGlobalMessagesResult>> callback) {
        DescribeGlobalMessagesTask task = new DescribeGlobalMessagesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeGlobalMessagesResult describeGlobalMessages(DescribeGlobalMessagesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeGlobalMessagesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeGlobalMessagesResult)resultAsyncResult[0].getResult();
    }

    public void getGlobalMessageAsync(GetGlobalMessageRequest request, AsyncAction<AsyncResult<GetGlobalMessageResult>> callback) {
        GetGlobalMessageTask task = new GetGlobalMessageTask(request, callback);
        this.session.execute(task);
    }

    public GetGlobalMessageResult getGlobalMessage(GetGlobalMessageRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getGlobalMessageAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetGlobalMessageResult)resultAsyncResult[0].getResult();
    }

    public void getReceivedByUserIdAsync(GetReceivedByUserIdRequest request, AsyncAction<AsyncResult<GetReceivedByUserIdResult>> callback) {
        GetReceivedByUserIdTask task = new GetReceivedByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetReceivedByUserIdResult getReceivedByUserId(GetReceivedByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getReceivedByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetReceivedByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void updateReceivedByUserIdAsync(UpdateReceivedByUserIdRequest request, AsyncAction<AsyncResult<UpdateReceivedByUserIdResult>> callback) {
        UpdateReceivedByUserIdTask task = new UpdateReceivedByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public UpdateReceivedByUserIdResult updateReceivedByUserId(UpdateReceivedByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateReceivedByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateReceivedByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteReceivedByUserIdAsync(DeleteReceivedByUserIdRequest request, AsyncAction<AsyncResult<DeleteReceivedByUserIdResult>> callback) {
        DeleteReceivedByUserIdTask task = new DeleteReceivedByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteReceivedByUserIdResult deleteReceivedByUserId(DeleteReceivedByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteReceivedByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteReceivedByUserIdResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("isAutomaticDeletingEnabled", CreateNamespaceTask.this.request.getIsAutomaticDeletingEnabled());
                    this.put("transactionSetting", CreateNamespaceTask.this.request.getTransactionSetting() != null ? CreateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("receiveMessageScript", CreateNamespaceTask.this.request.getReceiveMessageScript() != null ? CreateNamespaceTask.this.request.getReceiveMessageScript().toJson() : null);
                    this.put("readMessageScript", CreateNamespaceTask.this.request.getReadMessageScript() != null ? CreateNamespaceTask.this.request.getReadMessageScript().toJson() : null);
                    this.put("deleteMessageScript", CreateNamespaceTask.this.request.getDeleteMessageScript() != null ? CreateNamespaceTask.this.request.getDeleteMessageScript().toJson() : null);
                    this.put("receiveNotification", CreateNamespaceTask.this.request.getReceiveNotification() != null ? CreateNamespaceTask.this.request.getReceiveNotification().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("queueNamespaceId", CreateNamespaceTask.this.request.getQueueNamespaceId());
                    this.put("keyId", CreateNamespaceTask.this.request.getKeyId());
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("isAutomaticDeletingEnabled", UpdateNamespaceTask.this.request.getIsAutomaticDeletingEnabled());
                    this.put("transactionSetting", UpdateNamespaceTask.this.request.getTransactionSetting() != null ? UpdateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("receiveMessageScript", UpdateNamespaceTask.this.request.getReceiveMessageScript() != null ? UpdateNamespaceTask.this.request.getReceiveMessageScript().toJson() : null);
                    this.put("readMessageScript", UpdateNamespaceTask.this.request.getReadMessageScript() != null ? UpdateNamespaceTask.this.request.getReadMessageScript().toJson() : null);
                    this.put("deleteMessageScript", UpdateNamespaceTask.this.request.getDeleteMessageScript() != null ? UpdateNamespaceTask.this.request.getDeleteMessageScript().toJson() : null);
                    this.put("receiveNotification", UpdateNamespaceTask.this.request.getReceiveNotification() != null ? UpdateNamespaceTask.this.request.getReceiveNotification().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("queueNamespaceId", UpdateNamespaceTask.this.request.getQueueNamespaceId());
                    this.put("keyId", UpdateNamespaceTask.this.request.getKeyId());
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DumpUserDataByUserIdTask
    extends Gs2RestSessionTask<DumpUserDataByUserIdResult> {
        private DumpUserDataByUserIdRequest request;

        public DumpUserDataByUserIdTask(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DumpUserDataByUserIdResult parse(JsonNode data) {
            return DumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DumpUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckDumpUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckDumpUserDataByUserIdResult> {
        private CheckDumpUserDataByUserIdRequest request;

        public CheckDumpUserDataByUserIdTask(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckDumpUserDataByUserIdResult parse(JsonNode data) {
            return CheckDumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CleanUserDataByUserIdResult> {
        private CleanUserDataByUserIdRequest request;

        public CleanUserDataByUserIdTask(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CleanUserDataByUserIdResult parse(JsonNode data) {
            return CleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CleanUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckCleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckCleanUserDataByUserIdResult> {
        private CheckCleanUserDataByUserIdRequest request;

        public CheckCleanUserDataByUserIdTask(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckCleanUserDataByUserIdResult parse(JsonNode data) {
            return CheckCleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareImportUserDataByUserIdTask
    extends Gs2RestSessionTask<PrepareImportUserDataByUserIdResult> {
        private PrepareImportUserDataByUserIdRequest request;

        public PrepareImportUserDataByUserIdTask(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareImportUserDataByUserIdResult parse(JsonNode data) {
            return PrepareImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/prepare";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PrepareImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ImportUserDataByUserIdTask
    extends Gs2RestSessionTask<ImportUserDataByUserIdResult> {
        private ImportUserDataByUserIdRequest request;

        public ImportUserDataByUserIdTask(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ImportUserDataByUserIdResult parse(JsonNode data) {
            return ImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("uploadToken", ImportUserDataByUserIdTask.this.request.getUploadToken());
                    this.put("contextStack", ImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckImportUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckImportUserDataByUserIdResult> {
        private CheckImportUserDataByUserIdRequest request;

        public CheckImportUserDataByUserIdTask(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckImportUserDataByUserIdResult parse(JsonNode data) {
            return CheckImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/{uploadToken}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{uploadToken}", this.request.getUploadToken() == null || this.request.getUploadToken().length() == 0 ? "null" : String.valueOf(this.request.getUploadToken()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeMessagesTask
    extends Gs2RestSessionTask<DescribeMessagesResult> {
        private DescribeMessagesRequest request;

        public DescribeMessagesTask(DescribeMessagesRequest request, AsyncAction<AsyncResult<DescribeMessagesResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeMessagesResult parse(JsonNode data) {
            return DescribeMessagesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/message";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getIsRead() != null) {
                queryStrings.add("isRead=" + String.valueOf(this.request.getIsRead()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeMessagesByUserIdTask
    extends Gs2RestSessionTask<DescribeMessagesByUserIdResult> {
        private DescribeMessagesByUserIdRequest request;

        public DescribeMessagesByUserIdTask(DescribeMessagesByUserIdRequest request, AsyncAction<AsyncResult<DescribeMessagesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeMessagesByUserIdResult parse(JsonNode data) {
            return DescribeMessagesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/message";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getUserId())));
            }
            if (this.request.getIsRead() != null) {
                queryStrings.add("isRead=" + String.valueOf(this.request.getIsRead()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class SendMessageByUserIdTask
    extends Gs2RestSessionTask<SendMessageByUserIdResult> {
        private SendMessageByUserIdRequest request;

        public SendMessageByUserIdTask(SendMessageByUserIdRequest request, AsyncAction<AsyncResult<SendMessageByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SendMessageByUserIdResult parse(JsonNode data) {
            return SendMessageByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/message";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("metadata", SendMessageByUserIdTask.this.request.getMetadata());
                    this.put("readAcquireActions", SendMessageByUserIdTask.this.request.getReadAcquireActions() == null ? new ArrayList() : SendMessageByUserIdTask.this.request.getReadAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("expiresAt", SendMessageByUserIdTask.this.request.getExpiresAt());
                    this.put("expiresTimeSpan", SendMessageByUserIdTask.this.request.getExpiresTimeSpan() != null ? SendMessageByUserIdTask.this.request.getExpiresTimeSpan().toJson() : null);
                    this.put("contextStack", SendMessageByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class GetMessageTask
    extends Gs2RestSessionTask<GetMessageResult> {
        private GetMessageRequest request;

        public GetMessageTask(GetMessageRequest request, AsyncAction<AsyncResult<GetMessageResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetMessageResult parse(JsonNode data) {
            return GetMessageResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/{messageName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{messageName}", this.request.getMessageName() == null || this.request.getMessageName().length() == 0 ? "null" : String.valueOf(this.request.getMessageName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetMessageByUserIdTask
    extends Gs2RestSessionTask<GetMessageByUserIdResult> {
        private GetMessageByUserIdRequest request;

        public GetMessageByUserIdTask(GetMessageByUserIdRequest request, AsyncAction<AsyncResult<GetMessageByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetMessageByUserIdResult parse(JsonNode data) {
            return GetMessageByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/{messageName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{messageName}", this.request.getMessageName() == null || this.request.getMessageName().length() == 0 ? "null" : String.valueOf(this.request.getMessageName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ReceiveGlobalMessageTask
    extends Gs2RestSessionTask<ReceiveGlobalMessageResult> {
        private ReceiveGlobalMessageRequest request;

        public ReceiveGlobalMessageTask(ReceiveGlobalMessageRequest request, AsyncAction<AsyncResult<ReceiveGlobalMessageResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ReceiveGlobalMessageResult parse(JsonNode data) {
            return ReceiveGlobalMessageResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/message/globalMessage/receive";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", ReceiveGlobalMessageTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ReceiveGlobalMessageByUserIdTask
    extends Gs2RestSessionTask<ReceiveGlobalMessageByUserIdResult> {
        private ReceiveGlobalMessageByUserIdRequest request;

        public ReceiveGlobalMessageByUserIdTask(ReceiveGlobalMessageByUserIdRequest request, AsyncAction<AsyncResult<ReceiveGlobalMessageByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ReceiveGlobalMessageByUserIdResult parse(JsonNode data) {
            return ReceiveGlobalMessageByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/message/globalMessage/receive";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", ReceiveGlobalMessageByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class OpenMessageTask
    extends Gs2RestSessionTask<OpenMessageResult> {
        private OpenMessageRequest request;

        public OpenMessageTask(OpenMessageRequest request, AsyncAction<AsyncResult<OpenMessageResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public OpenMessageResult parse(JsonNode data) {
            return OpenMessageResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/{messageName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{messageName}", this.request.getMessageName() == null || this.request.getMessageName().length() == 0 ? "null" : String.valueOf(this.request.getMessageName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", OpenMessageTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class OpenMessageByUserIdTask
    extends Gs2RestSessionTask<OpenMessageByUserIdResult> {
        private OpenMessageByUserIdRequest request;

        public OpenMessageByUserIdTask(OpenMessageByUserIdRequest request, AsyncAction<AsyncResult<OpenMessageByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public OpenMessageByUserIdResult parse(JsonNode data) {
            return OpenMessageByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/{messageName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{messageName}", this.request.getMessageName() == null || this.request.getMessageName().length() == 0 ? "null" : String.valueOf(this.request.getMessageName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", OpenMessageByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ReadMessageTask
    extends Gs2RestSessionTask<ReadMessageResult> {
        private ReadMessageRequest request;

        public ReadMessageTask(ReadMessageRequest request, AsyncAction<AsyncResult<ReadMessageResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ReadMessageResult parse(JsonNode data) {
            return ReadMessageResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/{messageName}/read";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{messageName}", this.request.getMessageName() == null || this.request.getMessageName().length() == 0 ? "null" : String.valueOf(this.request.getMessageName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("config", ReadMessageTask.this.request.getConfig() == null ? new ArrayList() : ReadMessageTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", ReadMessageTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ReadMessageByUserIdTask
    extends Gs2RestSessionTask<ReadMessageByUserIdResult> {
        private ReadMessageByUserIdRequest request;

        public ReadMessageByUserIdTask(ReadMessageByUserIdRequest request, AsyncAction<AsyncResult<ReadMessageByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ReadMessageByUserIdResult parse(JsonNode data) {
            return ReadMessageByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/{messageName}/read";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{messageName}", this.request.getMessageName() == null || this.request.getMessageName().length() == 0 ? "null" : String.valueOf(this.request.getMessageName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("config", ReadMessageByUserIdTask.this.request.getConfig() == null ? new ArrayList() : ReadMessageByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", ReadMessageByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteMessageTask
    extends Gs2RestSessionTask<DeleteMessageResult> {
        private DeleteMessageRequest request;

        public DeleteMessageTask(DeleteMessageRequest request, AsyncAction<AsyncResult<DeleteMessageResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteMessageResult parse(JsonNode data) {
            return DeleteMessageResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/{messageName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{messageName}", this.request.getMessageName() == null || this.request.getMessageName().length() == 0 ? "null" : String.valueOf(this.request.getMessageName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteMessageByUserIdTask
    extends Gs2RestSessionTask<DeleteMessageByUserIdResult> {
        private DeleteMessageByUserIdRequest request;

        public DeleteMessageByUserIdTask(DeleteMessageByUserIdRequest request, AsyncAction<AsyncResult<DeleteMessageByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteMessageByUserIdResult parse(JsonNode data) {
            return DeleteMessageByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/{messageName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{messageName}", this.request.getMessageName() == null || this.request.getMessageName().length() == 0 ? "null" : String.valueOf(this.request.getMessageName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class SendByStampSheetTask
    extends Gs2RestSessionTask<SendByStampSheetResult> {
        private SendByStampSheetRequest request;

        public SendByStampSheetTask(SendByStampSheetRequest request, AsyncAction<AsyncResult<SendByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public SendByStampSheetResult parse(JsonNode data) {
            return SendByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/stamp/send";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", SendByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", SendByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", SendByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class OpenByStampTaskTask
    extends Gs2RestSessionTask<OpenByStampTaskResult> {
        private OpenByStampTaskRequest request;

        public OpenByStampTaskTask(OpenByStampTaskRequest request, AsyncAction<AsyncResult<OpenByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public OpenByStampTaskResult parse(JsonNode data) {
            return OpenByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/stamp/open";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", OpenByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", OpenByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", OpenByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteMessageByStampTaskTask
    extends Gs2RestSessionTask<DeleteMessageByStampTaskResult> {
        private DeleteMessageByStampTaskRequest request;

        public DeleteMessageByStampTaskTask(DeleteMessageByStampTaskRequest request, AsyncAction<AsyncResult<DeleteMessageByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteMessageByStampTaskResult parse(JsonNode data) {
            return DeleteMessageByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/stamp/delete";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", DeleteMessageByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", DeleteMessageByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", DeleteMessageByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentMessageMasterTask
    extends Gs2RestSessionTask<GetCurrentMessageMasterResult> {
        private GetCurrentMessageMasterRequest request;

        public GetCurrentMessageMasterTask(GetCurrentMessageMasterRequest request, AsyncAction<AsyncResult<GetCurrentMessageMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentMessageMasterResult parse(JsonNode data) {
            return GetCurrentMessageMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentMessageMasterTask
    extends Gs2RestSessionTask<UpdateCurrentMessageMasterResult> {
        private UpdateCurrentMessageMasterRequest request;

        public UpdateCurrentMessageMasterTask(UpdateCurrentMessageMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentMessageMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentMessageMasterResult parse(JsonNode data) {
            return UpdateCurrentMessageMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentMessageMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentMessageMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentMessageMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentMessageMasterFromGitHubResult> {
        private UpdateCurrentMessageMasterFromGitHubRequest request;

        public UpdateCurrentMessageMasterFromGitHubTask(UpdateCurrentMessageMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentMessageMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentMessageMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentMessageMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentMessageMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentMessageMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentMessageMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeGlobalMessageMastersTask
    extends Gs2RestSessionTask<DescribeGlobalMessageMastersResult> {
        private DescribeGlobalMessageMastersRequest request;

        public DescribeGlobalMessageMastersTask(DescribeGlobalMessageMastersRequest request, AsyncAction<AsyncResult<DescribeGlobalMessageMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeGlobalMessageMastersResult parse(JsonNode data) {
            return DescribeGlobalMessageMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/globalMessage";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateGlobalMessageMasterTask
    extends Gs2RestSessionTask<CreateGlobalMessageMasterResult> {
        private CreateGlobalMessageMasterRequest request;

        public CreateGlobalMessageMasterTask(CreateGlobalMessageMasterRequest request, AsyncAction<AsyncResult<CreateGlobalMessageMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateGlobalMessageMasterResult parse(JsonNode data) {
            return CreateGlobalMessageMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/globalMessage";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateGlobalMessageMasterTask.this.request.getName());
                    this.put("metadata", CreateGlobalMessageMasterTask.this.request.getMetadata());
                    this.put("readAcquireActions", CreateGlobalMessageMasterTask.this.request.getReadAcquireActions() == null ? new ArrayList() : CreateGlobalMessageMasterTask.this.request.getReadAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("expiresTimeSpan", CreateGlobalMessageMasterTask.this.request.getExpiresTimeSpan() != null ? CreateGlobalMessageMasterTask.this.request.getExpiresTimeSpan().toJson() : null);
                    this.put("expiresAt", CreateGlobalMessageMasterTask.this.request.getExpiresAt());
                    this.put("contextStack", CreateGlobalMessageMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetGlobalMessageMasterTask
    extends Gs2RestSessionTask<GetGlobalMessageMasterResult> {
        private GetGlobalMessageMasterRequest request;

        public GetGlobalMessageMasterTask(GetGlobalMessageMasterRequest request, AsyncAction<AsyncResult<GetGlobalMessageMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetGlobalMessageMasterResult parse(JsonNode data) {
            return GetGlobalMessageMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/globalMessage/{globalMessageName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{globalMessageName}", this.request.getGlobalMessageName() == null || this.request.getGlobalMessageName().length() == 0 ? "null" : String.valueOf(this.request.getGlobalMessageName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateGlobalMessageMasterTask
    extends Gs2RestSessionTask<UpdateGlobalMessageMasterResult> {
        private UpdateGlobalMessageMasterRequest request;

        public UpdateGlobalMessageMasterTask(UpdateGlobalMessageMasterRequest request, AsyncAction<AsyncResult<UpdateGlobalMessageMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateGlobalMessageMasterResult parse(JsonNode data) {
            return UpdateGlobalMessageMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/globalMessage/{globalMessageName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{globalMessageName}", this.request.getGlobalMessageName() == null || this.request.getGlobalMessageName().length() == 0 ? "null" : String.valueOf(this.request.getGlobalMessageName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("metadata", UpdateGlobalMessageMasterTask.this.request.getMetadata());
                    this.put("readAcquireActions", UpdateGlobalMessageMasterTask.this.request.getReadAcquireActions() == null ? new ArrayList() : UpdateGlobalMessageMasterTask.this.request.getReadAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("expiresTimeSpan", UpdateGlobalMessageMasterTask.this.request.getExpiresTimeSpan() != null ? UpdateGlobalMessageMasterTask.this.request.getExpiresTimeSpan().toJson() : null);
                    this.put("expiresAt", UpdateGlobalMessageMasterTask.this.request.getExpiresAt());
                    this.put("contextStack", UpdateGlobalMessageMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteGlobalMessageMasterTask
    extends Gs2RestSessionTask<DeleteGlobalMessageMasterResult> {
        private DeleteGlobalMessageMasterRequest request;

        public DeleteGlobalMessageMasterTask(DeleteGlobalMessageMasterRequest request, AsyncAction<AsyncResult<DeleteGlobalMessageMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteGlobalMessageMasterResult parse(JsonNode data) {
            return DeleteGlobalMessageMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/globalMessage/{globalMessageName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{globalMessageName}", this.request.getGlobalMessageName() == null || this.request.getGlobalMessageName().length() == 0 ? "null" : String.valueOf(this.request.getGlobalMessageName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeGlobalMessagesTask
    extends Gs2RestSessionTask<DescribeGlobalMessagesResult> {
        private DescribeGlobalMessagesRequest request;

        public DescribeGlobalMessagesTask(DescribeGlobalMessagesRequest request, AsyncAction<AsyncResult<DescribeGlobalMessagesResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeGlobalMessagesResult parse(JsonNode data) {
            return DescribeGlobalMessagesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/globalMessage";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetGlobalMessageTask
    extends Gs2RestSessionTask<GetGlobalMessageResult> {
        private GetGlobalMessageRequest request;

        public GetGlobalMessageTask(GetGlobalMessageRequest request, AsyncAction<AsyncResult<GetGlobalMessageResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetGlobalMessageResult parse(JsonNode data) {
            return GetGlobalMessageResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/globalMessage/{globalMessageName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{globalMessageName}", this.request.getGlobalMessageName() == null || this.request.getGlobalMessageName().length() == 0 ? "null" : String.valueOf(this.request.getGlobalMessageName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetReceivedByUserIdTask
    extends Gs2RestSessionTask<GetReceivedByUserIdResult> {
        private GetReceivedByUserIdRequest request;

        public GetReceivedByUserIdTask(GetReceivedByUserIdRequest request, AsyncAction<AsyncResult<GetReceivedByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetReceivedByUserIdResult parse(JsonNode data) {
            return GetReceivedByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/received";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateReceivedByUserIdTask
    extends Gs2RestSessionTask<UpdateReceivedByUserIdResult> {
        private UpdateReceivedByUserIdRequest request;

        public UpdateReceivedByUserIdTask(UpdateReceivedByUserIdRequest request, AsyncAction<AsyncResult<UpdateReceivedByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateReceivedByUserIdResult parse(JsonNode data) {
            return UpdateReceivedByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/received";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("receivedGlobalMessageNames", UpdateReceivedByUserIdTask.this.request.getReceivedGlobalMessageNames() == null ? new ArrayList() : UpdateReceivedByUserIdTask.this.request.getReceivedGlobalMessageNames().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", UpdateReceivedByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteReceivedByUserIdTask
    extends Gs2RestSessionTask<DeleteReceivedByUserIdResult> {
        private DeleteReceivedByUserIdRequest request;

        public DeleteReceivedByUserIdTask(DeleteReceivedByUserIdRequest request, AsyncAction<AsyncResult<DeleteReceivedByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2InboxRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteReceivedByUserIdResult parse(JsonNode data) {
            return DeleteReceivedByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "inbox").replace("{region}", Gs2InboxRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/received";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }
}

