/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.datastore.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import java.io.Serializable;
import java.util.HashMap;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ResponseCache
implements IModel,
Serializable,
Comparable<ResponseCache> {
    private String region;
    private String responseCacheId;
    private String requestHash;
    private String result;

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public ResponseCache withRegion(String region) {
        this.region = region;
        return this;
    }

    public String getResponseCacheId() {
        return this.responseCacheId;
    }

    public void setResponseCacheId(String responseCacheId) {
        this.responseCacheId = responseCacheId;
    }

    public ResponseCache withResponseCacheId(String responseCacheId) {
        this.responseCacheId = responseCacheId;
        return this;
    }

    public String getRequestHash() {
        return this.requestHash;
    }

    public void setRequestHash(String requestHash) {
        this.requestHash = requestHash;
    }

    public ResponseCache withRequestHash(String requestHash) {
        this.requestHash = requestHash;
        return this;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public ResponseCache withResult(String result) {
        this.result = result;
        return this;
    }

    public static ResponseCache fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new ResponseCache().withRegion(data.get("region") == null || data.get("region").isNull() ? null : data.get("region").asText()).withResponseCacheId(data.get("responseCacheId") == null || data.get("responseCacheId").isNull() ? null : data.get("responseCacheId").asText()).withRequestHash(data.get("requestHash") == null || data.get("requestHash").isNull() ? null : data.get("requestHash").asText()).withResult(data.get("result") == null || data.get("result").isNull() ? null : data.get("result").asText());
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("region", ResponseCache.this.getRegion());
                this.put("responseCacheId", ResponseCache.this.getResponseCacheId());
                this.put("requestHash", ResponseCache.this.getRequestHash());
                this.put("result", ResponseCache.this.getResult());
            }
        });
    }

    @Override
    public int compareTo(ResponseCache o) {
        return this.responseCacheId.compareTo(o.responseCacheId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.responseCacheId == null ? 0 : this.responseCacheId.hashCode());
        result = 31 * result + (this.requestHash == null ? 0 : this.requestHash.hashCode());
        result = 31 * result + (this.result == null ? 0 : this.result.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ResponseCache other = (ResponseCache)o;
        if (this.region == null) {
            return other.region == null;
        }
        if (!this.region.equals(other.region)) {
            return false;
        }
        if (this.responseCacheId == null) {
            return other.responseCacheId == null;
        }
        if (!this.responseCacheId.equals(other.responseCacheId)) {
            return false;
        }
        if (this.requestHash == null) {
            return other.requestHash == null;
        }
        if (!this.requestHash.equals(other.requestHash)) {
            return false;
        }
        if (this.result == null) {
            return other.result == null;
        }
        return this.result.equals(other.result);
    }
}

